/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.util;

import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ZyinHUDUtil {
    protected static Minecraft mc = Minecraft.func_71410_x();
    protected static final RenderItem itemRenderer = new RenderItem();
    protected static final TextureManager textureManager = mc.func_110434_K();

    public static boolean IsMouseoveredBlockRightClickable() {
        Block block;
        return ZyinHUDUtil.mc.field_71476_x != null && ZyinHUDUtil.mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && ZyinHUDUtil.IsBlockRightClickable(block = ZyinHUDUtil.mc.field_71441_e.func_147439_a(ZyinHUDUtil.mc.field_71476_x.field_72311_b, ZyinHUDUtil.mc.field_71476_x.field_72312_c, ZyinHUDUtil.mc.field_71476_x.field_72309_d));
    }

    public static boolean IsBlockRightClickable(Block block) {
        return block instanceof BlockContainer || block instanceof BlockButton || block instanceof BlockLever || block instanceof BlockRedstoneDiode || block instanceof BlockDoor || block instanceof BlockAnvil || block instanceof BlockBed || block instanceof BlockCake || block instanceof BlockFenceGate || block instanceof BlockTrapDoor || block instanceof BlockWorkbench;
    }

    public static void RenderFloatingIcon(Item item, float x, float y, float z, float partialTickTime) {
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontRenderer = ZyinHUDUtil.mc.field_71466_p;
        float playerX = (float)(ZyinHUDUtil.mc.field_71439_g.field_70142_S + (ZyinHUDUtil.mc.field_71439_g.field_70165_t - ZyinHUDUtil.mc.field_71439_g.field_70142_S) * (double)partialTickTime);
        float playerY = (float)(ZyinHUDUtil.mc.field_71439_g.field_70137_T + (ZyinHUDUtil.mc.field_71439_g.field_70163_u - ZyinHUDUtil.mc.field_71439_g.field_70137_T) * (double)partialTickTime);
        float playerZ = (float)(ZyinHUDUtil.mc.field_71439_g.field_70136_U + (ZyinHUDUtil.mc.field_71439_g.field_70161_v - ZyinHUDUtil.mc.field_71439_g.field_70136_U) * (double)partialTickTime);
        float dx = x - playerX;
        float dy = y - playerY;
        float dz = z - playerZ;
        float scale = 0.025f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)dx, (float)dy, (float)dz);
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        ResourceLocation resource = textureManager.func_130087_a(new ItemStack(item).func_94608_d());
        IIcon icon = new ItemStack(item).func_77954_c();
        textureManager.func_110577_a(resource);
        itemRenderer.func_94149_a(-8, -8, icon, 16, 16);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void RenderFloatingText(String text, float x, float y, float z, int color, boolean renderBlackBox, float partialTickTime) {
        String[] textArray = new String[]{text};
        ZyinHUDUtil.RenderFloatingText(textArray, x, y, z, color, renderBlackBox, partialTickTime);
    }

    public static void RenderFloatingText(String[] text, float x, float y, float z, int color, boolean renderBlackBox, float partialTickTime) {
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontRenderer = ZyinHUDUtil.mc.field_71466_p;
        float playerX = (float)(ZyinHUDUtil.mc.field_71439_g.field_70142_S + (ZyinHUDUtil.mc.field_71439_g.field_70165_t - ZyinHUDUtil.mc.field_71439_g.field_70142_S) * (double)partialTickTime);
        float playerY = (float)(ZyinHUDUtil.mc.field_71439_g.field_70137_T + (ZyinHUDUtil.mc.field_71439_g.field_70163_u - ZyinHUDUtil.mc.field_71439_g.field_70137_T) * (double)partialTickTime);
        float playerZ = (float)(ZyinHUDUtil.mc.field_71439_g.field_70136_U + (ZyinHUDUtil.mc.field_71439_g.field_70161_v - ZyinHUDUtil.mc.field_71439_g.field_70136_U) * (double)partialTickTime);
        float dx = x - playerX;
        float dy = y - playerY;
        float dz = z - playerZ;
        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        float multiplier = distance / 120.0f;
        float scale = 0.45f * multiplier;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)dx, (float)dy, (float)dz);
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int textWidth = 0;
        for (String thisMessage : text) {
            int thisMessageWidth = ZyinHUDUtil.mc.field_71466_p.func_78256_a(thisMessage);
            if (thisMessageWidth <= textWidth) continue;
            textWidth = thisMessageWidth;
        }
        int lineHeight = 10;
        if (renderBlackBox) {
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int stringMiddle = textWidth / 2;
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.5f);
            tessellator.func_78377_a((double)(-stringMiddle - 1), -1.0, 0.0);
            tessellator.func_78377_a((double)(-stringMiddle - 1), (double)(8 + lineHeight * text.length - lineHeight), 0.0);
            tessellator.func_78377_a((double)(stringMiddle + 1), (double)(8 + lineHeight * text.length - lineHeight), 0.0);
            tessellator.func_78377_a((double)(stringMiddle + 1), -1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
        int i = 0;
        for (String message : text) {
            fontRenderer.func_78276_b(message, -textWidth / 2, i * lineHeight, color);
            ++i;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void DrawTexture(int x, int y, int u, int v, int width, int height, ResourceLocation resourceLocation, float scaler) {
        x = (int)((float)x / scaler);
        y = (int)((float)y / scaler);
        GL11.glPushMatrix();
        GL11.glScalef((float)scaler, (float)scaler, (float)scaler);
        mc.func_110434_K().func_110577_a(resourceLocation);
        ZyinHUDUtil.mc.field_71456_v.func_73729_b(x, y, u, v, width, height);
        GL11.glPopMatrix();
    }

    public static <T, E> T GetFieldByReflection(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        Field field = null;
        for (String fieldName : fieldNames) {
            try {
                field = classToAccess.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            if (field != null) break;
        }
        if (field != null) {
            field.setAccessible(true);
            Object fieldT = null;
            try {
                fieldT = field.get(instance);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            return (T)fieldT;
        }
        return null;
    }
}

