/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.util;

import com.zyin.zyinhud.mods.QuickDeposit;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.gui.inventory.GuiScreenHorseInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class InventoryUtil {
    private static Minecraft mc = Minecraft.func_71410_x();
    private Timer timer = new Timer();
    private static int suggestedItemSwapDelay;
    public static InventoryUtil instance;

    private InventoryUtil() {
        suggestedItemSwapDelay = InventoryUtil.GetSuggestedItemSwapDelay();
    }

    public static int GetSuggestedItemSwapDelay() {
        if (mc.func_71356_B()) {
            suggestedItemSwapDelay = 150;
            return 150;
        }
        suggestedItemSwapDelay = 450;
        return 450;
    }

    public static boolean UseItem(Object object) {
        int hotbarIndex = InventoryUtil.GetItemIndexFromHotbar(object);
        if (hotbarIndex < 0) {
            int inventoryIndex = InventoryUtil.GetItemIndexFromInventory(object);
            if (inventoryIndex < 0) {
                return false;
            }
            return InventoryUtil.UseItemInInventory(object);
        }
        return InventoryUtil.UseItemInHotbar(object);
    }

    public static boolean UseItemInHotbar(Object object) {
        int itemHotbarIndex = InventoryUtil.GetItemIndexFromHotbar(object);
        return InventoryUtil.UseItemInHotbar(object, itemHotbarIndex);
    }

    public static boolean UseItemInHotbar(Object object, int itemSlotIndex) {
        if (itemSlotIndex < 36 || itemSlotIndex > 44) {
            return false;
        }
        int itemToUseHotbarIndex = InventoryUtil.TranslateInventoryIndexToHotbarIndex(itemSlotIndex);
        int previouslySelectedHotbarSlotIndex = InventoryUtil.mc.field_71439_g.field_71071_by.field_70461_c;
        InventoryUtil.mc.field_71439_g.field_71071_by.field_70461_c = itemToUseHotbarIndex;
        if (object instanceof Item) {
            InventoryUtil.SendUseItem();
        } else if (object instanceof Block) {
            InventoryUtil.SendUseBlock();
        }
        InventoryUtil.mc.field_71439_g.field_71071_by.field_70461_c = previouslySelectedHotbarSlotIndex;
        return true;
    }

    public static boolean UseItemInInventory(Object object) {
        int itemInventoryIndex = InventoryUtil.GetItemIndexFromInventory(object);
        return InventoryUtil.UseItemInInventory(object, itemInventoryIndex);
    }

    public static boolean UseItemInInventory(Object object, int itemSlotIndex) {
        if (itemSlotIndex < 0 || itemSlotIndex > 35) {
            return false;
        }
        int currentItemInventoryIndex = InventoryUtil.TranslateHotbarIndexToInventoryIndex(InventoryUtil.mc.field_71439_g.field_71071_by.field_70461_c);
        InventoryUtil.Swap(itemSlotIndex, currentItemInventoryIndex);
        if (object instanceof Item) {
            InventoryUtil.SendUseItem();
        } else if (object instanceof Block) {
            InventoryUtil.SendUseBlock();
        }
        instance.SwapWithDelay(itemSlotIndex, currentItemInventoryIndex, InventoryUtil.GetSuggestedItemSwapDelay());
        return true;
    }

    public static void SendUseItem() {
        InventoryUtil.mc.field_71442_b.func_78769_a((EntityPlayer)InventoryUtil.mc.field_71439_g, (World)InventoryUtil.mc.field_71441_e, InventoryUtil.mc.field_71439_g.func_70694_bm());
    }

    public static void SendUseBlock() {
        InventoryUtil.mc.field_71442_b.func_78760_a((EntityPlayer)InventoryUtil.mc.field_71439_g, (World)InventoryUtil.mc.field_71441_e, InventoryUtil.mc.field_71439_g.func_70694_bm(), InventoryUtil.mc.field_71476_x.field_72311_b, InventoryUtil.mc.field_71476_x.field_72312_c, InventoryUtil.mc.field_71476_x.field_72309_d, InventoryUtil.mc.field_71476_x.field_72310_e, InventoryUtil.mc.field_71476_x.field_72307_f);
    }

    public TimerTask SwapWithDelay(int srcIndex, int destIndex, int delay) {
        SwapTimerTask swapTimerTask = new SwapTimerTask(srcIndex, destIndex);
        this.timer.schedule((TimerTask)swapTimerTask, delay);
        return swapTimerTask;
    }

    public static boolean Swap(int srcIndex, int destIndex) {
        int emptyIndex;
        if (srcIndex == destIndex) {
            return false;
        }
        List inventorySlots = InventoryUtil.mc.field_71439_g.field_71069_bz.field_75151_b;
        ItemStack srcStack = ((Slot)inventorySlots.get(srcIndex)).func_75211_c();
        ItemStack destStack = ((Slot)inventorySlots.get(destIndex)).func_75211_c();
        ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
        if (handStack != null) {
            emptyIndex = InventoryUtil.GetFirstEmptyIndexInInventory();
            if (emptyIndex < 0) {
                emptyIndex = 1;
            }
            InventoryUtil.LeftClickInventorySlot(emptyIndex);
        }
        if (srcStack == null && destStack == null) {
            return false;
        }
        if (srcStack == null && destStack != null) {
            InventoryUtil.LeftClickInventorySlot(destIndex);
            InventoryUtil.LeftClickInventorySlot(srcIndex);
            return true;
        }
        if (srcStack != null && destStack == null) {
            InventoryUtil.LeftClickInventorySlot(srcIndex);
            InventoryUtil.LeftClickInventorySlot(destIndex);
            return true;
        }
        emptyIndex = 1;
        InventoryUtil.LeftClickInventorySlot(srcIndex);
        InventoryUtil.LeftClickInventorySlot(emptyIndex);
        InventoryUtil.LeftClickInventorySlot(destIndex);
        InventoryUtil.LeftClickInventorySlot(srcIndex);
        InventoryUtil.LeftClickInventorySlot(emptyIndex);
        InventoryUtil.LeftClickInventorySlot(destIndex);
        return true;
    }

    public static boolean DepositAllMatchingItemsInContainer(boolean ignoreItemsInHotbar) {
        int numInventorySlots;
        ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
        if (handStack != null) {
            int emptyIndex;
            if (!QuickDeposit.IsAllowedToBeDepositedInContainer(handStack)) {
                emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainerInventory();
                if (emptyIndex < 0) {
                    return false;
                }
                InventoryUtil.LeftClickContainerSlot(emptyIndex);
            } else {
                emptyIndex = InventoryUtil.GetFirstItemIndexInContainer(handStack);
                if (emptyIndex < 0) {
                    emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainerInventory();
                    if (emptyIndex < 0) {
                        return false;
                    }
                    InventoryUtil.LeftClickContainerSlot(emptyIndex);
                } else {
                    InventoryUtil.LeftClickContainerSlot(emptyIndex);
                    handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
                    while (handStack != null) {
                        emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainer(handStack);
                        if (emptyIndex < 0) {
                            return false;
                        }
                        InventoryUtil.LeftClickContainerSlot(emptyIndex);
                        handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
                    }
                }
            }
        }
        List chestSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        int numDisplayedSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.size();
        int numChestSlots = numDisplayedSlots - (numInventorySlots = 36);
        if (numChestSlots <= 0) {
            return false;
        }
        int iStart = numChestSlots;
        int iEnd = numDisplayedSlots;
        if (ignoreItemsInHotbar) {
            iEnd -= 9;
        }
        for (int i = iStart; i < iEnd; ++i) {
            int itemIndex;
            Slot slot = (Slot)chestSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null || (itemIndex = InventoryUtil.GetFirstItemIndexInContainer(itemStack)) < 0) continue;
            InventoryUtil.DepositItemInContainer(i, itemIndex);
        }
        return true;
    }

    public static boolean DepositItemInContainer(int srcIndex, int destIndex) {
        int numInventorySlots;
        int numDisplayedSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.size();
        int numContainerSlots = numDisplayedSlots - (numInventorySlots = 36);
        if (numContainerSlots == 53 && (srcIndex < 18 || srcIndex > 53)) {
            return false;
        }
        if (numContainerSlots == 63 && (srcIndex < 28 || srcIndex > 63)) {
            return false;
        }
        if (numContainerSlots == 90 && (srcIndex < 55 || srcIndex > 90)) {
            return false;
        }
        if (numContainerSlots == 53 && (destIndex < 0 || destIndex > 17)) {
            return false;
        }
        if (numContainerSlots == 63 && (destIndex < 0 || destIndex > 27)) {
            return false;
        }
        if (numContainerSlots == 90 && (destIndex < 0 || destIndex > 54)) {
            return false;
        }
        ItemStack srcStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(srcIndex)).func_75211_c();
        ItemStack destStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(destIndex)).func_75211_c();
        if (!QuickDeposit.IsAllowedToBeDepositedInContainer(srcStack)) {
            return true;
        }
        if (srcStack == null && destStack == null) {
            return false;
        }
        if (srcStack == null && destStack != null) {
            return false;
        }
        if (srcStack != null && destStack == null) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            return true;
        }
        if (srcStack.func_77973_b() != destStack.func_77973_b()) {
            return false;
        }
        if (destStack.field_77994_a == destStack.func_77976_d()) {
            int emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainer(destStack);
            if (emptyIndex < 0) {
                return false;
            }
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(emptyIndex);
            ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            while (handStack != null) {
                emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainer(destStack);
                if (emptyIndex < 0) {
                    InventoryUtil.LeftClickContainerSlot(srcIndex);
                    return false;
                }
                InventoryUtil.LeftClickContainerSlot(emptyIndex);
                handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            }
            return true;
        }
        if (srcStack.field_77994_a + destStack.field_77994_a > destStack.func_77976_d()) {
            int emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainer(destStack);
            if (emptyIndex < 0) {
                InventoryUtil.LeftClickContainerSlot(destIndex);
                InventoryUtil.LeftClickContainerSlot(srcIndex);
                return false;
            }
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            while (handStack != null) {
                emptyIndex = InventoryUtil.GetFirstEmptyIndexInContainer(destStack);
                if (emptyIndex < 0) {
                    InventoryUtil.LeftClickContainerSlot(srcIndex);
                    return false;
                }
                InventoryUtil.LeftClickContainerSlot(emptyIndex);
                handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            }
            return true;
        }
        InventoryUtil.LeftClickContainerSlot(srcIndex);
        InventoryUtil.LeftClickContainerSlot(destIndex);
        return true;
    }

    public static boolean DepositAllMatchingItemsInMerchant() {
        if (!(InventoryUtil.mc.field_71462_r instanceof GuiMerchant)) {
            return false;
        }
        int numDisplayedSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.size();
        int numInventorySlots = 36;
        int numMerchantSlots = numDisplayedSlots - numInventorySlots;
        GuiMerchant guiMerchant = (GuiMerchant)InventoryUtil.mc.field_71462_r;
        MerchantRecipeList merchantRecipeList = guiMerchant.func_147035_g().func_70934_b((EntityPlayer)InventoryUtil.mc.field_71439_g);
        if (merchantRecipeList == null || merchantRecipeList.isEmpty()) {
            return false;
        }
        int currentRecipeIndex = (Integer)ZyinHUDUtil.GetFieldByReflection(GuiMerchant.class, guiMerchant, "currentRecipeIndex", "field_70473_e", "field_147041_z");
        MerchantRecipe merchantRecipe = (MerchantRecipe)merchantRecipeList.get(currentRecipeIndex);
        ItemStack buyingItemStack1 = merchantRecipe.func_77394_a();
        ItemStack buyingItemStack2 = merchantRecipe.func_77396_b();
        ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
        if (handStack != null) {
            if (buyingItemStack1 != null && handStack.func_77969_a(buyingItemStack1)) {
                InventoryUtil.LeftClickContainerSlot(0);
            } else if (buyingItemStack2 != null && handStack.func_77969_a(buyingItemStack2)) {
                InventoryUtil.LeftClickContainerSlot(1);
            }
        }
        List merchantSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        int iStart = numMerchantSlots;
        int iEnd = numDisplayedSlots;
        for (int i = iStart; i < iEnd; ++i) {
            Slot slot = (Slot)merchantSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null) continue;
            if (buyingItemStack1 != null && itemStack.func_77969_a(buyingItemStack1)) {
                InventoryUtil.DepositItemInMerchant(i, 0);
                continue;
            }
            if (buyingItemStack2 == null || !itemStack.func_77969_a(buyingItemStack2)) continue;
            InventoryUtil.DepositItemInMerchant(i, 1);
        }
        return true;
    }

    private static boolean DepositItemInMerchant(int srcIndex, int destIndex) {
        if (destIndex < 0 || destIndex > 1) {
            return false;
        }
        if (srcIndex < 3 || srcIndex > 39) {
            return false;
        }
        ItemStack srcStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(srcIndex)).func_75211_c();
        ItemStack destStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(destIndex)).func_75211_c();
        if (srcStack == null && destStack == null) {
            return false;
        }
        if (srcStack == null && destStack != null) {
            return false;
        }
        if (srcStack != null && destStack == null) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            return true;
        }
        if (destStack.func_77969_a(srcStack)) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            if (handStack != null) {
                InventoryUtil.LeftClickContainerSlot(srcIndex);
            }
            return true;
        }
        return false;
    }

    public static boolean DepositAllMatchingItemsInFurance() {
        if (!(InventoryUtil.mc.field_71462_r instanceof GuiFurnace)) {
            return false;
        }
        int numDisplayedSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.size();
        int numInventorySlots = 36;
        int numFurnaceSlots = numDisplayedSlots - numInventorySlots;
        List furanceSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        ItemStack inputStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(0)).func_75211_c();
        ItemStack fueldStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(1)).func_75211_c();
        ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
        if (handStack != null) {
            if (inputStack != null && handStack.func_77969_a(inputStack)) {
                InventoryUtil.LeftClickContainerSlot(0);
            } else if (fueldStack != null && handStack.func_77969_a(fueldStack)) {
                InventoryUtil.LeftClickContainerSlot(1);
            }
        }
        int iStart = numFurnaceSlots;
        int iEnd = numDisplayedSlots;
        for (int i = iStart; i < iEnd; ++i) {
            Slot slot = (Slot)furanceSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null) continue;
            if (inputStack != null && itemStack.func_77969_a(inputStack)) {
                InventoryUtil.DepositItemInFurance(i, 0);
                continue;
            }
            if (fueldStack == null || !itemStack.func_77969_a(fueldStack)) continue;
            InventoryUtil.DepositItemInFurance(i, 1);
        }
        return false;
    }

    private static boolean DepositItemInFurance(int srcIndex, int destIndex) {
        if (destIndex < 0 || destIndex > 1) {
            return false;
        }
        if (srcIndex < 3 || srcIndex > 39) {
            return false;
        }
        ItemStack srcStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(srcIndex)).func_75211_c();
        ItemStack destStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(destIndex)).func_75211_c();
        if (srcStack == null && destStack == null) {
            return false;
        }
        if (srcStack == null && destStack != null) {
            return false;
        }
        if (srcStack != null && destStack == null) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            return true;
        }
        if (destStack.func_77969_a(srcStack)) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            if (handStack != null) {
                InventoryUtil.LeftClickContainerSlot(srcIndex);
            }
            return true;
        }
        return false;
    }

    public static boolean DepositAllMatchingItemsInBrewingStand() {
        if (!(InventoryUtil.mc.field_71462_r instanceof GuiBrewingStand)) {
            return false;
        }
        int numDisplayedSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.size();
        int numInventorySlots = 36;
        int numFurnaceSlots = numDisplayedSlots - numInventorySlots;
        List brewingStandSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        ItemStack inputStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(3)).func_75211_c();
        ItemStack outputStack1 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(0)).func_75211_c();
        ItemStack outputStack2 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(1)).func_75211_c();
        ItemStack outputStack3 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(2)).func_75211_c();
        ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
        if (handStack != null) {
            if (inputStack != null && handStack.func_77969_a(inputStack)) {
                InventoryUtil.LeftClickContainerSlot(3);
            } else if (handStack.func_77960_j() == 0 && Items.field_151068_bn == handStack.func_77973_b()) {
                if (outputStack1 == null) {
                    InventoryUtil.LeftClickContainerSlot(0);
                    outputStack1 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(0)).func_75211_c();
                } else if (outputStack2 == null) {
                    InventoryUtil.LeftClickContainerSlot(1);
                    outputStack2 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(1)).func_75211_c();
                } else if (outputStack3 == null) {
                    InventoryUtil.LeftClickContainerSlot(2);
                    outputStack3 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(2)).func_75211_c();
                }
            }
        }
        int iStart = numFurnaceSlots;
        int iEnd = numDisplayedSlots;
        for (int i = iStart; i < iEnd; ++i) {
            Slot slot = (Slot)brewingStandSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null) continue;
            if (inputStack != null && itemStack.func_77969_a(inputStack)) {
                InventoryUtil.DepositItemInBrewingStand(i, 3);
                continue;
            }
            if (itemStack.func_77960_j() != 0 || Items.field_151068_bn != itemStack.func_77973_b()) continue;
            if (outputStack1 == null) {
                InventoryUtil.DepositItemInBrewingStand(i, 0);
                outputStack1 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(0)).func_75211_c();
                continue;
            }
            if (outputStack2 == null) {
                InventoryUtil.DepositItemInBrewingStand(i, 1);
                outputStack2 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(1)).func_75211_c();
                continue;
            }
            if (outputStack3 != null) continue;
            InventoryUtil.DepositItemInBrewingStand(i, 2);
            outputStack3 = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(2)).func_75211_c();
        }
        return true;
    }

    private static boolean DepositItemInBrewingStand(int srcIndex, int destIndex) {
        if (destIndex < 0 || destIndex > 3) {
            return false;
        }
        if (srcIndex < 5 || srcIndex > 39) {
            return false;
        }
        ItemStack srcStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(srcIndex)).func_75211_c();
        ItemStack destStack = ((Slot)InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b.get(destIndex)).func_75211_c();
        if (srcStack == null && destStack == null) {
            return false;
        }
        if (srcStack == null && destStack != null) {
            return false;
        }
        if (srcStack != null && destStack == null) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            return true;
        }
        if (destStack.func_77969_a(srcStack)) {
            InventoryUtil.LeftClickContainerSlot(srcIndex);
            InventoryUtil.LeftClickContainerSlot(destIndex);
            ItemStack handStack = InventoryUtil.mc.field_71439_g.field_71071_by.func_70445_o();
            if (handStack != null) {
                InventoryUtil.LeftClickContainerSlot(srcIndex);
            }
            return true;
        }
        return false;
    }

    public static int GetItemIndexFromInventory(Object object) {
        List inventorySlots = InventoryUtil.mc.field_71439_g.field_71069_bz.field_75151_b;
        for (int i = 9; i <= 35; ++i) {
            Slot slot = (Slot)inventorySlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null || (!(object instanceof Block) || Block.func_149634_a((Item)itemStack.func_77973_b()) != object) && (!(object instanceof Item) || itemStack.func_77973_b() != object)) continue;
            return i;
        }
        return -1;
    }

    public static int GetItemIndexFromHotbar(Object object) {
        List inventorySlots = InventoryUtil.mc.field_71439_g.field_71069_bz.field_75151_b;
        for (int i = 36; i <= 44; ++i) {
            Slot slot = (Slot)inventorySlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null || (!(object instanceof Block) || Block.func_149634_a((Item)itemStack.func_77973_b()) != object) && (!(object instanceof Item) || itemStack.func_77973_b() != object)) continue;
            return i;
        }
        return -1;
    }

    private static int GetFirstEmptyIndexInInventory() {
        List inventorySlots = InventoryUtil.mc.field_71439_g.field_71069_bz.field_75151_b;
        for (int i = 9; i <= 44; ++i) {
            Slot slot = (Slot)inventorySlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack != null) continue;
            return i;
        }
        return -1;
    }

    private static int GetFirstEmptyIndexInContainerInventory() {
        int numContainerSlots;
        List containerSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        int numDisplayedSlots = containerSlots.size();
        int numInventorySlots = 36;
        int iStart = numContainerSlots = numDisplayedSlots - numInventorySlots;
        int iEnd = numDisplayedSlots;
        for (int i = iStart; i <= iEnd - 1; ++i) {
            Slot slot = (Slot)containerSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack != null) continue;
            return i;
        }
        return -1;
    }

    private static int GetFirstEmptyIndexInContainer() {
        return InventoryUtil.GetFirstEmptyIndexInContainer(null);
    }

    private static int GetFirstEmptyIndexInContainer(ItemStack itemStackToMatch) {
        List containerSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        int numDisplayedSlots = containerSlots.size();
        int numInventorySlots = 36;
        int numContainerSlots = numDisplayedSlots - numInventorySlots;
        int iStart = 0;
        int iEnd = numContainerSlots;
        if (InventoryUtil.mc.field_71462_r instanceof GuiScreenHorseInventory) {
            iStart = 2;
        }
        int firstEmptyIndex = -1;
        int firstEmptyMatchingItemIdStack = -1;
        for (int i = iStart; i <= iEnd - 1; ++i) {
            Slot slot = (Slot)containerSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null && firstEmptyIndex == -1) {
                firstEmptyIndex = i;
                continue;
            }
            if (itemStack == null || itemStackToMatch == null || !itemStack.func_77969_a(itemStackToMatch) || itemStack.field_77994_a >= itemStack.func_77976_d() || firstEmptyMatchingItemIdStack != -1) continue;
            firstEmptyMatchingItemIdStack = i;
            break;
        }
        if (firstEmptyMatchingItemIdStack != -1) {
            return firstEmptyMatchingItemIdStack;
        }
        return firstEmptyIndex;
    }

    private static int GetFirstItemIndexInContainer(ItemStack itemStackToMatch) {
        List chestSlots = InventoryUtil.mc.field_71439_g.field_71070_bA.field_75151_b;
        int numDisplayedSlots = chestSlots.size();
        int numInventorySlots = 36;
        int numContainerSlots = numDisplayedSlots - numInventorySlots;
        int iStart = 0;
        int iEnd = numContainerSlots;
        if (InventoryUtil.mc.field_71462_r instanceof GuiScreenHorseInventory) {
            iStart = 2;
        }
        for (int i = iStart; i <= iEnd - 1; ++i) {
            Slot slot = (Slot)chestSlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null || !itemStack.func_77969_a(itemStackToMatch)) continue;
            return i;
        }
        return -1;
    }

    public static int GetCurrentlySelectedItemInventoryIndex() {
        return InventoryUtil.TranslateHotbarIndexToInventoryIndex(InventoryUtil.mc.field_71439_g.field_71071_by.field_70461_c);
    }

    public static boolean MoveArmorIntoPlayerInventory(int armorSlotIndex) {
        armorSlotIndex = 3 - armorSlotIndex + 5;
        int emptySlotIndex = InventoryUtil.GetFirstEmptyIndexInInventory();
        if (emptySlotIndex != -1) {
            return InventoryUtil.Swap(armorSlotIndex, emptySlotIndex);
        }
        return false;
    }

    public static boolean MoveHeldItemIntoPlayerInventory() {
        int heldItemSlotIndex = InventoryUtil.GetCurrentlySelectedItemInventoryIndex();
        int emptySlotIndex = InventoryUtil.GetFirstEmptyIndexInInventory();
        if (emptySlotIndex != -1) {
            return InventoryUtil.Swap(heldItemSlotIndex, emptySlotIndex);
        }
        return false;
    }

    public static int TranslateHotbarIndexToInventoryIndex(int hotbarIndex) {
        if (hotbarIndex < 0 || hotbarIndex > 8) {
            return -1;
        }
        return hotbarIndex + 36;
    }

    public static int TranslateInventoryIndexToHotbarIndex(int inventoryIndex) {
        if (inventoryIndex < 36 || inventoryIndex > 44) {
            return -1;
        }
        return inventoryIndex - 36;
    }

    private static void LeftClickInventorySlot(int itemIndex) {
        InventoryUtil.SendInventoryClick(itemIndex, false, false);
    }

    private static void LeftClickContainerSlot(int itemIndex) {
        InventoryUtil.SendContainerClick(itemIndex, false, false);
    }

    private static void SendInventoryClick(int itemIndex, boolean rightClick, boolean shiftHold) {
        if (itemIndex < 0 || itemIndex > 44) {
            return;
        }
        InventoryUtil.mc.field_71442_b.func_78753_a(InventoryUtil.mc.field_71439_g.field_71069_bz.field_75152_c, itemIndex, rightClick ? 1 : 0, shiftHold ? 1 : 0, (EntityPlayer)InventoryUtil.mc.field_71439_g);
    }

    private static void SendContainerClick(int itemIndex, boolean rightClick, boolean shiftHold) {
        if (itemIndex < 0 || itemIndex > 90) {
            return;
        }
        try {
            InventoryUtil.mc.field_71442_b.func_78753_a(InventoryUtil.mc.field_71439_g.field_71070_bA.field_75152_c, itemIndex, rightClick ? 1 : 0, shiftHold ? 1 : 0, (EntityPlayer)InventoryUtil.mc.field_71439_g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        instance = new InventoryUtil();
    }

    class SwapTimerTask
    extends TimerTask {
        private int srcIndex;
        private int destIndex;

        public SwapTimerTask(int srcIndex, int destIndex) {
            this.srcIndex = srcIndex;
            this.destIndex = destIndex;
        }

        @Override
        public void run() {
            InventoryUtil.Swap(this.srcIndex, this.destIndex);
        }
    }
}

