/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.gui.GuiZyinHUDOptions;
import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.Localization;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PotionTimers
extends ZyinHUDModBase {
    public static boolean Enabled;
    private static final ResourceLocation inventoryResourceLocation;
    public static boolean ShowPotionIcons;
    public static boolean UsePotionColors;
    public static float PotionScale;
    public static boolean HidePotionEffectsInInventory;
    protected static final int[] blinkingThresholds;
    protected static final int[] blinkingSpeed;
    protected static final int[] blinkingDuration;
    protected static int potionLocX;
    protected static int potionLocY;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    public static void RenderOntoHUD() {
        if (Enabled && PotionTimers.mc.field_71415_G || PotionTimers.mc.field_71462_r != null && (PotionTimers.mc.field_71462_r instanceof GuiChat || PotionTimers.TabIsSelectedInOptionsGui()) && !PotionTimers.mc.field_71474_y.field_74330_P) {
            Collection potionEffects = PotionTimers.mc.field_71439_g.func_70651_bq();
            Iterator it = potionEffects.iterator();
            int x = potionLocX;
            int y = potionLocY;
            x = (int)((float)x / PotionScale);
            y = (int)((float)y / PotionScale);
            GL11.glScalef((float)PotionScale, (float)PotionScale, (float)PotionScale);
            int i = 0;
            while (it.hasNext()) {
                PotionEffect potionEffect = (PotionEffect)it.next();
                Potion potion = Potion.field_76425_a[potionEffect.func_76456_a()];
                Boolean isFromBeacon = potionEffect.func_82720_e();
                if (isFromBeacon.booleanValue()) continue;
                if (ShowPotionIcons) {
                    PotionTimers.DrawPotionIcon(x, y, potion);
                    PotionTimers.DrawPotionDuration(x + 10, y, potion, potionEffect);
                } else {
                    PotionTimers.DrawPotionDuration(x, y, potion, potionEffect);
                }
                y += 10;
                ++i;
            }
            GL11.glScalef((float)(1.0f / PotionScale), (float)(1.0f / PotionScale), (float)(1.0f / PotionScale));
        }
    }

    protected static void DrawPotionDuration(int x, int y, Potion potion, PotionEffect potionEffect) {
        String durationString = Potion.func_76389_a((PotionEffect)potionEffect);
        int potionDuration = potionEffect.func_76459_b();
        int colorInt = 0xFFFFFF;
        if (UsePotionColors) {
            colorInt = potion.func_76401_j();
        }
        boolean unicodeFlag = PotionTimers.mc.field_71466_p.func_82883_a();
        PotionTimers.mc.field_71466_p.func_78264_a(true);
        if (potionDuration >= blinkingThresholds[blinkingThresholds.length - 1]) {
            PotionTimers.mc.field_71466_p.func_78261_a(durationString, x, y, colorInt);
        } else {
            for (int j = 0; j < blinkingThresholds.length; ++j) {
                if (potionDuration >= blinkingThresholds[j]) continue;
                if (potionDuration % blinkingSpeed[j] <= blinkingDuration[j]) break;
                PotionTimers.mc.field_71466_p.func_78261_a(durationString, x, y, colorInt);
                break;
            }
        }
        PotionTimers.mc.field_71466_p.func_78264_a(unicodeFlag);
    }

    protected static void DrawPotionIcon(int x, int y, Potion potion) {
        int iconIndex = potion.func_76392_e();
        int u = iconIndex % 8 * 18;
        int v = 198 + iconIndex / 8 * 18;
        int width = 18;
        int height = 18;
        float scaler = 0.5f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ZyinHUDUtil.DrawTexture(x, y, u, v, width, height, inventoryResourceLocation, scaler);
    }

    public static void DisableInventoryPotionEffects(InventoryEffectRenderer guiScreen) {
        boolean playerHasPotionEffects;
        if (Enabled && HidePotionEffectsInInventory && (playerHasPotionEffects = ((Boolean)ObfuscationReflectionHelper.getPrivateValue(InventoryEffectRenderer.class, (Object)guiScreen, (String[])new String[]{"field_147045_u"})).booleanValue())) {
            int guiLeftPx = (guiScreen.field_146294_l - 176) / 2;
            ObfuscationReflectionHelper.setPrivateValue(GuiContainer.class, (Object)guiScreen, (Object)guiLeftPx, (String[])new String[]{"field_147003_i", "guiLeft"});
            ObfuscationReflectionHelper.setPrivateValue(InventoryEffectRenderer.class, (Object)guiScreen, (Object)false, (String[])new String[]{"field_147045_u"});
        }
    }

    private static boolean TabIsSelectedInOptionsGui() {
        return PotionTimers.mc.field_71462_r instanceof GuiZyinHUDOptions && ((GuiZyinHUDOptions)PotionTimers.mc.field_71462_r).IsButtonTabSelected(Localization.get("potiontimers.name"));
    }

    public static boolean ToggleShowPotionIcons() {
        ShowPotionIcons = !ShowPotionIcons;
        return ShowPotionIcons;
    }

    public static boolean ToggleUsePotionColors() {
        UsePotionColors = !UsePotionColors;
        return UsePotionColors;
    }

    public static boolean ToggleHidePotionEffectsInInventory() {
        HidePotionEffectsInInventory = !HidePotionEffectsInInventory;
        return HidePotionEffectsInInventory;
    }

    public static int GetHorizontalLocation() {
        return potionLocX;
    }

    public static int SetHorizontalLocation(int x) {
        potionLocX = MathHelper.func_76125_a((int)x, (int)0, (int)PotionTimers.mc.field_71443_c);
        return potionLocX;
    }

    public static int GetVerticalLocation() {
        return potionLocY;
    }

    public static int SetVerticalLocation(int y) {
        potionLocY = MathHelper.func_76125_a((int)y, (int)0, (int)PotionTimers.mc.field_71440_d);
        return potionLocY;
    }

    static {
        inventoryResourceLocation = new ResourceLocation("textures/gui/container/inventory.png");
        blinkingThresholds = new int[]{60, 120, 320};
        blinkingSpeed = new int[]{5, 10, 20};
        blinkingDuration = new int[]{2, 3, 3};
        potionLocX = 1;
        potionLocY = 16;
    }
}

