/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.mods.InfoLine;
import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.InventoryUtil;
import com.zyin.zyinhud.util.Localization;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ItemSelector
extends ZyinHUDModBase {
    public static boolean Enabled;
    public static Modes Mode;
    public static boolean UseMouseSideButtons;
    private static final ResourceLocation widgetTexture;
    public static final int WHEEL_UP = -1;
    public static final int WHEEL_DOWN = 1;
    protected static int timeout;
    public static final int defaultTimeout = 200;
    public static final int minTimeout = 50;
    public static final int maxTimeout = 500;
    private static int[] slotMemory;
    private static int ticksToShow;
    private static boolean selecting;
    private static int scrollAmount;
    private static int previousDir;
    private static int targetInvSlot;
    private static int currentHotbarSlot;
    private static ItemStack[] currentInventory;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    public static int GetTimeout() {
        return timeout;
    }

    public static void SetTimeout(int value) {
        timeout = MathHelper.func_76125_a((int)value, (int)50, (int)500);
    }

    public static void Scroll(int direction) {
        if (currentInventory == null) {
            currentHotbarSlot = ItemSelector.mc.field_71439_g.field_71071_by.field_70461_c;
            currentInventory = (ItemStack[])ItemSelector.mc.field_71439_g.field_71071_by.field_70462_a.clone();
        }
        if (!ItemSelector.adjustSlot(direction)) {
            ItemSelector.Done();
            return;
        }
        ItemSelector.slotMemory[ItemSelector.currentHotbarSlot] = targetInvSlot;
        ++scrollAmount;
        ticksToShow = timeout;
        selecting = true;
    }

    public static void SideButton(int direction) {
        currentHotbarSlot = ItemSelector.mc.field_71439_g.field_71071_by.field_70461_c;
        currentInventory = (ItemStack[])ItemSelector.mc.field_71439_g.field_71071_by.field_70462_a.clone();
        if (ItemSelector.adjustSlot(direction)) {
            ItemSelector.slotMemory[ItemSelector.currentHotbarSlot] = targetInvSlot;
            ItemSelector.SelectItem();
        } else {
            ItemSelector.Done();
        }
    }

    static boolean adjustSlot(int direction) {
        if (!mc.func_71356_B() && currentInventory[currentHotbarSlot] != null && currentInventory[currentHotbarSlot].func_77948_v()) {
            InfoLine.DisplayNotification(Localization.get("itemselector.error.enchant"));
            return false;
        }
        int memory = slotMemory[currentHotbarSlot];
        for (int i = 0; i < 36; ++i) {
            if (scrollAmount != 0 || previousDir == direction) {
                memory += direction;
            }
            if (memory < 9 || memory >= 36) {
                memory = direction == 1 ? 9 : 35;
            }
            previousDir = direction;
            if (Mode == Modes.SAME_COLUMN && memory % 9 != currentHotbarSlot || currentInventory[memory] == null || !mc.func_71356_B() && currentInventory[memory].func_77948_v()) continue;
            targetInvSlot = memory;
            break;
        }
        if (targetInvSlot == -1) {
            InfoLine.DisplayNotification(Localization.get("itemselector.error.empty"));
            return false;
        }
        return true;
    }

    public static void OnHotkeyReleased() {
        if (!Enabled) {
            return;
        }
        if (selecting) {
            ItemSelector.SelectItem();
        }
    }

    public static void RenderOntoHUD(float partialTicks) {
        if (!selecting) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(ItemSelector.mc.field_71474_y, ItemSelector.mc.field_71443_c, ItemSelector.mc.field_71440_d);
        int screenWidth = scaledresolution.func_78326_a();
        int screenHeight = scaledresolution.func_78328_b();
        int invWidth = 182;
        int invHeight = 66;
        int originX = screenWidth / 2 - invWidth / 2;
        int originZ = screenHeight - invHeight - 48;
        String labelText = currentInventory[targetInvSlot].func_82833_r();
        int labelWidth = ItemSelector.mc.field_71466_p.func_78256_a(labelText);
        ItemSelector.mc.field_71466_p.func_85187_a(labelText, screenWidth / 2 - labelWidth / 2, originZ - ItemSelector.mc.field_71466_p.field_78288_b - 2, -22016, true);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        RenderHelper.func_74520_c();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        int idx = 0;
        for (int z = 0; z < 3; ++z) {
            for (int x = 0; x < 9; ++x) {
                ItemStack itemStack;
                if (Mode == Modes.SAME_COLUMN && x != currentHotbarSlot) {
                    ++idx;
                    continue;
                }
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                if (idx + 9 == targetInvSlot) {
                    GL11.glEnable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    ZyinHUDUtil.DrawTexture(originX + x * 20 - 1, originZ + z * 22 - 1, 0, 22, 24, 24, widgetTexture, 1.0f);
                    GL11.glDisable((int)3042);
                }
                if ((itemStack = currentInventory[idx + 9]) != null) {
                    float anim = (float)itemStack.field_77992_b - partialTicks;
                    int dimX = originX + x * 20 + 3;
                    int dimZ = originZ + z * 22 + 3;
                    if (anim > 0.0f) {
                        GL11.glPushMatrix();
                        float f2 = 1.0f + anim / 5.0f;
                        GL11.glTranslatef((float)(dimX + 8), (float)(dimZ + 12), (float)0.0f);
                        GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
                        GL11.glTranslatef((float)(-(dimX + 8)), (float)(-(dimZ + 12)), (float)0.0f);
                    }
                    itemRenderer.func_82406_b(ItemSelector.mc.field_71466_p, mc.func_110434_K(), itemStack, dimX, dimZ);
                    if (anim > 0.0f) {
                        GL11.glPopMatrix();
                    }
                    itemRenderer.func_77021_b(ItemSelector.mc.field_71466_p, mc.func_110434_K(), itemStack, dimX, dimZ);
                }
                ++idx;
            }
        }
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        if (--ticksToShow <= 0) {
            ItemSelector.Done();
        }
    }

    private static void SelectItem() {
        ItemStack currentStack = ItemSelector.mc.field_71439_g.field_71071_by.field_70462_a[currentHotbarSlot];
        ItemStack targetStack = ItemSelector.mc.field_71439_g.field_71071_by.field_70462_a[targetInvSlot];
        if (targetStack != null) {
            if (!mc.func_71356_B() && (currentStack != null && currentStack.func_77948_v() || targetStack.func_77948_v())) {
                InfoLine.DisplayNotification(Localization.get("itemselector.error.enchant"));
                ItemSelector.Done();
                return;
            }
            int currentInvSlot = InventoryUtil.TranslateHotbarIndexToInventoryIndex(currentHotbarSlot);
            InventoryUtil.Swap(currentInvSlot, targetInvSlot);
        } else {
            InfoLine.DisplayNotification(Localization.get("itemselector.error.emptyslot"));
        }
        ItemSelector.Done();
    }

    private static void Done() {
        targetInvSlot = -1;
        scrollAmount = 0;
        currentHotbarSlot = 0;
        currentInventory = null;
        ticksToShow = 0;
        selecting = false;
    }

    public static boolean ToggleUseMouseSideButtons() {
        UseMouseSideButtons = !UseMouseSideButtons;
        return UseMouseSideButtons;
    }

    static {
        widgetTexture = new ResourceLocation("textures/gui/widgets.png");
        slotMemory = new int[9];
        ticksToShow = 0;
        selecting = false;
        scrollAmount = 0;
        previousDir = 0;
        targetInvSlot = -1;
        currentHotbarSlot = 0;
        currentInventory = null;
    }

    public static enum Modes {
        ALL(Localization.get("itemselector.mode.all")),
        SAME_COLUMN(Localization.get("itemselector.mode.column"));

        private String friendlyName;

        private Modes(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static Modes ToggleMode() {
            Mode = Mode.ordinal() < Modes.values().length - 1 ? Modes.values()[Mode.ordinal() + 1] : Modes.values()[0];
            return Mode;
        }

        public static Modes GetMode(String modeName) {
            try {
                return Modes.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                return Modes.values()[0];
            }
        }

        public String GetFriendlyName() {
            return this.friendlyName;
        }
    }
}

