/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.Localization;
import net.minecraft.util.MovingObjectPosition;

public class DistanceMeasurer
extends ZyinHUDModBase {
    public static boolean Enabled;
    public static Modes Mode;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    protected static String CalculateMessageForInfoLine() {
        if (Enabled && Mode != Modes.OFF) {
            MovingObjectPosition objectMouseOver = DistanceMeasurer.mc.field_71439_g.func_70614_a(300.0, 1.0f);
            String distanceMeasurerString = "";
            if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                double coordX = DistanceMeasurer.mc.field_71439_g.field_70165_t;
                double coordY = DistanceMeasurer.mc.field_71439_g.field_70163_u;
                double coordZ = DistanceMeasurer.mc.field_71439_g.field_70161_v;
                double blockX = (double)objectMouseOver.field_72311_b + 0.5;
                double blockY = (double)objectMouseOver.field_72312_c + 0.5;
                double blockZ = (double)objectMouseOver.field_72309_d + 0.5;
                double deltaX = coordX < blockX - 0.5 ? blockX - 0.5 - coordX : (coordX > blockX + 0.5 ? coordX - (blockX + 0.5) : coordX - blockX);
                double deltaY = coordY < blockY - 0.5 ? blockY - 0.5 - coordY : (coordY > blockY + 0.5 ? coordY - (blockY + 0.5) : coordY - blockY);
                double deltaZ = coordZ < blockZ - 0.5 ? blockZ - 0.5 - coordZ : (coordZ > blockZ + 0.5 ? coordZ - (blockZ + 0.5) : coordZ - blockZ);
                if (Mode == Modes.SIMPLE) {
                    double farthestHorizontalDistance = Math.max(Math.abs(deltaX), Math.abs(deltaZ));
                    double farthestDistance = Math.max(Math.abs(deltaY), farthestHorizontalDistance);
                    return "\u00a76[" + String.format("%1$,.1f", farthestDistance) + "]" + " ";
                }
                if (Mode == Modes.COMPLEX) {
                    double delta = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
                    String x = String.format("%1$,.1f", deltaX);
                    String y = String.format("%1$,.1f", deltaY);
                    String z = String.format("%1$,.1f", deltaZ);
                    return "\u00a76[" + x + ", " + z + ", " + y + " (" + String.format("%1$,.1f", delta) + ")]" + " ";
                }
                return "\u00a76[???] ";
            }
            return "\u00a76[" + Localization.get("distancemeasurer.far") + "]" + " ";
        }
        return "";
    }

    public static enum Modes {
        OFF(Localization.get("distancemeasurer.mode.off")),
        SIMPLE(Localization.get("distancemeasurer.mode.simple")),
        COMPLEX(Localization.get("distancemeasurer.mode.complex"));

        private String friendlyName;

        private Modes(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static Modes ToggleMode() {
            Mode = Mode.ordinal() < Modes.values().length - 1 ? Modes.values()[Mode.ordinal() + 1] : Modes.values()[0];
            return Mode;
        }

        public static Modes GetMode(String modeName) {
            try {
                return Modes.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                return Modes.values()[0];
            }
        }

        public String GetFriendlyName() {
            return this.friendlyName;
        }
    }
}

