/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.gui.buttons;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiNumberSlider
extends GuiButton {
    public float sliderValue;
    public float minValue;
    public float maxValue;
    public boolean dragging;
    public String label;
    public boolean renderValuesAsIntegers;
    private static DecimalFormat twoDecimals = new DecimalFormat("#.00");

    public GuiNumberSlider(int id, int x, int y, int width, int height, String displayString, float minValue, float maxValue, float currentValue, boolean renderValuesAsIntegers) {
        super(id, x, y, width, height, renderValuesAsIntegers ? displayString + (int)currentValue : displayString + twoDecimals.format(currentValue));
        this.label = displayString;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sliderValue = (currentValue - minValue) / (maxValue - minValue);
        this.renderValuesAsIntegers = renderValuesAsIntegers;
    }

    public float GetValueAsFloat() {
        return (this.maxValue - this.minValue) * this.sliderValue + this.minValue;
    }

    public int GetValueAsInteger() {
        return (int)((this.maxValue - this.minValue) * this.sliderValue + this.minValue);
    }

    public String GetLabel() {
        if (this.renderValuesAsIntegers) {
            return this.label + this.GetValueAsInteger();
        }
        return this.label + twoDecimals.format(this.GetValueAsFloat());
    }

    protected void SetLabel() {
        this.field_146126_j = this.GetLabel();
    }

    protected int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int x, int y) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.sliderValue = (float)(x - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                }
                if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
                this.SetLabel();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int x, int y) {
        if (super.func_146116_c(mc, x, y)) {
            this.sliderValue = (float)(x - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.SetLabel();
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int par1, int par2) {
        this.dragging = false;
    }
}

