/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.gui.buttons;

import com.zyin.zyinhud.util.Localization;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;

public class GuiHotkeyButton
extends GuiButton {
    protected static Minecraft mc = Minecraft.func_71410_x();
    protected boolean waitingForHotkeyInput = false;
    protected String hotkey;
    protected String hotkeyDescription;

    public GuiHotkeyButton(int id, int x, int y, int width, int height, String hotkeyDescription) {
        super(id, x, y, width, height, "");
        this.hotkeyDescription = hotkeyDescription;
        this.hotkey = this.GetHotkey();
        this.UpdateDisplayString();
    }

    public void Clicked() {
        this.waitingForHotkeyInput = !this.waitingForHotkeyInput;
        this.UpdateDisplayString();
    }

    public void Cancel() {
        this.waitingForHotkeyInput = false;
        this.UpdateDisplayString();
    }

    protected void UpdateDisplayString() {
        this.field_146126_j = this.waitingForHotkeyInput ? Localization.get("gui.options.hotkey") + "\u00a7f" + "> " + "\u00a7e" + this.GetHotkey() + "\u00a7f" + " <" : Localization.get("gui.options.hotkey") + this.GetHotkey();
    }

    public boolean IsWaitingForHotkeyInput() {
        return this.waitingForHotkeyInput;
    }

    private KeyBinding FindKeyBinding(String hotkeyDescription) {
        Object keyBinding = null;
        KeyBinding[] keyBindings = GuiHotkeyButton.mc.field_71474_y.field_74324_K;
        for (int i = 0; i < keyBindings.length; ++i) {
            if (!keyBindings[i].func_151464_g().equals(hotkeyDescription)) continue;
            return keyBindings[i];
        }
        return null;
    }

    public void ApplyHotkey(int newHotkey) {
        this.waitingForHotkeyInput = false;
        this.hotkey = Keyboard.getKeyName((int)newHotkey);
        this.UpdateDisplayString();
        KeyBinding keyBinding = this.FindKeyBinding(this.GetHotkeyDescription());
        if (keyBinding != null) {
            keyBinding.func_151462_b(newHotkey);
            KeyBinding.func_74508_b();
        }
    }

    public String GetHotkey() {
        if (this.hotkey == null) {
            KeyBinding keyBinding = this.FindKeyBinding(this.GetHotkeyDescription());
            if (keyBinding != null) {
                this.SetHotkey(this.hotkey);
                return Keyboard.getKeyName((int)keyBinding.func_151463_i());
            }
            return "?";
        }
        return this.hotkey;
    }

    protected void SetHotkey(String hotkey) {
        this.hotkey = hotkey;
    }

    protected String GetHotkeyDescription() {
        return this.hotkeyDescription;
    }
}

