/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.gui;

import com.zyin.zyinhud.ZyinHUDConfig;
import com.zyin.zyinhud.gui.GuiTooltipScreen;
import com.zyin.zyinhud.gui.buttons.GuiHotkeyButton;
import com.zyin.zyinhud.gui.buttons.GuiNumberSlider;
import com.zyin.zyinhud.mods.AnimalInfo;
import com.zyin.zyinhud.mods.Clock;
import com.zyin.zyinhud.mods.Compass;
import com.zyin.zyinhud.mods.Coordinates;
import com.zyin.zyinhud.mods.DistanceMeasurer;
import com.zyin.zyinhud.mods.DurabilityInfo;
import com.zyin.zyinhud.mods.EatingAid;
import com.zyin.zyinhud.mods.EnderPearlAid;
import com.zyin.zyinhud.mods.Fps;
import com.zyin.zyinhud.mods.HealthMonitor;
import com.zyin.zyinhud.mods.InfoLine;
import com.zyin.zyinhud.mods.ItemSelector;
import com.zyin.zyinhud.mods.Miscellaneous;
import com.zyin.zyinhud.mods.PlayerLocator;
import com.zyin.zyinhud.mods.PotionAid;
import com.zyin.zyinhud.mods.PotionTimers;
import com.zyin.zyinhud.mods.QuickDeposit;
import com.zyin.zyinhud.mods.SafeOverlay;
import com.zyin.zyinhud.mods.TorchAid;
import com.zyin.zyinhud.mods.WeaponSwapper;
import com.zyin.zyinhud.util.Localization;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class GuiZyinHUDOptions
extends GuiTooltipScreen {
    public static final String HotkeyDescription = "key.zyinhud.zyinhudoptions";
    protected GuiScreen parentGuiScreen;
    protected String screenTitle;
    protected GuiButton field_146290_a;
    protected String[] tabbedButtonNames = new String[]{Localization.get("miscellaneous.name"), Localization.get("infoline.name"), Localization.get("clock.name"), Localization.get("coordinates.name"), Localization.get("compass.name"), Localization.get("fps.name"), Localization.get("distancemeasurer.name"), Localization.get("safeoverlay.name"), Localization.get("playerlocator.name"), Localization.get("animalinfo.name"), Localization.get("durabilityinfo.name"), Localization.get("potiontimers.name"), Localization.get("enderpearlaid.name"), Localization.get("eatingaid.name"), Localization.get("potionaid.name"), Localization.get("torchaid.name"), Localization.get("weaponswapper.name"), Localization.get("quickdeposit.name"), Localization.get("itemselector.name"), Localization.get("healthmonitor.name")};
    protected int[] tabbedButtonIDs = new int[]{2000, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1100, 1000, 1200, 1300, 1400, 1900, 1500, 1600, 1700, 1800};
    private GuiHotkeyButton currentlySelectedHotkeyButton;
    private GuiButton currentlySelectedTabButton = null;
    private String currentlySelectedTabButtonColor = "\u00a7e";
    protected int tabbedButtonX;
    protected int tabbedButtonY;
    protected int tabbedButtonWidth;
    protected int tabbedButtonHeight;
    protected int tabbedButtonSpacing;
    protected int pagingButtonWidth;
    protected int pagingButtonHeight;
    protected static int tabbedPage = 0;
    protected static int tabbedPageSize = 11;
    protected static int tabbedMaxPages;
    protected int buttonY;
    protected int buttonWidth;
    protected int buttonWidth_double;
    protected int buttonHeight;
    protected int buttonSpacing;

    public GuiZyinHUDOptions(GuiScreen parentGuiScreen) {
        this.parentGuiScreen = parentGuiScreen;
        tabbedMaxPages = (int)Math.ceil((double)this.tabbedButtonNames.length / (double)tabbedPageSize);
    }

    public void func_73866_w_() {
        this.buttonSpacing = 2;
        this.buttonWidth = 130;
        this.buttonWidth_double = this.buttonWidth * 2 + this.buttonSpacing * 2;
        this.tabbedButtonSpacing = 0;
        this.tabbedButtonWidth = 130;
        this.tabbedButtonHeight = 14;
        this.tabbedButtonX = this.field_146294_l / 2 - (this.tabbedButtonWidth + this.buttonWidth_double) / 2;
        this.tabbedButtonY = (int)((double)this.field_146295_m * 0.16);
        this.buttonHeight = 20;
        this.buttonY = (int)((double)this.field_146295_m * 0.17);
        this.pagingButtonWidth = 15;
        this.pagingButtonHeight = 14;
        this.screenTitle = Localization.get("gui.options.title");
        this.DrawAllButtons();
    }

    protected void DrawAllButtons() {
        this.field_146292_n.clear();
        this.currentlySelectedTabButton = null;
        this.DrawOtherButtons();
        this.DrawTabbedButtons();
    }

    private void DrawMiscText() {
        if (this.currentlySelectedTabButton == null) {
            int x = (int)((double)this.field_146294_l - (double)this.field_146294_l * 0.05);
            int y = this.field_146295_m / 6 + 158;
            int lineHeight = 10;
            String[] text = new String[]{"Zyin's HUD", "v.1.3.1", "", "To reset values to their default", "setting, delete it in the configuration", "file at /.minecraft/config/ZyinHUD.cfg", "", "Found a bug? Want an enhancement? Submit", "it to my GitHub at github.com/Zyin055/zyinhud"};
            for (int i = 0; i < text.length; ++i) {
                int strWidth = this.field_146289_q.func_78256_a(text[i]);
                int xOffset = -strWidth;
                int yOffset = -(lineHeight * (text.length - i));
                GL11.glEnable((int)3042);
                this.field_146289_q.func_78261_a(text[i], x + xOffset, y + yOffset, 0x22FFFFFF);
                GL11.glDisable((int)3042);
            }
        } else if (this.currentlySelectedTabButton.field_146127_k == 1600) {
            String text = "\u00a7n" + Localization.get("quickdeposit.options.blacklist");
            int x = this.tabbedButtonWidth + this.tabbedButtonX + this.buttonSpacing * 2 + this.buttonWidth + this.buttonSpacing * 2 + this.buttonWidth / 2 - this.field_146289_q.func_78256_a(text) / 2;
            int y = this.buttonY - this.buttonHeight / 2 - this.field_146289_q.field_78288_b / 2 + 3;
            this.field_146289_q.func_78261_a(text, x, y, 0xFFFFFF);
        }
    }

    private void DrawOtherButtons() {
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 168, Localization.get("gui.options.saveandexit")));
    }

    private void DrawTabbedButtons() {
        int index;
        GuiButton prevPageButton = new GuiButton(10, this.tabbedButtonX, this.tabbedButtonY - this.pagingButtonHeight, this.pagingButtonWidth, this.pagingButtonHeight, "<");
        GuiButton nextPageButton = new GuiButton(11, this.tabbedButtonX + this.tabbedButtonWidth - this.pagingButtonWidth + 1, this.tabbedButtonY - this.pagingButtonHeight, this.pagingButtonWidth, this.pagingButtonHeight, ">");
        if (tabbedPage == 0) {
            prevPageButton.field_146124_l = false;
        } else if (tabbedPage == tabbedMaxPages - 1) {
            nextPageButton.field_146124_l = false;
        }
        this.field_146292_n.add(prevPageButton);
        this.field_146292_n.add(nextPageButton);
        int Y = this.tabbedButtonY;
        for (int i = 0; i < tabbedPageSize && (index = tabbedPage * tabbedPageSize + i) < this.tabbedButtonIDs.length; ++i) {
            int id = this.tabbedButtonIDs[index];
            String buttonName = this.tabbedButtonNames[tabbedPage * tabbedPageSize + i];
            this.field_146292_n.add(new GuiButton(id, this.tabbedButtonX, Y, this.tabbedButtonWidth, this.tabbedButtonHeight, buttonName));
            Y += this.tabbedButtonHeight;
        }
    }

    private void AddButtonAt(int column, int row, GuiButton button) {
        button.field_146128_h = this.tabbedButtonWidth + this.tabbedButtonX + this.buttonSpacing * 2 + (this.buttonWidth + this.buttonSpacing * 2) * column;
        button.field_146129_i = this.buttonY + (this.buttonHeight + this.buttonSpacing) * row;
        this.field_146292_n.add(button);
    }

    private void DrawMiscellaneousButtons() {
        this.AddButtonAt(0, 0, new GuiButton(2001, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("miscellaneous.options.useenhancedmiddleclick", Miscellaneous.UseEnhancedMiddleClick)));
    }

    private void DrawInfoLineButtons() {
        this.AddButtonAt(0, 0, new GuiButton(101, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(InfoLine.Enabled)));
        this.AddButtonAt(0, 1, new GuiButton(102, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("infoline.options.showbiome", InfoLine.ShowBiome)));
        this.AddButtonAt(0, 2, new GuiButton(105, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("infoline.options.showcansnow", InfoLine.ShowCanSnow)));
        this.AddButtonAt(0, 5, new GuiNumberSlider(103, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("infoline.options.offsetx"), 1.0f, this.field_146294_l - 25, InfoLine.GetHorizontalLocation(), true));
        this.AddButtonAt(0, 6, new GuiNumberSlider(104, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("infoline.options.offsety"), 1.0f, this.field_146295_m - 8, InfoLine.GetVerticalLocation(), true));
    }

    private void DrawClockButtons() {
        this.AddButtonAt(0, 0, new GuiButton(201, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(Clock.Enabled)));
        this.AddButtonAt(0, 1, new GuiButton(202, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Mode(Clock.Mode.GetFriendlyName())));
    }

    private void DrawCoordinatesButtons() {
        this.AddButtonAt(0, 0, new GuiButton(301, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(Coordinates.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(303, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.coordinates"));
        this.AddButtonAt(0, 2, new GuiButton(304, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Mode(Coordinates.Mode.GetFriendlyName())));
        this.AddButtonAt(0, 3, new GuiButton(302, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("coordinates.options.useycoordinatecolors", Coordinates.UseYCoordinateColors)));
    }

    private void DrawCompassButtons() {
        this.AddButtonAt(0, 0, new GuiButton(401, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(Compass.Enabled)));
    }

    private void DrawFPSButtons() {
        this.AddButtonAt(0, 0, new GuiButton(501, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(Fps.Enabled)));
    }

    private void DrawDistanceMeasurerButtons() {
        this.AddButtonAt(0, 0, new GuiButton(601, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(DistanceMeasurer.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(602, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.distancemeasurer"));
    }

    private void DrawSafeOverlayButtons() {
        this.AddButtonAt(0, 0, new GuiButton(701, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(SafeOverlay.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(702, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.safeoverlay"));
        this.AddButtonAt(0, 2, new GuiNumberSlider(703, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("safeoverlay.options.drawdistance"), 2.0f, 175.0f, SafeOverlay.instance.GetDrawDistance(), true));
        this.AddButtonAt(0, 3, new GuiNumberSlider(704, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("safeoverlay.options.transparency"), SafeOverlay.instance.GetUnsafeOverlayMinTransparency(), SafeOverlay.instance.GetUnsafeOverlayMaxTransparency(), SafeOverlay.instance.GetUnsafeOverlayTransparency(), false));
        this.AddButtonAt(0, 4, new GuiButton(705, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("safeoverlay.options.displayinnether", SafeOverlay.instance.GetDisplayInNether())));
        this.AddButtonAt(0, 5, new GuiButton(706, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("safeoverlay.options.seethroughwalls", SafeOverlay.instance.GetSeeUnsafePositionsThroughWalls())));
    }

    private void DrawPlayerLocatorButtons() {
        this.AddButtonAt(0, 0, new GuiButton(801, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(PlayerLocator.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(802, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.playerlocator"));
        this.AddButtonAt(0, 2, new GuiNumberSlider(803, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("playerlocator.options.minviewdistance"), 0.0f, 120.0f, PlayerLocator.viewDistanceCutoff, true));
        this.AddButtonAt(0, 3, new GuiButton(804, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.showdistancetoplayers", PlayerLocator.ShowDistanceToPlayers)));
        this.AddButtonAt(0, 4, new GuiButton(805, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.showplayerhealth", PlayerLocator.ShowPlayerHealth)));
        this.AddButtonAt(1, 0, new GuiButton(806, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.showwolves", PlayerLocator.ShowWolves)));
        this.AddButtonAt(1, 1, new GuiButton(807, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.usewolfcolors", PlayerLocator.UseWolfColors)));
    }

    private void DrawAnimalInfoButtons() {
        this.AddButtonAt(0, 0, new GuiButton(901, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(AnimalInfo.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(902, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.animalinfo"));
        this.AddButtonAt(0, 2, new GuiNumberSlider(903, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("animalinfo.options.maxviewdistance"), AnimalInfo.minViewDistanceCutoff, AnimalInfo.maxViewDistanceCutoff, AnimalInfo.viewDistanceCutoff, true));
        this.AddButtonAt(0, 3, new GuiButton(907, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showtextbackground", AnimalInfo.ShowTextBackgrounds)));
        this.AddButtonAt(0, 4, new GuiNumberSlider(904, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("animalinfo.options.numdecimalsdisplayed"), AnimalInfo.minNumberOfDecimalsDisplayed, AnimalInfo.maxNumberOfDecimalsDisplayed, AnimalInfo.GetNumberOfDecimalsDisplayed(), true));
        this.AddButtonAt(0, 5, new GuiButton(905, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showhorsestatsonf3menu", AnimalInfo.ShowHorseStatsOnF3Menu)));
        this.AddButtonAt(0, 6, new GuiButton(906, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showhorsestatsoverlay", AnimalInfo.ShowHorseStatsOverlay)));
        this.AddButtonAt(1, 0, new GuiButton(916, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingicons", AnimalInfo.ShowBreedingIcons)));
        this.AddButtonAt(1, 1, new GuiButton(917, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingtimers", AnimalInfo.ShowBreedingTimers)));
        this.AddButtonAt(1, 2, new GuiButton(910, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedinghorse", AnimalInfo.ShowBreedingTimerForHorses)));
        this.AddButtonAt(1, 3, new GuiButton(911, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingvillagers", AnimalInfo.ShowBreedingTimerForVillagers)));
        this.AddButtonAt(1, 4, new GuiButton(912, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingcow", AnimalInfo.ShowBreedingTimerForCows)));
        this.AddButtonAt(1, 5, new GuiButton(913, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingsheep", AnimalInfo.ShowBreedingTimerForSheep)));
        this.AddButtonAt(1, 6, new GuiButton(914, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingpig", AnimalInfo.ShowBreedingTimerForPigs)));
        this.AddButtonAt(1, 7, new GuiButton(915, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingchicken", AnimalInfo.ShowBreedingTimerForChickens)));
    }

    private void DrawPotionTimerButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1001, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(PotionTimers.Enabled)));
        this.AddButtonAt(0, 1, new GuiButton(1002, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("potiontimers.options.showpotionicons", PotionTimers.ShowPotionIcons)));
        this.AddButtonAt(0, 2, new GuiButton(1005, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("potiontimers.options.usepotioncolors", PotionTimers.UsePotionColors)));
        this.AddButtonAt(0, 3, new GuiButton(1007, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("potiontimers.options.hidepotioneffectsininventory", PotionTimers.HidePotionEffectsInInventory)));
        this.AddButtonAt(0, 4, new GuiNumberSlider(1006, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("potiontimers.options.potionscale"), 1.0f, 4.0f, PotionTimers.PotionScale, false));
        this.AddButtonAt(0, 5, new GuiNumberSlider(1003, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("potiontimers.options.offsetx"), 1.0f, this.field_146294_l - 25, PotionTimers.GetHorizontalLocation(), true));
        this.AddButtonAt(0, 6, new GuiNumberSlider(1004, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("potiontimers.options.offsety"), 0.0f, this.field_146295_m - 10, PotionTimers.GetVerticalLocation(), true));
    }

    private void DrawDurabilityInfoButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1101, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(DurabilityInfo.Enabled)));
        this.AddButtonAt(0, 1, new GuiButton(1102, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showarmordurability", DurabilityInfo.ShowArmorDurability)));
        this.AddButtonAt(0, 2, new GuiNumberSlider(1103, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("durabilityinfo.options.armordurabilitythreshold"), 0.0f, 1.0f, DurabilityInfo.GetDurabilityDisplayThresholdForArmor(), false));
        this.AddButtonAt(0, 3, new GuiButton(1111, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.autounequiparmor", DurabilityInfo.AutoUnequipArmor)));
        this.AddButtonAt(0, 4, new GuiButton(1104, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showindividualarmoricons", DurabilityInfo.ShowIndividualArmorIcons)));
        this.AddButtonAt(0, 5, new GuiNumberSlider(1108, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("durabilityinfo.options.offsetx"), 0.0f, this.field_146294_l - DurabilityInfo.toolX, DurabilityInfo.durabalityLocX, true));
        this.AddButtonAt(0, 6, new GuiNumberSlider(1109, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("durabilityinfo.options.offsety"), 0.0f, this.field_146295_m - DurabilityInfo.toolY, DurabilityInfo.durabalityLocY, true));
        this.AddButtonAt(1, 1, new GuiButton(1105, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showitemdurability", DurabilityInfo.ShowItemDurability)));
        this.AddButtonAt(1, 2, new GuiNumberSlider(1106, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("durabilityinfo.options.itemdurabilitythreshold"), 0.0f, 1.0f, DurabilityInfo.GetDurabilityDisplayThresholdForItem(), false));
        this.AddButtonAt(1, 3, new GuiButton(1112, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.autounequiptools", DurabilityInfo.AutoUnequipTools)));
        this.AddButtonAt(1, 4, new GuiButton(1110, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showdamageaspercent", DurabilityInfo.ShowDamageAsPercentage)));
    }

    private void DrawEnderPearlAidButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1201, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(EnderPearlAid.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(1202, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.enderpearlaid"));
    }

    private void DrawEatingAidButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1301, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(EatingAid.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(1302, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.eatingaid"));
        this.AddButtonAt(0, 2, new GuiButton(1303, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Mode(EatingAid.Mode.GetFriendlyName())));
        this.AddButtonAt(0, 3, new GuiButton(1304, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.eatgoldenfood", EatingAid.EatGoldenFood)));
        this.AddButtonAt(0, 4, new GuiButton(1306, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.eatrawfood", EatingAid.EatRawFood)));
        this.AddButtonAt(0, 5, new GuiButton(1305, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.prioritizefoodinhotbar", EatingAid.PrioritizeFoodInHotbar)));
        this.AddButtonAt(1, 0, new GuiButton(1307, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.usepvpsoup", EatingAid.UsePvPSoup)));
    }

    private void DrawPotionAidButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1401, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(PotionAid.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(1402, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.potionaid"));
    }

    private void DrawWeaponSwapperButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1501, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(WeaponSwapper.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(1502, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.weaponswapper"));
        this.AddButtonAt(0, 2, new GuiButton(1503, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("weaponswapper.options.scanhotbarforweaponsfromlefttoright", WeaponSwapper.ScanHotbarForWeaponsFromLeftToRight)));
    }

    private void DrawQuickDepositButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1601, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(QuickDeposit.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(1602, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.quickdeposit"));
        this.AddButtonAt(0, 2, new GuiButton(1603, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.ignoreitemsinhotbar", QuickDeposit.IgnoreItemsInHotbar)));
        this.AddButtonAt(0, 3, new GuiButton(1604, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.closechestafterdepositing", QuickDeposit.CloseChestAfterDepositing)));
        this.AddButtonAt(1, 0, new GuiButton(1605, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklisttorch", QuickDeposit.BlacklistTorch)));
        this.AddButtonAt(1, 1, new GuiButton(1606, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistarrow", QuickDeposit.BlacklistArrow)));
        this.AddButtonAt(1, 2, new GuiButton(1607, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistfood", QuickDeposit.BlacklistFood)));
        this.AddButtonAt(1, 3, new GuiButton(1608, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistenderpearl", QuickDeposit.BlacklistEnderPearl)));
        this.AddButtonAt(1, 4, new GuiButton(1609, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistwaterbucket", QuickDeposit.BlacklistWaterBucket)));
        this.AddButtonAt(1, 5, new GuiButton(1610, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistclockcompass", QuickDeposit.BlacklistClockCompass)));
    }

    private void DrawItemSelectorButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1701, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(ItemSelector.Enabled)));
        this.AddButtonAt(0, 1, new GuiHotkeyButton(1702, 0, 0, this.buttonWidth, this.buttonHeight, "key.zyinhud.itemselector"));
        this.AddButtonAt(0, 2, new GuiButton(1704, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Mode(ItemSelector.Mode.GetFriendlyName())));
        this.AddButtonAt(0, 3, new GuiNumberSlider(1703, 0, 0, this.buttonWidth, this.buttonHeight, Localization.get("itemselector.options.ticks"), 50.0f, 500.0f, ItemSelector.GetTimeout(), true));
        this.AddButtonAt(0, 4, new GuiButton(1705, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("itemselector.options.sideButtons", ItemSelector.UseMouseSideButtons)));
    }

    private void DrawHealthMonitorButtoins() {
        this.AddButtonAt(0, 0, new GuiButton(1801, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(HealthMonitor.Enabled)));
        this.AddButtonAt(0, 1, new GuiButton(1802, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Mode(HealthMonitor.Mode.GetFriendlyName())));
        this.AddButtonAt(0, 2, new GuiButton(1804, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Boolean("healthmonitor.options.playfasterneardeath", HealthMonitor.PlayFasterNearDeath)));
        this.AddButtonAt(0, 3, new GuiNumberSlider(1805, 0, 0, this.buttonWidth_double, this.buttonHeight, Localization.get("healthmonitor.options.lowhealthsoundthreshold"), 1.0f, 20.0f, HealthMonitor.GetLowHealthSoundThreshold(), true));
        this.AddButtonAt(1, 1, new GuiButton(1803, 0, 0, this.buttonWidth / 2, this.buttonHeight, Localization.get("healthmonitor.options.mode.play")));
    }

    private void DrawTorchAidButtons() {
        this.AddButtonAt(0, 0, new GuiButton(1901, 0, 0, this.buttonWidth, this.buttonHeight, GuiZyinHUDOptions.GetButtonLabel_Enabled(TorchAid.Enabled)));
    }

    private static String GetButtonLabel_Mode(String modeName) {
        return Localization.get("gui.options.mode") + modeName;
    }

    private static String GetButtonLabel_Enabled(boolean enabled) {
        if (enabled) {
            return Localization.get("gui.options.enabled") + "\u00a7a" + Localization.getMinecraft("options.on") + "\u00a7f";
        }
        return Localization.get("gui.options.enabled") + "\u00a7c" + Localization.getMinecraft("options.off") + "\u00a7f";
    }

    private static String GetButtonLabel_Boolean(String localizationString, boolean bool) {
        if (bool) {
            return Localization.get(localizationString) + Localization.getMinecraft("options.on");
        }
        return Localization.get(localizationString) + Localization.getMinecraft("options.off");
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (int l = 0; l < this.field_146292_n.size(); ++l) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(l);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                this.field_146290_a = guibutton;
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int which) {
        if (this.field_146290_a != null && which == 0) {
            this.field_146290_a.func_146118_a(mouseX, mouseY);
            this.actionPerformed_MouseUp(this.field_146290_a);
            this.field_146290_a = null;
        }
    }

    protected void actionPerformed_MouseUp(GuiButton button) {
        if (button instanceof GuiNumberSlider) {
            this.func_146284_a(button);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k % 100 == 0) {
                this.DrawAllButtons();
                GuiButton clickedButton = this.GetButtonById(button.field_146127_k);
                if (clickedButton != null) {
                    this.currentlySelectedTabButton = clickedButton;
                    this.currentlySelectedHotkeyButton = null;
                    clickedButton.field_146126_j = this.currentlySelectedTabButtonColor + clickedButton.field_146126_j;
                }
            }
            switch (button.field_146127_k) {
                case 1: {
                    ZyinHUDConfig.SaveConfigSettings();
                    this.field_146297_k.func_147108_a(this.parentGuiScreen);
                    break;
                }
                case 10: {
                    this.DecrementTabbedPage();
                    break;
                }
                case 11: {
                    this.IncrementTabbedPage();
                    break;
                }
                case 100: {
                    this.screenTitle = Localization.get("infoline.name");
                    this.DrawInfoLineButtons();
                    break;
                }
                case 101: {
                    InfoLine.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(InfoLine.Enabled);
                    break;
                }
                case 102: {
                    InfoLine.ToggleShowBiome();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("infoline.options.showbiome", InfoLine.ShowBiome);
                    break;
                }
                case 105: {
                    InfoLine.ToggleShowCanSnow();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("infoline.options.showcansnow", InfoLine.ShowCanSnow);
                    break;
                }
                case 103: {
                    InfoLine.SetHorizontalLocation(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 104: {
                    InfoLine.SetVerticalLocation(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 200: {
                    this.screenTitle = Localization.get("clock.name");
                    this.DrawClockButtons();
                    break;
                }
                case 201: {
                    Clock.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(Clock.Enabled);
                    break;
                }
                case 202: {
                    Clock.Mode.ToggleMode();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Mode(Clock.Mode.GetFriendlyName());
                    break;
                }
                case 300: {
                    this.screenTitle = Localization.get("coordinates.name");
                    this.DrawCoordinatesButtons();
                    break;
                }
                case 301: {
                    Coordinates.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(Coordinates.Enabled);
                    break;
                }
                case 302: {
                    Coordinates.ToggleUseYCoordinateColors();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("coordinates.options.useycoordinatecolors", Coordinates.UseYCoordinateColors);
                    break;
                }
                case 303: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 304: {
                    Coordinates.Modes.ToggleMode();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Mode(Coordinates.Mode.GetFriendlyName());
                    break;
                }
                case 400: {
                    this.screenTitle = Localization.get("compass.name");
                    this.DrawCompassButtons();
                    break;
                }
                case 401: {
                    Compass.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(Compass.Enabled);
                    break;
                }
                case 500: {
                    this.screenTitle = Localization.get("fps.name");
                    this.DrawFPSButtons();
                    break;
                }
                case 501: {
                    Fps.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(Fps.Enabled);
                    break;
                }
                case 600: {
                    this.screenTitle = Localization.get("distancemeasurer.name");
                    this.DrawDistanceMeasurerButtons();
                    break;
                }
                case 601: {
                    DistanceMeasurer.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(DistanceMeasurer.Enabled);
                    break;
                }
                case 602: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 700: {
                    this.screenTitle = Localization.get("safeoverlay.name");
                    this.DrawSafeOverlayButtons();
                    break;
                }
                case 701: {
                    SafeOverlay.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(SafeOverlay.Enabled);
                    break;
                }
                case 702: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 703: {
                    int value = ((GuiNumberSlider)button).GetValueAsInteger();
                    SafeOverlay.instance.SetDrawDistance(value);
                    break;
                }
                case 704: {
                    SafeOverlay.instance.SetUnsafeOverlayTransparency(((GuiNumberSlider)button).GetValueAsFloat());
                    break;
                }
                case 705: {
                    SafeOverlay.instance.ToggleDisplayInNether();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("safeoverlay.options.displayinnether", SafeOverlay.instance.GetDisplayInNether());
                    break;
                }
                case 706: {
                    SafeOverlay.instance.ToggleSeeUnsafePositionsThroughWalls();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("safeoverlay.options.seethroughwalls", SafeOverlay.instance.GetSeeUnsafePositionsThroughWalls());
                    break;
                }
                case 800: {
                    this.screenTitle = Localization.get("playerlocator.name");
                    this.DrawPlayerLocatorButtons();
                    break;
                }
                case 801: {
                    PlayerLocator.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(PlayerLocator.Enabled);
                    break;
                }
                case 802: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 803: {
                    PlayerLocator.viewDistanceCutoff = ((GuiNumberSlider)button).GetValueAsInteger();
                    break;
                }
                case 804: {
                    PlayerLocator.ToggleShowDistanceToPlayers();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.showdistancetoplayers", PlayerLocator.ShowDistanceToPlayers);
                    break;
                }
                case 805: {
                    PlayerLocator.ToggleShowPlayerHealth();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.showplayerhealth", PlayerLocator.ShowPlayerHealth);
                    break;
                }
                case 806: {
                    PlayerLocator.ToggleShowWolves();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.showwolves", PlayerLocator.ShowWolves);
                    break;
                }
                case 807: {
                    PlayerLocator.ToggleUseWolfColors();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("playerlocator.options.usewolfcolors", PlayerLocator.UseWolfColors);
                    break;
                }
                case 900: {
                    this.screenTitle = Localization.get("animalinfo.name");
                    this.DrawAnimalInfoButtons();
                    break;
                }
                case 901: {
                    AnimalInfo.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(AnimalInfo.Enabled);
                    break;
                }
                case 902: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 903: {
                    AnimalInfo.viewDistanceCutoff = ((GuiNumberSlider)button).GetValueAsInteger();
                    break;
                }
                case 904: {
                    AnimalInfo.SetNumberOfDecimalsDisplayed(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 905: {
                    AnimalInfo.ToggleShowHorseStatsOnF3Menu();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showhorsestatsonf3menu", AnimalInfo.ShowHorseStatsOnF3Menu);
                    break;
                }
                case 906: {
                    AnimalInfo.ToggleShowHorseStatsOverlay();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showhorsestatsoverlay", AnimalInfo.ShowHorseStatsOverlay);
                    break;
                }
                case 907: {
                    AnimalInfo.ToggleShowTextBackgrounds();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showtextbackground", AnimalInfo.ShowTextBackgrounds);
                    break;
                }
                case 910: {
                    AnimalInfo.ToggleShowBreedingHorses();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedinghorse", AnimalInfo.ShowBreedingTimerForHorses);
                    break;
                }
                case 911: {
                    AnimalInfo.ToggleShowBreedingVillagers();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingvillagers", AnimalInfo.ShowBreedingTimerForVillagers);
                    break;
                }
                case 912: {
                    AnimalInfo.ToggleShowBreedingCows();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingcow", AnimalInfo.ShowBreedingTimerForCows);
                    break;
                }
                case 913: {
                    AnimalInfo.ToggleShowBreedingSheep();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingsheep", AnimalInfo.ShowBreedingTimerForSheep);
                    break;
                }
                case 914: {
                    AnimalInfo.ToggleShowBreedingPigs();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingpig", AnimalInfo.ShowBreedingTimerForPigs);
                    break;
                }
                case 915: {
                    AnimalInfo.ToggleShowBreedingChickens();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingchicken", AnimalInfo.ShowBreedingTimerForChickens);
                    break;
                }
                case 916: {
                    AnimalInfo.ToggleShowBreedingIcons();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingicons", AnimalInfo.ShowBreedingIcons);
                    break;
                }
                case 917: {
                    AnimalInfo.ToggleShowBreedingTimers();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("animalinfo.options.showbreedingtimers", AnimalInfo.ShowBreedingTimers);
                    break;
                }
                case 1000: {
                    this.screenTitle = Localization.get("potiontimers.name");
                    this.DrawPotionTimerButtons();
                    break;
                }
                case 1001: {
                    PotionTimers.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(PotionTimers.Enabled);
                    break;
                }
                case 1002: {
                    PotionTimers.ToggleShowPotionIcons();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("potiontimers.options.showpotionicons", PotionTimers.ShowPotionIcons);
                    break;
                }
                case 1005: {
                    PotionTimers.ToggleUsePotionColors();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("potiontimers.options.usepotioncolors", PotionTimers.UsePotionColors);
                    break;
                }
                case 1007: {
                    PotionTimers.ToggleHidePotionEffectsInInventory();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("potiontimers.options.hidepotioneffectsininventory", PotionTimers.HidePotionEffectsInInventory);
                    break;
                }
                case 1006: {
                    PotionTimers.PotionScale = ((GuiNumberSlider)button).GetValueAsFloat();
                    break;
                }
                case 1003: {
                    PotionTimers.SetHorizontalLocation(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 1004: {
                    PotionTimers.SetVerticalLocation(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 1100: {
                    this.screenTitle = Localization.get("durabilityinfo.name");
                    this.DrawDurabilityInfoButtons();
                    break;
                }
                case 1101: {
                    DurabilityInfo.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(DurabilityInfo.Enabled);
                    break;
                }
                case 1102: {
                    DurabilityInfo.ToggleShowArmorDurability();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showarmordurability", DurabilityInfo.ShowArmorDurability);
                    break;
                }
                case 1103: {
                    DurabilityInfo.SetDurabilityDisplayThresholdForArmor(((GuiNumberSlider)button).GetValueAsFloat());
                    break;
                }
                case 1104: {
                    DurabilityInfo.ToggleShowIndividualArmorIcons();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showindividualarmoricons", DurabilityInfo.ShowIndividualArmorIcons);
                    break;
                }
                case 1105: {
                    DurabilityInfo.ToggleShowItemDurability();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showitemdurability", DurabilityInfo.ShowItemDurability);
                    break;
                }
                case 1106: {
                    DurabilityInfo.SetDurabilityDisplayThresholdForItem(((GuiNumberSlider)button).GetValueAsFloat());
                    break;
                }
                case 1108: {
                    DurabilityInfo.SetHorizontalLocation(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 1109: {
                    DurabilityInfo.SetVerticalLocation(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 1110: {
                    DurabilityInfo.ToggleShowDamageAsPercent();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.showdamageaspercent", DurabilityInfo.ShowDamageAsPercentage);
                    break;
                }
                case 1111: {
                    DurabilityInfo.ToggleAutoUnequipArmor();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.autounequiparmor", DurabilityInfo.AutoUnequipArmor);
                    break;
                }
                case 1112: {
                    DurabilityInfo.ToggleAutoUnequipTools();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("durabilityinfo.options.autounequiptools", DurabilityInfo.AutoUnequipTools);
                    break;
                }
                case 1200: {
                    this.screenTitle = Localization.get("enderpearlaid.name");
                    this.DrawEnderPearlAidButtons();
                    break;
                }
                case 1201: {
                    EnderPearlAid.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(EnderPearlAid.Enabled);
                    break;
                }
                case 1202: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 1300: {
                    this.screenTitle = Localization.get("eatingaid.name");
                    this.DrawEatingAidButtons();
                    break;
                }
                case 1301: {
                    EatingAid.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(EatingAid.Enabled);
                    break;
                }
                case 1302: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 1303: {
                    EatingAid.Modes.ToggleMode();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Mode(EatingAid.Mode.GetFriendlyName());
                    break;
                }
                case 1304: {
                    EatingAid.ToggleEatingGoldenFood();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.eatgoldenfood", EatingAid.EatGoldenFood);
                    break;
                }
                case 1306: {
                    EatingAid.ToggleEatingGoldenFood();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.eatgoldenfood", EatingAid.EatGoldenFood);
                    break;
                }
                case 1305: {
                    EatingAid.TogglePrioritizeFoodInHotbar();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.prioritizefoodinhotbar", EatingAid.PrioritizeFoodInHotbar);
                    break;
                }
                case 1307: {
                    EatingAid.ToggleUsePvPSoup();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("eatingaid.options.usepvpsoup", EatingAid.UsePvPSoup);
                    break;
                }
                case 1400: {
                    this.screenTitle = Localization.get("potionaid.name");
                    this.DrawPotionAidButtons();
                    break;
                }
                case 1401: {
                    PotionAid.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(PotionAid.Enabled);
                    break;
                }
                case 1402: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 1500: {
                    this.screenTitle = Localization.get("weaponswapper.name");
                    this.DrawWeaponSwapperButtons();
                    break;
                }
                case 1501: {
                    WeaponSwapper.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(WeaponSwapper.Enabled);
                    break;
                }
                case 1502: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 1503: {
                    WeaponSwapper.ToggleScanHotbarFromLeftToRight();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("weaponswapper.options.scanhotbarforweaponsfromlefttoright", WeaponSwapper.ScanHotbarForWeaponsFromLeftToRight);
                    break;
                }
                case 1600: {
                    this.screenTitle = Localization.get("quickdeposit.name");
                    this.DrawQuickDepositButtons();
                    break;
                }
                case 1601: {
                    QuickDeposit.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(QuickDeposit.Enabled);
                    break;
                }
                case 1602: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 1603: {
                    QuickDeposit.ToggleIgnoreItemsInHotbar();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.ignoreitemsinhotbar", QuickDeposit.IgnoreItemsInHotbar);
                    break;
                }
                case 1604: {
                    QuickDeposit.ToggleCloseChestAfterDepositing();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.closechestafterdepositing", QuickDeposit.CloseChestAfterDepositing);
                    break;
                }
                case 1605: {
                    QuickDeposit.ToggleBlacklistTorch();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklisttorch", QuickDeposit.BlacklistTorch);
                    break;
                }
                case 1606: {
                    QuickDeposit.ToggleBlacklistArrow();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistarrow", QuickDeposit.BlacklistArrow);
                    break;
                }
                case 1607: {
                    QuickDeposit.ToggleBlacklistFood();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistfood", QuickDeposit.BlacklistFood);
                    break;
                }
                case 1608: {
                    QuickDeposit.ToggleBlacklistEnderPearl();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistenderpearl", QuickDeposit.BlacklistEnderPearl);
                    break;
                }
                case 1609: {
                    QuickDeposit.ToggleBlacklistWaterBucket();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistwaterbucket", QuickDeposit.BlacklistWaterBucket);
                    break;
                }
                case 1610: {
                    QuickDeposit.ToggleBlacklistClockCompass();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("quickdeposit.options.blacklistclockcompass", QuickDeposit.BlacklistClockCompass);
                    break;
                }
                case 1700: {
                    this.screenTitle = Localization.get("itemselector.name");
                    this.DrawItemSelectorButtons();
                    break;
                }
                case 1701: {
                    ItemSelector.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(ItemSelector.Enabled);
                    break;
                }
                case 1702: {
                    this.HotkeyButtonClicked((GuiHotkeyButton)button);
                    break;
                }
                case 1703: {
                    int itemSelectorTicks = ((GuiNumberSlider)button).GetValueAsInteger();
                    ItemSelector.SetTimeout(itemSelectorTicks);
                    break;
                }
                case 1704: {
                    ItemSelector.Modes.ToggleMode();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Mode(ItemSelector.Mode.GetFriendlyName());
                    break;
                }
                case 1705: {
                    ItemSelector.ToggleUseMouseSideButtons();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("itemselector.options.sideButtons", ItemSelector.UseMouseSideButtons);
                    break;
                }
                case 1800: {
                    this.screenTitle = Localization.get("healthmonitor.name");
                    this.DrawHealthMonitorButtoins();
                    break;
                }
                case 1801: {
                    HealthMonitor.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(HealthMonitor.Enabled);
                    break;
                }
                case 1802: {
                    HealthMonitor.Modes.ToggleMode();
                    HealthMonitor.PlayLowHealthSound();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Mode(HealthMonitor.Mode.GetFriendlyName());
                    break;
                }
                case 1803: {
                    HealthMonitor.PlayLowHealthSound();
                    break;
                }
                case 1804: {
                    HealthMonitor.TogglePlayFasterNearDeath();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("healthmonitor.options.playfasterneardeath", HealthMonitor.PlayFasterNearDeath);
                    break;
                }
                case 1805: {
                    HealthMonitor.SetLowHealthSoundThreshold(((GuiNumberSlider)button).GetValueAsInteger());
                    break;
                }
                case 1900: {
                    this.screenTitle = Localization.get("torchaid.name");
                    this.DrawTorchAidButtons();
                    break;
                }
                case 1901: {
                    TorchAid.ToggleEnabled();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Enabled(TorchAid.Enabled);
                    break;
                }
                case 2000: {
                    this.screenTitle = Localization.get("miscellaneous.name");
                    this.DrawMiscellaneousButtons();
                    break;
                }
                case 2001: {
                    Miscellaneous.ToggleUseEnchancedMiddleClick();
                    button.field_146126_j = GuiZyinHUDOptions.GetButtonLabel_Boolean("miscellaneous.options.useenhancedmiddleclick", Miscellaneous.UseEnhancedMiddleClick);
                }
            }
        }
    }

    @Override
    protected String GetButtonTooltip(int buttonId) {
        switch (buttonId) {
            case 100: {
                return Localization.get("infoline.options.tooltip");
            }
            case 202: {
                return Localization.get("clock.options.mode.tooltip");
            }
            case 300: {
                return Localization.get("coordinates.options.tooltip");
            }
            case 302: {
                return Localization.get("coordinates.options.useycoordinatecolors.tooltip");
            }
            case 303: {
                return Localization.get("coordinates.options.hotkey.tooltip");
            }
            case 700: {
                return Localization.get("safeoverlay.options.tooltip");
            }
            case 702: {
                return Localization.get("safeoverlay.options.hotkey.tooltip");
            }
            case 600: {
                return Localization.get("distancemeasurer.options.tooltip");
            }
            case 800: {
                return Localization.get("playerlocator.options.tooltip");
            }
            case 803: {
                return Localization.get("playerlocator.options.minviewdistance.tooltip");
            }
            case 806: {
                return Localization.get("playerlocator.options.showwolves.tooltip");
            }
            case 807: {
                return Localization.get("playerlocator.options.usewolfcolors.tooltip");
            }
            case 900: {
                return Localization.get("animalinfo.options.tooltip");
            }
            case 907: {
                return Localization.get("animalinfo.options.showtextbackground.tooltip");
            }
            case 905: {
                return Localization.get("animalinfo.options.showhorsestatsonf3menu.tooltip");
            }
            case 906: {
                return Localization.get("animalinfo.options.showhorsestatsoverlay.tooltip");
            }
            case 916: {
                return Localization.get("animalinfo.options.showbreedingicons.tooltip");
            }
            case 917: {
                return Localization.get("animalinfo.options.showbreedingtimers.tooltip");
            }
            case 1000: {
                return Localization.get("potiontimers.options.tooltip");
            }
            case 1007: {
                return Localization.get("potiontimers.options.hidepotioneffectsininventory.tooltip");
            }
            case 1100: {
                return Localization.get("durabilityinfo.options.tooltip");
            }
            case 1103: {
                return Localization.get("durabilityinfo.options.armordurabilitythreshold.tooltip");
            }
            case 1104: {
                return Localization.get("durabilityinfo.options.showindividualarmoricons.tooltip");
            }
            case 1106: {
                return Localization.get("durabilityinfo.options.itemdurabilitythreshold.tooltip");
            }
            case 1110: {
                return Localization.get("durabilityinfo.options.showdamageaspercent.tooltip");
            }
            case 1111: {
                return Localization.get("durabilityinfo.options.autounequiparmor.tooltip");
            }
            case 1112: {
                return Localization.get("durabilityinfo.options.autounequiptools.tooltip");
            }
            case 1200: {
                return Localization.get("enderpearlaid.options.tooltip");
            }
            case 1300: {
                return Localization.get("eatingaid.options.tooltip");
            }
            case 1303: {
                return Localization.get("eatingaid.options.mode.tooltip");
            }
            case 1307: {
                return Localization.get("eatingaid.options.usepvpsoup.tooltip");
            }
            case 1400: {
                return Localization.get("potionaid.options.tooltip");
            }
            case 1500: {
                return Localization.get("weaponswapper.options.tooltip");
            }
            case 1503: {
                return Localization.get("weaponswapper.options.scanhotbarforweaponsfromlefttoright.tooltip");
            }
            case 1600: {
                return Localization.get("quickdeposit.options.tooltip");
            }
            case 1603: {
                return Localization.get("quickdeposit.options.ignoreitemsinhotbar.tooltip");
            }
            case 1604: {
                return Localization.get("quickdeposit.options.closechestafterdepositing.tooltip");
            }
            case 1700: {
                return Localization.get("itemselector.options.tooltip");
            }
            case 1702: {
                return Localization.get("itemselector.options.hotkey.tooltip");
            }
            case 1703: {
                return Localization.get("itemselector.options.ticks.tooltip");
            }
            case 1704: {
                return Localization.get("itemselector.options.mode.tooltip");
            }
            case 1705: {
                return Localization.get("itemselector.options.sideButtons.tooltip");
            }
            case 1800: {
                return Localization.get("healthmonitor.options.tooltip");
            }
            case 1802: {
                return Localization.get("healthmonitor.options.mode.tooltip");
            }
            case 1803: {
                return Localization.get("healthmonitor.options.mode.play.tooltip");
            }
            case 1804: {
                return Localization.get("healthmonitor.options.playfasterneardeath.tooltip");
            }
            case 1900: {
                return Localization.get("torchaid.options.tooltip");
            }
            case 2001: {
                return Localization.get("miscellaneous.options.useenhancedmiddleclick.tooltip");
            }
        }
        return null;
    }

    private void HotkeyButtonClicked(GuiHotkeyButton hotkeyButton) {
        hotkeyButton.Clicked();
        this.currentlySelectedHotkeyButton = hotkeyButton.IsWaitingForHotkeyInput() ? hotkeyButton : null;
    }

    protected void func_73869_a(char key, int keycode) {
        if (this.currentlySelectedHotkeyButton != null) {
            if (keycode == 1) {
                this.currentlySelectedHotkeyButton.Cancel();
                this.currentlySelectedHotkeyButton = null;
                return;
            }
            this.currentlySelectedHotkeyButton.ApplyHotkey(keycode);
        }
        if (keycode == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
    }

    public GuiButton GetButtonById(int id) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            if (button.field_146127_k != id) continue;
            return button;
        }
        return null;
    }

    public boolean IsButtonTabSelected(String buttonTabLabel) {
        if (this.currentlySelectedTabButton != null) {
            return this.currentlySelectedTabButton.field_146126_j.replace(this.currentlySelectedTabButtonColor, "").equals(buttonTabLabel);
        }
        return false;
    }

    public void IncrementTabbedPage() {
        if (++tabbedPage >= tabbedMaxPages) {
            tabbedPage = tabbedMaxPages;
        } else {
            this.screenTitle = Localization.get("gui.options.title");
            this.DrawAllButtons();
        }
    }

    public void DecrementTabbedPage() {
        if (--tabbedPage < 0) {
            tabbedPage = 0;
        } else {
            this.screenTitle = Localization.get("gui.options.title");
            this.DrawAllButtons();
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 15, 0xFFFFFF);
        this.DrawMiscText();
        super.func_73863_a(par1, par2, par3);
    }
}

