/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.Localization;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWeb;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.lwjgl.opengl.GL11;

public class SafeOverlay
extends ZyinHUDModBase {
    public static boolean Enabled;
    public static Modes Mode;
    protected int updateFrequency;
    protected static final int updateFrequencyMin = 100;
    protected static final int updateFrequencyMax = 8000;
    protected int drawDistance = 20;
    public static final int defaultDrawDistance = 20;
    public static final int minDrawDistance = 2;
    public static final int maxDrawDistance = 175;
    private float unsafeOverlayTransparency;
    private float unsafeOverlayMinTransparency = 0.11f;
    private float unsafeOverlayMaxTransparency = 1.0f;
    private long lastGenerate;
    public boolean displayInNether = false;
    private boolean renderUnsafePositionsThroughWalls = false;
    private Position playerPosition;
    private Position cachePosition = new Position();
    private static List<Position> unsafePositionCache;
    private Minecraft mc;
    private EntityPlayer player;
    private static boolean recalculateUnsafePositionsFlag;
    private List<Thread> safeCalculatorThreads = Collections.synchronizedList(new ArrayList(this.drawDistance * 2 + 1));
    public static SafeOverlay instance;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    protected SafeOverlay() {
        this.mc = Minecraft.func_71410_x();
        this.player = this.mc.field_71439_g;
        this.playerPosition = new Position();
        unsafePositionCache = Collections.synchronizedList(new ArrayList());
    }

    @SubscribeEvent
    public void PlayerInteractEvent(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        int x = event.x;
        int y = event.y;
        int z = event.z;
        int blockFace = event.face;
        if (blockFace == 0) {
            --y;
        } else if (blockFace == 1) {
            ++y;
        } else if (blockFace == 2) {
            --z;
        } else if (blockFace == 3) {
            ++z;
        } else if (blockFace == 4) {
            --x;
        } else if (blockFace == 5) {
            ++x;
        }
        Block blockPlaced = this.mc.field_71441_e.func_147439_a(x, y, z);
        if (blockPlaced != Blocks.field_150350_a) {
            this.OnBlockPlaced(blockPlaced, x, y, z);
        }
    }

    public void OnBlockPlaced(Block block, int x, int y, int z) {
        if (block.func_149750_m() > 0) {
            this.OnLightEmittingBlockPlaced(block, x, y, z);
        }
    }

    public void OnLightEmittingBlockPlaced(Block block, int x, int y, int z) {
        this.RecalculateUnsafePositions();
    }

    public static boolean CanMobsSpawnAtPosition(Position pos) {
        if (pos.CanMobsSpawnOnBlock(0, 0, 0) && pos.CanMobsSpawnInBlock(0, 1, 0) && pos.GetLightLevelWithoutSky() < 8) {
            if (pos.IsAirBlock(0, 2, 0)) {
                return true;
            }
            if (!pos.IsOpaqueBlock(0, 2, 0) && pos.CanMobsSpawnInBlock(-1, 1, 1) && pos.CanMobsSpawnInBlock(-1, 1, 0) && pos.CanMobsSpawnInBlock(-1, 1, -1) && pos.CanMobsSpawnInBlock(0, 1, -1) && pos.CanMobsSpawnInBlock(0, 1, 1) && pos.CanMobsSpawnInBlock(1, 1, 1) && pos.CanMobsSpawnInBlock(1, 1, 0) && pos.CanMobsSpawnInBlock(1, 1, -1)) {
                return true;
            }
        }
        return false;
    }

    public void RenderAllUnsafePositionsMultithreaded(float partialTickTime) {
        if (!Enabled || Mode == Modes.OFF) {
            return;
        }
        this.player = this.mc.field_71439_g;
        if (!this.displayInNether && this.player.field_71093_bK == -1) {
            return;
        }
        double x = this.player.field_70142_S + (this.player.field_70165_t - this.player.field_70142_S) * (double)partialTickTime;
        double y = this.player.field_70137_T + (this.player.field_70163_u - this.player.field_70137_T) * (double)partialTickTime;
        double z = this.player.field_70136_U + (this.player.field_70161_v - this.player.field_70136_U) * (double)partialTickTime;
        this.playerPosition = new Position((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        if (recalculateUnsafePositionsFlag || System.currentTimeMillis() - this.lastGenerate > (long)this.updateFrequency) {
            this.CalculateUnsafePositionsMultithreaded();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.renderUnsafePositionsThroughWalls) {
            GL11.glClear((int)256);
        } else {
            GL11.glEnable((int)2929);
        }
        GL11.glBegin((int)1);
        for (Position position : unsafePositionCache) {
            this.RenderUnsafeMarker(position);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)1, (int)0);
        GL11.glPopMatrix();
    }

    protected void RenderUnsafeMarker(Position position) {
        float alpha;
        float b;
        float g;
        float r;
        int lightLevelWithoutSky;
        Block block = position.GetBlock(0, 0, 0);
        Block blockAbove = position.GetBlock(0, 1, 0);
        block = block == null ? Blocks.field_150348_b : block;
        double boundingBoxMinX = 0.0;
        double boundingBoxMaxX = 1.0;
        double boundingBoxMaxY = block.func_149669_A();
        double boundingBoxMinZ = 0.0;
        double boundingBoxMaxZ = 1.0;
        int lightLevelWithSky = position.GetLightLevelWithSky();
        if (lightLevelWithSky > (lightLevelWithoutSky = position.GetLightLevelWithoutSky()) && lightLevelWithSky > 7) {
            int blockLightLevel = Math.max(lightLevelWithSky, lightLevelWithoutSky);
            float colorBrightnessModifier = (float)blockLightLevel / 15.0f;
            r = 1.0f * colorBrightnessModifier;
            g = 1.0f * colorBrightnessModifier;
            b = 0.0f;
            alpha = this.unsafeOverlayTransparency;
        } else {
            r = 0.5f;
            g = 0.0f;
            b = 0.0f;
            alpha = this.unsafeOverlayTransparency;
        }
        if (block instanceof BlockSlab) {
            boundingBoxMaxY = 1.0;
        }
        if (blockAbove != null) {
            int snowMetadata;
            if (blockAbove instanceof BlockRailBase || blockAbove instanceof BlockBasePressurePlate || blockAbove instanceof BlockCarpet) {
                boundingBoxMaxY = 1.0 + blockAbove.func_149669_A();
            } else if (blockAbove instanceof BlockSnow && (snowMetadata = this.mc.field_71441_e.func_72805_g(position.x, position.y + 1, position.z)) == 0) {
                boundingBoxMaxY = 1.125;
            }
        }
        double minX = (double)position.x + boundingBoxMinX + 0.02;
        double maxX = (double)position.x + boundingBoxMaxX - 0.02;
        double maxY = (double)position.y + boundingBoxMaxY + 0.02;
        double minZ = (double)position.z + boundingBoxMinZ + 0.02;
        double maxZ = (double)position.z + boundingBoxMaxZ - 0.02;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)maxZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)maxX, (double)maxY, (double)minZ);
        GL11.glVertex3d((double)minX, (double)maxY, (double)maxZ);
    }

    protected void CalculateUnsafePositionsMultithreaded() {
        unsafePositionCache.clear();
        for (int y = -this.drawDistance; y < this.drawDistance; ++y) {
            this.safeCalculatorThreads.add(new SafeCalculatorThread(y));
        }
        recalculateUnsafePositionsFlag = false;
        this.cachePosition = this.playerPosition;
        for (Thread t : this.safeCalculatorThreads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.lastGenerate = System.currentTimeMillis();
    }

    public void RecalculateUnsafePositions() {
        recalculateUnsafePositionsFlag = true;
    }

    public static String CalculateMessageForInfoLine() {
        if (Mode == Modes.OFF) {
            return "\u00a7f";
        }
        if (Mode == Modes.ON) {
            return "\u00a7f" + Localization.get("safeoverlay.infoline") + " ";
        }
        return "\u00a7f??? ";
    }

    public int GetDrawDistance() {
        return this.drawDistance;
    }

    public int SetDrawDistance(int newDrawDistance) {
        this.drawDistance = MathHelper.func_76125_a((int)newDrawDistance, (int)2, (int)175);
        double percent = (double)this.drawDistance / 175.0;
        this.updateFrequency = (int)(7900.0 * percent + 100.0);
        this.RecalculateUnsafePositions();
        return this.drawDistance;
    }

    public int IncreaseDrawDistance() {
        return this.SetDrawDistance(this.drawDistance + 3);
    }

    public int DecreaseDrawDistance() {
        return this.SetDrawDistance(this.drawDistance - 3);
    }

    public int IncreaseDrawDistance(int amount) {
        return this.SetDrawDistance(this.drawDistance + amount);
    }

    public int DecreaseDrawDistance(int amount) {
        return this.SetDrawDistance(this.drawDistance - amount);
    }

    public boolean GetSeeUnsafePositionsThroughWalls() {
        return this.renderUnsafePositionsThroughWalls;
    }

    public boolean SetDisplayInNether(Boolean displayInUnsafeAreasInNether) {
        this.displayInNether = displayInUnsafeAreasInNether;
        return this.displayInNether;
    }

    public boolean GetDisplayInNether() {
        return this.displayInNether;
    }

    public boolean ToggleDisplayInNether() {
        return this.SetDisplayInNether(!this.displayInNether);
    }

    public boolean SetSeeUnsafePositionsThroughWalls(Boolean safeOverlaySeeThroughWalls) {
        this.renderUnsafePositionsThroughWalls = safeOverlaySeeThroughWalls;
        return this.renderUnsafePositionsThroughWalls;
    }

    public boolean ToggleSeeUnsafePositionsThroughWalls() {
        return this.SetSeeUnsafePositionsThroughWalls(!this.renderUnsafePositionsThroughWalls);
    }

    public float SetUnsafeOverlayTransparency(float alpha) {
        this.unsafeOverlayTransparency = MathHelper.func_76131_a((float)alpha, (float)this.unsafeOverlayMinTransparency, (float)this.unsafeOverlayMaxTransparency);
        return this.unsafeOverlayTransparency;
    }

    public float GetUnsafeOverlayTransparency() {
        return this.unsafeOverlayTransparency;
    }

    public float GetUnsafeOverlayMinTransparency() {
        return this.unsafeOverlayMinTransparency;
    }

    public float GetUnsafeOverlayMaxTransparency() {
        return this.unsafeOverlayMaxTransparency;
    }

    static {
        recalculateUnsafePositionsFlag = false;
        instance = new SafeOverlay();
    }

    class Position {
        public int x;
        public int y;
        public int z;

        public Position() {
        }

        public Position(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Position(Position o) {
            this(o.x, o.y, o.z);
        }

        public Position(Position o, int dx, int dy, int dz) {
            this(o.x + dx, o.y + dy, o.z + dz);
        }

        public Block GetBlock(int dx, int dy, int dz) {
            return ((SafeOverlay)SafeOverlay.this).mc.field_71441_e.func_147439_a(this.x + dx, this.y + dy, this.z + dz);
        }

        public boolean CanMobsSpawnOnBlock(int dx, int dy, int dz) {
            Block block = this.GetBlock(dx, dy, dz);
            if (block == null || block == Blocks.field_150350_a) {
                return false;
            }
            if (block != Blocks.field_150350_a && block.func_149662_c()) {
                return true;
            }
            WorldClient cfr_ignored_0 = ((SafeOverlay)SafeOverlay.this).mc.field_71441_e;
            if (WorldClient.func_147466_a((IBlockAccess)((SafeOverlay)SafeOverlay.this).mc.field_71441_e, (int)(this.x + dx), (int)(this.y + dy), (int)(this.z + dz))) {
                return true;
            }
            return block instanceof BlockFarmland;
        }

        public boolean CanMobsSpawnInBlock(int dx, int dy, int dz) {
            Block block = this.GetBlock(dx, dy, dz);
            if (block == null) {
                return true;
            }
            if (block.func_149662_c()) {
                return false;
            }
            return !(block instanceof BlockSlab) && !(block instanceof BlockStairs) && !(block instanceof BlockLiquid) && !(block instanceof BlockChest) && !(block instanceof BlockGlass) && !(block instanceof BlockIce) && !(block instanceof BlockFence) && !(block instanceof BlockFenceGate) && !(block instanceof BlockLeaves) && !(block instanceof BlockWall) && !(block instanceof BlockPane) && !(block instanceof BlockWeb) && !(block instanceof BlockCactus) && !(block instanceof BlockAnvil) && !(block instanceof BlockBed) && !(block instanceof BlockFarmland) && !(block instanceof BlockHopper) && !(block instanceof BlockPistonBase) && !(block instanceof BlockPistonExtension) && !(block instanceof BlockPistonMoving) && !(block instanceof BlockCake);
        }

        public boolean IsOpaqueBlock(int dx, int dy, int dz) {
            Block block = this.GetBlock(dx, dy, dz);
            if (block == null) {
                return false;
            }
            return block.func_149662_c();
        }

        public boolean IsAirBlock(int dx, int dy, int dz) {
            Block block = this.GetBlock(dx, dy, dz);
            return block == Blocks.field_150350_a;
        }

        public int GetLightLevelWithoutSky() {
            return ((SafeOverlay)SafeOverlay.this).mc.field_71441_e.func_72972_b(EnumSkyBlock.Block, this.x, this.y + 1, this.z);
        }

        public int GetLightLevelWithSky() {
            return ((SafeOverlay)SafeOverlay.this).mc.field_71441_e.func_72972_b(EnumSkyBlock.Sky, this.x, this.y + 1, this.z);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position that = (Position)o;
            if (this.x != that.x) {
                return false;
            }
            if (this.y != that.y) {
                return false;
            }
            return this.z == that.z;
        }

        public int hashCode() {
            int result = this.x ^ this.x >>> 16;
            result = 31 * result + (this.y ^ this.y >>> 16);
            result = 31 * result + (this.z ^ this.z >>> 16);
            return result;
        }
    }

    class SafeCalculatorThread
    extends Thread {
        private int y;

        SafeCalculatorThread(int y) {
            super("Safe Overlay Calculator Thread at y=" + y);
            this.y = y;
            this.start();
        }

        @Override
        public void run() {
            Position pos = new Position();
            for (int x = -SafeOverlay.this.drawDistance; x < SafeOverlay.this.drawDistance; ++x) {
                for (int z = -SafeOverlay.this.drawDistance; z < SafeOverlay.this.drawDistance; ++z) {
                    pos.x = ((SafeOverlay)SafeOverlay.this).playerPosition.x + x;
                    pos.y = ((SafeOverlay)SafeOverlay.this).playerPosition.y + this.y;
                    pos.z = ((SafeOverlay)SafeOverlay.this).playerPosition.z + z;
                    if (!SafeOverlay.CanMobsSpawnAtPosition(pos)) continue;
                    unsafePositionCache.add(new Position(pos));
                }
            }
        }
    }

    public static enum Modes {
        OFF(Localization.get("safeoverlay.mode.off")),
        ON(Localization.get("safeoverlay.mode.on"));

        private String friendlyName;

        private Modes(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static Modes ToggleMode() {
            Mode = Mode.ordinal() < Modes.values().length - 1 ? Modes.values()[Mode.ordinal() + 1] : Modes.values()[0];
            return Mode;
        }

        public static Modes GetMode(String modeName) {
            try {
                return Modes.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                return Modes.values()[0];
            }
        }

        public String GetFriendlyName() {
            return this.friendlyName;
        }
    }
}

