/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.mods.InfoLine;
import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.InventoryUtil;
import com.zyin.zyinhud.util.Localization;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import java.awt.AWTException;
import java.awt.Robot;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class PotionAid
extends ZyinHUDModBase {
    public static boolean Enabled;
    private Timer timer = new Timer();
    private TimerTask swapTimerTask;
    private TimerTask drinkTimerTask;
    private Robot r = null;
    private boolean isCurrentlyDrinking;
    private boolean previousDrinkFromHotbar;
    private int potionItemIndex;
    private int currentItemInventoryIndex;
    private int currentItemHotbarIndex;
    private static int potionDrinkDuration;
    public static PotionAid instance;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    private PotionAid() {
        try {
            this.r = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.isCurrentlyDrinking = false;
        this.previousDrinkFromHotbar = false;
    }

    public void Drink() {
        if (ZyinHUDUtil.IsMouseoveredBlockRightClickable()) {
            return;
        }
        if (this.isCurrentlyDrinking) {
            this.StopDrinking();
            return;
        }
        this.potionItemIndex = this.GetMostAppropriatePotionItemIndexFromInventory();
        if (this.potionItemIndex < 0) {
            InfoLine.DisplayNotification(Localization.get("potionaid.noappropriatepotions"));
            return;
        }
        if (this.potionItemIndex > 35 && this.potionItemIndex < 45) {
            this.StartDrinkingFromHotbar(this.potionItemIndex);
        } else {
            this.StartDrinkingFromInventory(this.potionItemIndex);
        }
    }

    private void StartDrinkingFromHotbar(int potionHotbarIndex) {
        if (potionHotbarIndex < 36 | potionHotbarIndex > 44) {
            return;
        }
        this.currentItemHotbarIndex = PotionAid.mc.field_71439_g.field_71071_by.field_70461_c;
        potionHotbarIndex = InventoryUtil.TranslateInventoryIndexToHotbarIndex(potionHotbarIndex);
        int previouslySelectedHotbarSlotIndex = PotionAid.mc.field_71439_g.field_71071_by.field_70461_c;
        PotionAid.mc.field_71439_g.field_71071_by.field_70461_c = potionHotbarIndex;
        this.r.mousePress(4);
        this.isCurrentlyDrinking = true;
        this.previousDrinkFromHotbar = true;
        this.drinkTimerTask = new StopDrinkingTimerTask(this.r, previouslySelectedHotbarSlotIndex);
        this.timer.schedule(this.drinkTimerTask, potionDrinkDuration + InventoryUtil.GetSuggestedItemSwapDelay());
    }

    private void StartDrinkingFromInventory(int potionInventoryIndex) {
        if (potionInventoryIndex < 9 | potionInventoryIndex > 35) {
            return;
        }
        this.currentItemInventoryIndex = InventoryUtil.GetCurrentlySelectedItemInventoryIndex();
        InventoryUtil.Swap(this.currentItemInventoryIndex, potionInventoryIndex);
        this.r.mousePress(4);
        this.isCurrentlyDrinking = true;
        this.previousDrinkFromHotbar = false;
        this.drinkTimerTask = new StopDrinkingTimerTask(this.r);
        this.timer.schedule(this.drinkTimerTask, potionDrinkDuration);
        this.swapTimerTask = InventoryUtil.instance.SwapWithDelay(this.currentItemInventoryIndex, potionInventoryIndex, potionDrinkDuration + InventoryUtil.GetSuggestedItemSwapDelay());
    }

    public void StopDrinking() {
        if (this.previousDrinkFromHotbar) {
            this.StopDrinkingFromHotbar();
        } else {
            this.StopDrinkingFromInventory();
        }
    }

    private void StopDrinkingFromInventory() {
        this.r.mouseRelease(4);
        this.drinkTimerTask.cancel();
        this.swapTimerTask.cancel();
        InventoryUtil.Swap(this.currentItemInventoryIndex, this.potionItemIndex);
        this.isCurrentlyDrinking = false;
    }

    private void StopDrinkingFromHotbar() {
        this.r.mouseRelease(4);
        this.drinkTimerTask.cancel();
        PotionAid.mc.field_71439_g.field_71071_by.field_70461_c = this.currentItemHotbarIndex;
        this.isCurrentlyDrinking = false;
    }

    public boolean isDrinking() {
        return this.isCurrentlyDrinking;
    }

    public int GetMostAppropriatePotionItemIndexFromInventory() {
        List inventorySlots = PotionAid.mc.field_71439_g.field_71069_bz.field_75151_b;
        int fireResistancePotionIndex = -1;
        int healPotionIndex = -1;
        int regenerationPotionIndex = -1;
        int moveSpeedPotionIndex = -1;
        int damageBoostPotionIndex = -1;
        int invisibilityPotionIndex = -1;
        for (int i = 9; i < inventorySlots.size(); ++i) {
            Item item;
            Slot slot = (Slot)inventorySlots.get(i);
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack == null || !((item = itemStack.func_77973_b()) instanceof ItemPotion)) continue;
            ItemPotion potion = (ItemPotion)item;
            boolean isSplashPotion = ItemPotion.func_77831_g((int)itemStack.func_77960_j());
            if (isSplashPotion) continue;
            List potionEffects = potion.func_77834_f(itemStack.func_77960_j());
            PotionEffect potionEffect = (PotionEffect)potionEffects.get(0);
            String potionEffectName = potionEffect.func_76453_d();
            if (potionEffectName.equals("potion.fireResistance")) {
                fireResistancePotionIndex = i;
                continue;
            }
            if (potionEffectName.equals("potion.heal")) {
                healPotionIndex = i;
                continue;
            }
            if (potionEffectName.equals("potion.regeneration")) {
                regenerationPotionIndex = i;
                continue;
            }
            if (potionEffectName.equals("potion.moveSpeed")) {
                moveSpeedPotionIndex = i;
                continue;
            }
            if (potionEffectName.equals("potion.damageBoost")) {
                damageBoostPotionIndex = i;
                continue;
            }
            if (!potionEffectName.equals("potion.invisibility")) continue;
            invisibilityPotionIndex = i;
        }
        boolean hasMoveSpeedPotionEffect = false;
        boolean hasDamageBoostPotionEffect = false;
        boolean hasInvisibilityPotionEffect = false;
        boolean hasRegenerationPotionEffect = false;
        Collection potionEffects = PotionAid.mc.field_71439_g.func_70651_bq();
        for (PotionEffect potionEffect : potionEffects) {
            String potionEffectName = potionEffect.func_76453_d();
            if (potionEffectName.equals("potion.regeneration")) {
                hasRegenerationPotionEffect = true;
                continue;
            }
            if (potionEffectName.equals("potion.fireResistance")) {
                hasRegenerationPotionEffect = true;
                continue;
            }
            if (potionEffectName.equals("potion.moveSpeed")) {
                hasMoveSpeedPotionEffect = true;
                continue;
            }
            if (potionEffectName.equals("potion.damageBoost")) {
                hasDamageBoostPotionEffect = true;
                continue;
            }
            if (!potionEffectName.equals("potion.invisibility")) continue;
            hasInvisibilityPotionEffect = true;
        }
        boolean isOnFire = PotionAid.mc.field_71439_g.func_70027_ad();
        boolean isInjured = PotionAid.mc.field_71439_g.func_70996_bM();
        if (fireResistancePotionIndex > -1 && isOnFire) {
            return fireResistancePotionIndex;
        }
        if (healPotionIndex > -1 && isInjured) {
            return healPotionIndex;
        }
        if (regenerationPotionIndex > -1 && !hasRegenerationPotionEffect && isInjured) {
            return regenerationPotionIndex;
        }
        if (moveSpeedPotionIndex > -1 && !hasMoveSpeedPotionEffect) {
            return moveSpeedPotionIndex;
        }
        if (damageBoostPotionIndex > -1 && !hasDamageBoostPotionEffect) {
            return damageBoostPotionIndex;
        }
        if (invisibilityPotionIndex > -1 && !hasInvisibilityPotionEffect) {
            return invisibilityPotionIndex;
        }
        return -1;
    }

    static {
        potionDrinkDuration = 2000;
        instance = new PotionAid();
    }

    private class StopDrinkingTimerTask
    extends TimerTask {
        private Robot r;
        private int hotbarIndexToBeSelected = -1;

        StopDrinkingTimerTask(Robot r) {
            this.r = r;
        }

        StopDrinkingTimerTask(Robot r, int hotbarIndexToBeSelected) {
            this.r = r;
            this.hotbarIndexToBeSelected = hotbarIndexToBeSelected;
        }

        @Override
        public void run() {
            this.r.mouseRelease(4);
            PotionAid.this.isCurrentlyDrinking = false;
            if (this.hotbarIndexToBeSelected > -1) {
                ZyinHUDModBase.mc.field_71439_g.field_71071_by.field_70461_c = this.hotbarIndexToBeSelected;
            }
        }
    }
}

