/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.Localization;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PlayerLocator
extends ZyinHUDModBase {
    public static boolean Enabled;
    public static Modes Mode;
    public static boolean ShowDistanceToPlayers;
    public static boolean ShowPlayerHealth;
    public static boolean ShowWolves;
    public static boolean UseWolfColors;
    private static final ResourceLocation iconsResourceLocation;
    private static final double pi = Math.PI;
    private static final String wolfName;
    private static final String sprintingMessagePrefix = "";
    private static final String sneakingMessagePrefix = "\u00a7o";
    private static final String ridingMessagePrefix = "    ";
    public static int viewDistanceCutoff;
    public static final int minViewDistanceCutoff = 0;
    public static final int maxViewDistanceCutoff = 120;
    public static int numOverlaysRendered;
    public static final int maxNumberOfOverlays = 50;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    public static void RenderEntityInfoOnHUD(Entity entity, int x, int y, boolean isEntityBehindUs) {
        if (numOverlaysRendered > 50) {
            return;
        }
        if (!(entity instanceof EntityOtherPlayerMP) && !(entity instanceof EntityWolf)) {
            return;
        }
        if (Enabled && Mode == Modes.ON && (PlayerLocator.mc.field_71415_G || PlayerLocator.mc.field_71462_r == null || PlayerLocator.mc.field_71462_r instanceof GuiChat) && !PlayerLocator.mc.field_71474_y.field_74330_P) {
            float distanceFromMe = PlayerLocator.mc.field_71439_g.func_70032_d(entity);
            if (distanceFromMe > 120.0f || distanceFromMe < (float)viewDistanceCutoff || distanceFromMe == 0.0f) {
                return;
            }
            String overlayMessage = sprintingMessagePrefix;
            int rgb = 0xFFFFFF;
            if (entity instanceof EntityOtherPlayerMP) {
                overlayMessage = PlayerLocator.GetOverlayMessageForOtherPlayer((EntityOtherPlayerMP)entity, distanceFromMe);
            } else if (entity instanceof EntityWolf) {
                if (!ShowWolves || !PlayerLocator.PlayerIsWolfsOwner((EntityWolf)entity)) {
                    return;
                }
                overlayMessage = PlayerLocator.GetOverlayMessageForWolf((EntityWolf)entity, distanceFromMe);
                if (UseWolfColors) {
                    int collarColor = ((EntityWolf)entity).func_82186_bH();
                    int r = (int)(EntitySheep.field_70898_d[collarColor][0] * 255.0f);
                    int g = (int)(EntitySheep.field_70898_d[collarColor][1] * 255.0f);
                    int b = (int)(EntitySheep.field_70898_d[collarColor][2] * 255.0f);
                    rgb = (r << 16) + (g << 8) + b;
                    r = (255 - r) / 2;
                    g = (255 - g) / 2;
                    b = (255 - b) / 2;
                    rgb += (r << 16) + (g << 8) + b;
                }
            }
            if (entity.field_70154_o != null) {
                overlayMessage = ridingMessagePrefix + overlayMessage;
            }
            int overlayMessageWidth = PlayerLocator.mc.field_71466_p.func_78256_a(overlayMessage);
            ScaledResolution res = new ScaledResolution(PlayerLocator.mc.field_71474_y, PlayerLocator.mc.field_71443_c, PlayerLocator.mc.field_71440_d);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            x = (x -= overlayMessageWidth / 2) > width - overlayMessageWidth ? width - overlayMessageWidth : x;
            x = x < 0 ? 0 : x;
            y = y > height - 10 && !ShowPlayerHealth ? height - 10 : y;
            y = y > height - 20 && ShowPlayerHealth ? height - 20 : y;
            y = y < 10 ? 10 : y;
            int alpha = (int)(85.0f + 170.0f * ((120.0f - distanceFromMe) / 120.0f));
            int color = (alpha << 24) + rgb;
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            PlayerLocator.mc.field_71466_p.func_78261_a(overlayMessage, x, y, color);
            if (entity.field_70154_o instanceof EntityHorse) {
                int armor = ((EntityHorse)entity.field_70154_o).func_110241_cb();
                if (armor == 1) {
                    PlayerLocator.RenderHorseArmorIronIcon(x, y);
                } else if (armor == 2) {
                    PlayerLocator.RenderHorseArmorGoldIcon(x, y);
                } else if (armor == 3) {
                    PlayerLocator.RenderHorseArmorDiamondIcon(x, y);
                } else if (((EntityHorse)entity.field_70154_o).func_110257_ck()) {
                    PlayerLocator.RenderSaddleIcon(x, y);
                }
            }
            if (entity.field_70154_o instanceof EntityPig) {
                PlayerLocator.RenderSaddleIcon(x, y);
            } else if (entity.field_70154_o instanceof EntityMinecart) {
                PlayerLocator.RenderMinecartIcon(x, y);
            } else if (entity.field_70154_o instanceof EntityBoat) {
                PlayerLocator.RenderBoatIcon(x, y);
            }
            if (ShowPlayerHealth) {
                int numHearts = (int)((((EntityLivingBase)entity).func_110143_aJ() + 1.0f) / 2.0f);
                String hpOverlayMessage = numHearts + sprintingMessagePrefix;
                int hpOverlayMessageWidth = PlayerLocator.mc.field_71466_p.func_78256_a(hpOverlayMessage);
                int offsetX = (overlayMessageWidth - hpOverlayMessageWidth - 9) / 2;
                PlayerLocator.mc.field_71466_p.func_78261_a(hpOverlayMessage, x + offsetX, y + 10, (alpha << 24) + 0xFFFFFF);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha / 255.0f));
                ZyinHUDUtil.DrawTexture(x + offsetX + hpOverlayMessageWidth + 1, y + 9, 16, 0, 9, 9, iconsResourceLocation, 1.0f);
                ZyinHUDUtil.DrawTexture(x + offsetX + hpOverlayMessageWidth + 1, y + 9, 52, 0, 9, 9, iconsResourceLocation, 1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GL11.glDisable((int)3042);
            ++numOverlaysRendered;
        }
    }

    private static boolean PlayerIsWolfsOwner(EntityWolf wolf) {
        return PlayerLocator.mc.field_71439_g.getDisplayName().equals(wolf.func_70905_p());
    }

    private static String GetOverlayMessageForWolf(EntityWolf wolf, float distanceFromMe) {
        String overlayMessage = wolf.func_94057_bL().isEmpty() ? wolfName : wolf.func_94057_bL();
        if (ShowDistanceToPlayers) {
            overlayMessage = "\u00a77[" + (int)distanceFromMe + "] " + "\u00a7r" + overlayMessage;
        }
        return overlayMessage;
    }

    private static String GetOverlayMessageForOtherPlayer(EntityOtherPlayerMP otherPlayer, float distanceFromMe) {
        String overlayMessage = otherPlayer.getDisplayName();
        if (ShowDistanceToPlayers) {
            overlayMessage = "\u00a77[" + (int)distanceFromMe + "] " + "\u00a7r" + overlayMessage;
        }
        if (otherPlayer.func_70051_ag()) {
            overlayMessage = sprintingMessagePrefix + overlayMessage;
        }
        if (otherPlayer.func_70093_af()) {
            overlayMessage = sneakingMessagePrefix + overlayMessage;
        }
        if (otherPlayer.func_70115_ae()) {
            overlayMessage = ridingMessagePrefix + overlayMessage;
        }
        return overlayMessage;
    }

    private static void RenderBoatIcon(int x, int y) {
        itemRenderer.func_77015_a(PlayerLocator.mc.field_71466_p, PlayerLocator.mc.field_71446_o, new ItemStack(Items.field_151124_az), x, y - 4);
        GL11.glDisable((int)2896);
    }

    private static void RenderMinecartIcon(int x, int y) {
        itemRenderer.func_77015_a(PlayerLocator.mc.field_71466_p, PlayerLocator.mc.field_71446_o, new ItemStack(Items.field_151143_au), x, y - 4);
        GL11.glDisable((int)2896);
    }

    private static void RenderHorseArmorDiamondIcon(int x, int y) {
        itemRenderer.func_77015_a(PlayerLocator.mc.field_71466_p, PlayerLocator.mc.field_71446_o, new ItemStack(Items.field_151125_bZ), x, y - 4);
        GL11.glDisable((int)2896);
    }

    private static void RenderHorseArmorGoldIcon(int x, int y) {
        itemRenderer.func_77015_a(PlayerLocator.mc.field_71466_p, PlayerLocator.mc.field_71446_o, new ItemStack(Items.field_151136_bY), x, y - 4);
        GL11.glDisable((int)2896);
    }

    private static void RenderHorseArmorIronIcon(int x, int y) {
        itemRenderer.func_77015_a(PlayerLocator.mc.field_71466_p, PlayerLocator.mc.field_71446_o, new ItemStack(Items.field_151138_bX), x, y - 4);
        GL11.glDisable((int)2896);
    }

    private static void RenderSaddleIcon(int x, int y) {
        itemRenderer.func_77015_a(PlayerLocator.mc.field_71466_p, PlayerLocator.mc.field_71446_o, new ItemStack(Items.field_151141_av), x, y - 4);
        GL11.glDisable((int)2896);
    }

    public static String CalculateMessageForInfoLine() {
        if (Mode == Modes.OFF) {
            return "\u00a7f";
        }
        if (Mode == Modes.ON) {
            return "\u00a7f" + Localization.get("playerlocator.infoline") + " ";
        }
        return "\u00a7f??? ";
    }

    public static boolean ToggleShowDistanceToPlayers() {
        ShowDistanceToPlayers = !ShowDistanceToPlayers;
        return ShowDistanceToPlayers;
    }

    public static boolean ToggleShowPlayerHealth() {
        ShowPlayerHealth = !ShowPlayerHealth;
        return ShowPlayerHealth;
    }

    public static boolean ToggleShowWolves() {
        ShowWolves = !ShowWolves;
        return ShowWolves;
    }

    public static boolean ToggleUseWolfColors() {
        UseWolfColors = !UseWolfColors;
        return UseWolfColors;
    }

    static {
        iconsResourceLocation = new ResourceLocation("textures/gui/icons.png");
        wolfName = Localization.getMinecraft("entity.Wolf.name");
        viewDistanceCutoff = 10;
    }

    public static enum Modes {
        OFF(Localization.get("playerlocator.mode.off")),
        ON(Localization.get("playerlocator.mode.on"));

        private String friendlyName;

        private Modes(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static Modes ToggleMode() {
            Mode = Mode.ordinal() < Modes.values().length - 1 ? Modes.values()[Mode.ordinal() + 1] : Modes.values()[0];
            return Mode;
        }

        public static Modes GetMode(String modeName) {
            try {
                return Modes.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                return Modes.values()[0];
            }
        }

        public String GetFriendlyName() {
            return this.friendlyName;
        }
    }
}

