/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.ZyinHUDSound;
import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.Localization;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.util.MathHelper;

public class HealthMonitor
extends ZyinHUDModBase {
    public static boolean Enabled;
    public static Modes Mode;
    private static Timer timer;
    private static int LowHealthSoundThreshold;
    public static boolean PlayFasterNearDeath;
    private static boolean isPlayingLowHealthSound;
    private static int repeatDelay;
    public static HealthMonitor instance;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    @SubscribeEvent
    public void ClientTickEvent(TickEvent.ClientTickEvent event) {
        if (Enabled && !isPlayingLowHealthSound) {
            HealthMonitor.PlayLowHealthSoundIfHurt();
        }
    }

    protected static void PlayLowHealthSoundIfHurt() {
        if (HealthMonitor.mc.field_71439_g == null) {
            return;
        }
        int playerHealth = (int)HealthMonitor.mc.field_71439_g.func_110143_aJ();
        if (playerHealth < LowHealthSoundThreshold && playerHealth > 0) {
            if (!HealthMonitor.mc.field_71442_b.func_78758_h() && !mc.func_147113_T() && HealthMonitor.mc.field_71415_G) {
                HealthMonitor.PlayLowHealthSound();
            }
            isPlayingLowHealthSound = true;
            int soundDelay = repeatDelay;
            if (PlayFasterNearDeath) {
                soundDelay = repeatDelay / 2 + (int)((float)repeatDelay / 2.0f * ((float)playerHealth / (float)LowHealthSoundThreshold));
            }
            PlayLowHealthSoundTimerTask t = new PlayLowHealthSoundTimerTask();
            timer.schedule((TimerTask)t, soundDelay);
        } else {
            isPlayingLowHealthSound = false;
        }
    }

    protected static String GetSoundNameFromMode() {
        return HealthMonitor.Mode.soundName;
    }

    public static void PlayLowHealthSound() {
        ZyinHUDSound.PlaySound(HealthMonitor.GetSoundNameFromMode());
    }

    public static void SetLowHealthSoundThreshold(int lowHealthSoundThreshold) {
        LowHealthSoundThreshold = MathHelper.func_76125_a((int)lowHealthSoundThreshold, (int)1, (int)20);
    }

    public static int GetLowHealthSoundThreshold() {
        return LowHealthSoundThreshold;
    }

    public static boolean TogglePlayFasterNearDeath() {
        PlayFasterNearDeath = !PlayFasterNearDeath;
        return PlayFasterNearDeath;
    }

    static {
        timer = new Timer();
        isPlayingLowHealthSound = false;
        repeatDelay = 1000;
        instance = new HealthMonitor();
    }

    private static class PlayLowHealthSoundTimerTask
    extends TimerTask {
        PlayLowHealthSoundTimerTask() {
        }

        @Override
        public void run() {
            HealthMonitor.PlayLowHealthSoundIfHurt();
        }
    }

    public static enum Modes {
        OOT(Localization.get("healthmonitor.mode.oot"), "lowhealth_OoT"),
        LTTP(Localization.get("healthmonitor.mode.lttp"), "lowhealth_LttP"),
        ORACLE(Localization.get("healthmonitor.mode.oracle"), "lowhealth_Oracle"),
        LA(Localization.get("healthmonitor.mode.la"), "lowhealth_LA"),
        LOZ(Localization.get("healthmonitor.mode.loz"), "lowhealth_LoZ"),
        AOL(Localization.get("healthmonitor.mode.aol"), "lowhealth_AoL");

        private String friendlyName;
        public String soundName;

        private Modes(String friendlyName, String soundName) {
            this.friendlyName = friendlyName;
            this.soundName = soundName;
        }

        public static Modes ToggleMode() {
            Mode = Mode.ordinal() < Modes.values().length - 1 ? Modes.values()[Mode.ordinal() + 1] : Modes.values()[0];
            return Mode;
        }

        public static Modes GetMode(String modeName) {
            try {
                return Modes.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                return OOT;
            }
        }

        public String GetFriendlyName() {
            return this.friendlyName;
        }
    }
}

