/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.gui.GuiZyinHUDOptions;
import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.InventoryUtil;
import com.zyin.zyinhud.util.Localization;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DurabilityInfo
extends ZyinHUDModBase {
    public static boolean Enabled;
    protected static final ResourceLocation durabilityIconsResourceLocation;
    public static boolean ShowArmorDurability;
    public static boolean ShowItemDurability;
    public static boolean ShowIndividualArmorIcons;
    public static boolean ShowDamageAsPercentage;
    public static boolean AutoUnequipArmor;
    public static boolean AutoUnequipTools;
    public static final int durabilityUpdateFrequency = 1000;
    protected static float armorDurabilityScaler;
    protected static int armorDurabilityIconU;
    protected static int armorDurabilityIconV;
    protected static int armorDurabilityIconX;
    protected static int armorDurabilityIconY;
    public static int toolX;
    public static int toolY;
    public static int durabalityLocX;
    public static int durabalityLocY;
    protected static int equipmentLocX;
    protected static int equipmentLocY;
    private static float durabilityDisplayThresholdForArmor;
    private static float durabilityDisplayThresholdForItem;
    private static ArrayList<ItemStack> damagedItemsList;
    private static long lastGenerate;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    public static void RenderOntoHUD() {
        if (Enabled && DurabilityInfo.mc.field_71415_G || DurabilityInfo.mc.field_71462_r != null && (DurabilityInfo.mc.field_71462_r instanceof GuiChat || DurabilityInfo.TabIsSelectedInOptionsGui()) && !DurabilityInfo.mc.field_71474_y.field_74330_P) {
            if (System.currentTimeMillis() - lastGenerate > 1000L) {
                DurabilityInfo.CalculateDurabilityIcons();
            }
            boolean armorExists = false;
            for (ItemStack itemStack : damagedItemsList) {
                if (!(itemStack.func_77973_b() instanceof ItemArmor)) continue;
                armorExists = true;
            }
            int numTools = 0;
            int numArmors = 0;
            for (ItemStack itemStack : damagedItemsList) {
                int y;
                int x;
                Item tool = itemStack.func_77973_b();
                if (tool instanceof ItemArmor) {
                    if (!ShowArmorDurability) continue;
                    if (ShowIndividualArmorIcons) {
                        x = durabalityLocX;
                        y = durabalityLocY + numArmors * toolY;
                        DurabilityInfo.DrawItemIcon(itemStack, x, y);
                        ++numArmors;
                        continue;
                    }
                    DurabilityInfo.DrawBrokenArmorTexture(durabalityLocX, durabalityLocY);
                    continue;
                }
                if (!ShowItemDurability) continue;
                x = durabalityLocX;
                y = durabalityLocY + numTools * toolY;
                if (armorExists && ShowArmorDurability) {
                    x = equipmentLocX;
                }
                DurabilityInfo.DrawItemIcon(itemStack, x, y);
                ++numTools;
            }
        }
    }

    protected static void DrawItemIcon(ItemStack itemStack, int x, int y) {
        GL11.glEnable((int)2929);
        itemRenderer.func_82406_b(DurabilityInfo.mc.field_71466_p, DurabilityInfo.mc.field_71446_o, itemStack, x, y);
        itemRenderer.func_77021_b(DurabilityInfo.mc.field_71466_p, DurabilityInfo.mc.field_71446_o, itemStack, x, y);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (itemStack.func_77960_j() != 0) {
            boolean unicodeFlag = DurabilityInfo.mc.field_71466_p.func_82883_a();
            DurabilityInfo.mc.field_71466_p.func_78264_a(true);
            String damageString = DurabilityInfo.GetDamageString(itemStack.func_77960_j(), itemStack.func_77958_k());
            int damageX = x + toolX - DurabilityInfo.mc.field_71466_p.func_78256_a(damageString);
            int damageY = y + toolY - DurabilityInfo.mc.field_71466_p.field_78288_b - 1;
            DurabilityInfo.mc.field_71466_p.func_78261_a(damageString, damageX, damageY, 0xFFFFFF);
            DurabilityInfo.mc.field_71466_p.func_78264_a(unicodeFlag);
        }
    }

    protected static void DrawBrokenArmorTexture(int x, int y) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        ZyinHUDUtil.DrawTexture(x, y, armorDurabilityIconU, armorDurabilityIconV, (int)((float)armorDurabilityIconX / armorDurabilityScaler), (int)((float)armorDurabilityIconY / armorDurabilityScaler), durabilityIconsResourceLocation, armorDurabilityScaler);
        GL11.glDisable((int)3042);
    }

    protected static void CalculateDurabilityIcons() {
        if (DurabilityInfo.mc.field_71415_G || DurabilityInfo.mc.field_71462_r != null && (DurabilityInfo.mc.field_71462_r instanceof GuiChat || DurabilityInfo.mc.field_71462_r instanceof GuiZyinHUDOptions && ((GuiZyinHUDOptions)DurabilityInfo.mc.field_71462_r).IsButtonTabSelected(Localization.get("durabilityinfo.name"))) && !DurabilityInfo.mc.field_71474_y.field_74321_H.func_151468_f()) {
            damagedItemsList.clear();
            DurabilityInfo.UnequipDamagedArmor();
            DurabilityInfo.UnequipDamagedTool();
            DurabilityInfo.CalculateDurabilityIconsForTools();
            DurabilityInfo.CalculateDurabilityIconsForArmor();
            lastGenerate = System.currentTimeMillis();
        }
    }

    private static void CalculateDurabilityIconsForTools() {
        ItemStack[] items = DurabilityInfo.mc.field_71439_g.field_71071_by.field_70462_a;
        for (int i = 0; i < 9; ++i) {
            Item item;
            ItemStack itemStack = items[i];
            if (itemStack == null || !((item = itemStack.func_77973_b()) instanceof ItemTool) && !(item instanceof ItemSword) && !(item instanceof ItemBow) && !(item instanceof ItemHoe) && !(item instanceof ItemShears) && !(item instanceof ItemFishingRod)) continue;
            int itemDamage = itemStack.func_77960_j();
            int maxDamage = itemStack.func_77958_k();
            if (maxDamage == 0 || !(1.0 - (double)itemDamage / (double)maxDamage <= (double)durabilityDisplayThresholdForItem)) continue;
            damagedItemsList.add(itemStack);
        }
    }

    private static void CalculateDurabilityIconsForArmor() {
        ItemStack[] armorStacks = DurabilityInfo.mc.field_71439_g.field_71071_by.field_70460_b;
        for (int i = armorStacks.length - 1; i >= 0; --i) {
            ItemStack armorStack = armorStacks[i];
            if (armorStack == null) continue;
            int itemDamage = armorStack.func_77960_j();
            int maxDamage = armorStack.func_77958_k();
            if (maxDamage == 0 || !(1.0 - (double)itemDamage / (double)maxDamage <= (double)durabilityDisplayThresholdForArmor)) continue;
            damagedItemsList.add(armorStack);
        }
    }

    private static void UnequipDamagedArmor() {
        if (AutoUnequipArmor) {
            ItemStack[] armorStacks = DurabilityInfo.mc.field_71439_g.field_71071_by.field_70460_b;
            for (int i = 0; i < armorStacks.length; ++i) {
                ItemStack armorStack = armorStacks[i];
                if (armorStack == null) continue;
                int itemDamage = armorStack.func_77960_j();
                int maxDamage = armorStack.func_77958_k();
                if (maxDamage == 0 || maxDamage - itemDamage >= 5) continue;
                InventoryUtil.MoveArmorIntoPlayerInventory(i);
            }
        }
    }

    private static void UnequipDamagedTool() {
        Item item;
        ItemStack itemStack;
        if (AutoUnequipTools && (itemStack = DurabilityInfo.mc.field_71439_g.field_71071_by.func_70448_g()) != null && ((item = itemStack.func_77973_b()) instanceof ItemTool || item instanceof ItemSword || item instanceof ItemBow || item instanceof ItemHoe || item instanceof ItemShears || item instanceof ItemFishingRod)) {
            int threshold;
            int itemDamage = itemStack.func_77960_j();
            int maxDamage = itemStack.func_77958_k();
            int n = threshold = item instanceof ItemFishingRod ? 5 : 15;
            if (maxDamage != 0 && maxDamage - itemDamage < threshold) {
                InventoryUtil.MoveHeldItemIntoPlayerInventory();
            }
        }
    }

    private static boolean TabIsSelectedInOptionsGui() {
        return DurabilityInfo.mc.field_71462_r instanceof GuiZyinHUDOptions && ((GuiZyinHUDOptions)DurabilityInfo.mc.field_71462_r).IsButtonTabSelected(Localization.get("durabilityinfo.name"));
    }

    public static float GetDurabilityDisplayThresholdForArmor() {
        return durabilityDisplayThresholdForArmor;
    }

    public static void SetDurabilityDisplayThresholdForArmor(float durabilityDisplayThreshold) {
        durabilityDisplayThresholdForArmor = durabilityDisplayThreshold;
        DurabilityInfo.CalculateDurabilityIcons();
    }

    public static float GetDurabilityDisplayThresholdForItem() {
        return durabilityDisplayThresholdForItem;
    }

    public static void SetDurabilityDisplayThresholdForItem(float durabilityDisplayThreshold) {
        durabilityDisplayThresholdForItem = durabilityDisplayThreshold;
        DurabilityInfo.CalculateDurabilityIcons();
    }

    private static String GetDamageString(int currentDamage, int maxDamage) {
        if (ShowDamageAsPercentage) {
            return 100 - (int)((double)currentDamage / (double)maxDamage * 100.0) + "%";
        }
        return maxDamage - currentDamage + "";
    }

    public static int GetHorizontalLocation() {
        return durabalityLocX;
    }

    public static int SetHorizontalLocation(int x) {
        durabalityLocX = MathHelper.func_76125_a((int)x, (int)0, (int)DurabilityInfo.mc.field_71443_c);
        equipmentLocX = durabalityLocX + armorDurabilityIconX;
        return durabalityLocX;
    }

    public static int GetVerticalLocation() {
        return durabalityLocY;
    }

    public static int SetVerticalLocation(int y) {
        equipmentLocY = durabalityLocY = MathHelper.func_76125_a((int)y, (int)0, (int)DurabilityInfo.mc.field_71440_d);
        return durabalityLocY;
    }

    public static boolean ToggleShowArmorDurability() {
        ShowArmorDurability = !ShowArmorDurability;
        return ShowArmorDurability;
    }

    public static boolean ToggleShowItemDurability() {
        ShowItemDurability = !ShowItemDurability;
        return ShowItemDurability;
    }

    public static boolean ToggleShowDamageAsPercent() {
        ShowDamageAsPercentage = !ShowDamageAsPercentage;
        return ShowDamageAsPercentage;
    }

    public static boolean ToggleShowIndividualArmorIcons() {
        ShowIndividualArmorIcons = !ShowIndividualArmorIcons;
        return ShowIndividualArmorIcons;
    }

    public static boolean ToggleAutoUnequipArmor() {
        AutoUnequipArmor = !AutoUnequipArmor;
        return AutoUnequipArmor;
    }

    public static boolean ToggleAutoUnequipTools() {
        AutoUnequipTools = !AutoUnequipTools;
        return AutoUnequipTools;
    }

    static {
        durabilityIconsResourceLocation = new ResourceLocation("zyinhud:textures/durability_icons.png");
        armorDurabilityScaler = 0.2f;
        armorDurabilityIconU = 0;
        armorDurabilityIconV = 0;
        armorDurabilityIconX = (int)(80.0f * armorDurabilityScaler);
        armorDurabilityIconY = (int)(120.0 * (double)armorDurabilityScaler);
        toolX = 16;
        toolY = 16;
        durabalityLocX = 30;
        durabalityLocY = 20;
        equipmentLocX = 20 + armorDurabilityIconX;
        equipmentLocY = 20;
        damagedItemsList = new ArrayList(13);
    }
}

