/*
 * Decompiled with CFR 0.152.
 */
package com.zyin.zyinhud.mods;

import com.zyin.zyinhud.mods.ZyinHUDModBase;
import com.zyin.zyinhud.util.Localization;
import com.zyin.zyinhud.util.ZyinHUDUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import org.apache.commons.lang3.text.WordUtils;

public class AnimalInfo
extends ZyinHUDModBase {
    public static boolean Enabled;
    public static Modes Mode;
    public static boolean ShowTextBackgrounds;
    public static boolean ShowBreedingIcons;
    public static boolean ShowBreedingTimers;
    public static boolean ShowHorseStatsOnF3Menu;
    public static boolean ShowHorseStatsOverlay;
    public static boolean ShowBreedingTimerForVillagers;
    public static boolean ShowBreedingTimerForHorses;
    public static boolean ShowBreedingTimerForCows;
    public static boolean ShowBreedingTimerForSheep;
    public static boolean ShowBreedingTimerForPigs;
    public static boolean ShowBreedingTimerForChickens;
    public static int numberOfDecimalsDisplayed;
    public static int minNumberOfDecimalsDisplayed;
    public static int maxNumberOfDecimalsDisplayed;
    private static EntityClientPlayerMP me;
    private static double perfectHorseSpeedThreshold;
    private static double goodHorseSpeedThreshold;
    private static double badHorseSpeedThreshold;
    private static double perfectHorseJumpThreshold;
    private static double goodHorseJumpThreshold;
    private static double badHorseJumpThreshold;
    private static int perfectHorseHPThreshold;
    private static int goodHorseHPThreshold;
    private static int badHorseHPThreshold;
    private static final int verticalSpaceBetweenLines = 10;
    public static int viewDistanceCutoff;
    public static int minViewDistanceCutoff;
    public static int maxViewDistanceCutoff;
    public static final int maxNumberOfOverlays = 200;
    private static DecimalFormat decimalFormat;
    private static DecimalFormat twoDigitFormat;

    public static boolean ToggleEnabled() {
        Enabled = !Enabled;
        return Enabled;
    }

    private static DecimalFormat GetDecimalFormat() {
        if (numberOfDecimalsDisplayed < 1) {
            return new DecimalFormat("#");
        }
        String format = "#.";
        for (int i = 1; i <= numberOfDecimalsDisplayed; ++i) {
            format = format + "#";
        }
        return new DecimalFormat(format);
    }

    public static int GetNumberOfDecimalsDisplayed() {
        return numberOfDecimalsDisplayed;
    }

    public static void SetNumberOfDecimalsDisplayed(int numDecimals) {
        numberOfDecimalsDisplayed = numDecimals;
        decimalFormat = AnimalInfo.GetDecimalFormat();
    }

    public static void RenderOntoDebugMenu() {
        if (Enabled && ShowHorseStatsOnF3Menu && (AnimalInfo.mc.field_71415_G || AnimalInfo.mc.field_71462_r == null || AnimalInfo.mc.field_71462_r instanceof GuiChat) && AnimalInfo.mc.field_71474_y.field_74330_P && AnimalInfo.mc.field_71439_g.func_110317_t()) {
            EntityHorse horse = (EntityHorse)AnimalInfo.mc.field_71439_g.field_70154_o;
            String horseSpeedMessage = Localization.get("animalinfo.debug.speed") + " " + AnimalInfo.GetHorseSpeedText(horse) + " m/s";
            String horseJumpMessage = Localization.get("animalinfo.debug.jump") + " " + AnimalInfo.GetHorseJumpText(horse) + " blocks";
            String horseHPMessage = Localization.get("animalinfo.debug.hp") + " " + AnimalInfo.GetHorseHPText(horse);
            String horseColor = Localization.get("animalinfo.debug.color") + " " + AnimalInfo.GetHorseColoringText(horse);
            String horseMarking = Localization.get("animalinfo.debug.markings") + " " + AnimalInfo.GetHorseMarkingText(horse);
            AnimalInfo.mc.field_71466_p.func_78261_a(horseSpeedMessage, 2, 130, 0xFFFFFF);
            AnimalInfo.mc.field_71466_p.func_78261_a(horseJumpMessage, 2, 140, 0xFFFFFF);
            AnimalInfo.mc.field_71466_p.func_78261_a(horseHPMessage, 2, 150, 0xFFFFFF);
            if (horse.func_110265_bP() == 0) {
                AnimalInfo.mc.field_71466_p.func_78261_a(horseColor, 2, 170, 0xFFFFFF);
                AnimalInfo.mc.field_71466_p.func_78261_a(horseMarking, 2, 180, 0xFFFFFF);
            }
        }
    }

    public static void RenderEntityInfoInWorld(Entity entity, float partialTickTime) {
        if (!(entity instanceof EntityAgeable)) {
            return;
        }
        int i = 0;
        if (Enabled && Mode == Modes.ON && (AnimalInfo.mc.field_71415_G || AnimalInfo.mc.field_71462_r == null || AnimalInfo.mc.field_71462_r instanceof GuiChat) && !AnimalInfo.mc.field_71474_y.field_74330_P) {
            if (i > 200) {
                return;
            }
            EntityAgeable animal = (EntityAgeable)entity;
            if (animal.field_70153_n instanceof EntityClientPlayerMP) {
                return;
            }
            double distanceFromMe = AnimalInfo.mc.field_71439_g.func_70032_d((Entity)animal);
            if (distanceFromMe > (double)maxViewDistanceCutoff || distanceFromMe > (double)viewDistanceCutoff) {
                return;
            }
            AnimalInfo.RenderAnimalOverlay(animal, partialTickTime);
            ++i;
        }
    }

    protected static void RenderAnimalOverlay(EntityAgeable animal, float partialTickTime) {
        float x = (float)animal.field_70165_t;
        float y = (float)animal.field_70163_u;
        float z = (float)animal.field_70161_v;
        int animalGrowingAge = animal.func_70874_b();
        ArrayList<String> multilineOverlayArrayList = new ArrayList<String>(4);
        if (ShowHorseStatsOverlay && animal instanceof EntityHorse) {
            EntityHorse horse = (EntityHorse)animal;
            multilineOverlayArrayList.add(AnimalInfo.GetHorseSpeedText(horse) + " " + Localization.get("animalinfo.overlay.speed"));
            multilineOverlayArrayList.add(AnimalInfo.GetHorseHPText(horse) + " " + Localization.get("animalinfo.overlay.hp"));
            multilineOverlayArrayList.add(AnimalInfo.GetHorseJumpText(horse) + " " + Localization.get("animalinfo.overlay.jump"));
            if (animalGrowingAge < 0) {
                multilineOverlayArrayList.add(AnimalInfo.GetHorseBabyGrowingAgeAsPercent(horse) + "%");
            }
        }
        if (ShowBreedingTimers && (animal instanceof EntityVillager && ShowBreedingTimerForVillagers || animal instanceof EntityCow && ShowBreedingTimerForCows || animal instanceof EntitySheep && ShowBreedingTimerForSheep || animal instanceof EntityPig && ShowBreedingTimerForPigs || animal instanceof EntityChicken && ShowBreedingTimerForChickens || animal instanceof EntityHorse && ShowBreedingTimerForHorses) && animalGrowingAge > 0) {
            multilineOverlayArrayList.add(AnimalInfo.GetTimeUntilBreedAgain(animal));
        }
        String[] multilineOverlayMessage = new String[1];
        if ((multilineOverlayMessage = multilineOverlayArrayList.toArray(multilineOverlayMessage))[0] != null) {
            ZyinHUDUtil.RenderFloatingText(multilineOverlayMessage, x, y, z, 0xFFFFFF, ShowTextBackgrounds, partialTickTime);
        }
        if (ShowBreedingIcons && animalGrowingAge == 0 && animal instanceof EntityAnimal && !((EntityAnimal)animal).func_70880_s()) {
            if (animal instanceof EntityHorse && ((EntityHorse)animal).func_110248_bS()) {
                ZyinHUDUtil.RenderFloatingIcon(Items.field_151150_bK, x, y + animal.field_70131_O, z, partialTickTime);
            } else if (animal instanceof EntityCow) {
                ZyinHUDUtil.RenderFloatingIcon(Items.field_151015_O, x, y + animal.field_70131_O, z, partialTickTime);
            } else if (animal instanceof EntitySheep) {
                ZyinHUDUtil.RenderFloatingIcon(Items.field_151015_O, x, y + animal.field_70131_O, z, partialTickTime);
            } else if (animal instanceof EntityPig) {
                ZyinHUDUtil.RenderFloatingIcon(Items.field_151172_bF, x, y + animal.field_70131_O, z, partialTickTime);
            } else if (animal instanceof EntityChicken) {
                ZyinHUDUtil.RenderFloatingIcon(Items.field_151014_N, x, y + animal.field_70131_O, z, partialTickTime);
            }
        }
    }

    public static String CalculateMessageForInfoLine() {
        if (Mode == Modes.OFF) {
            return "\u00a7f";
        }
        if (Mode == Modes.ON) {
            return "\u00a7f" + Localization.get("animalinfo.infoline") + " ";
        }
        return "\u00a7f??? ";
    }

    private static int GetHorseBabyGrowingAgeAsPercent(EntityHorse horse) {
        float horseGrowingAge = horse.func_110254_bY();
        return (int)((horseGrowingAge - 0.5f) * 2.0f * 100.0f);
    }

    private static String GetTimeUntilBreedAgain(EntityAgeable horse) {
        int horseBreedingTime = horse.func_70874_b();
        if (horseBreedingTime <= 0) {
            return null;
        }
        int seconds = horseBreedingTime / 20;
        int minutes = seconds / 60;
        return minutes + ":" + twoDigitFormat.format(seconds % 60);
    }

    private static String GetHorseSpeedText(EntityHorse horse) {
        double horseSpeed = AnimalInfo.GetEntityMaxSpeed((EntityLivingBase)horse);
        String horseSpeedString = decimalFormat.format(horseSpeed);
        if (horseSpeed > perfectHorseSpeedThreshold) {
            horseSpeedString = "\u00a7b" + horseSpeedString + "\u00a7f";
        } else if (horseSpeed > goodHorseSpeedThreshold) {
            horseSpeedString = "\u00a7a" + horseSpeedString + "\u00a7f";
        } else if (horseSpeed < badHorseSpeedThreshold) {
            horseSpeedString = "\u00a7c" + horseSpeedString + "\u00a7f";
        }
        return horseSpeedString;
    }

    private static String GetHorseHPText(EntityHorse horse) {
        int horseHP = AnimalInfo.GetEntityMaxHP((EntityLivingBase)horse);
        String horseHPString = decimalFormat.format(AnimalInfo.GetEntityMaxHP((EntityLivingBase)horse));
        if (horseHP > perfectHorseHPThreshold) {
            horseHPString = "\u00a7b" + horseHPString + "\u00a7f";
        } else if (horseHP > goodHorseHPThreshold) {
            horseHPString = "\u00a7a" + horseHPString + "\u00a7f";
        } else if (horseHP < badHorseHPThreshold) {
            horseHPString = "\u00a7c" + horseHPString + "\u00a7f";
        }
        return horseHPString;
    }

    private static String GetHorseHeartsText(EntityHorse horse) {
        int horseHP = AnimalInfo.GetEntityMaxHP((EntityLivingBase)horse);
        int horseHearts = AnimalInfo.GetEntityMaxHearts((EntityLivingBase)horse);
        String horseHeartsString = "" + horseHearts;
        if (horseHP > perfectHorseHPThreshold) {
            horseHeartsString = "\u00a7b" + horseHeartsString + "\u00a7f";
        } else if (horseHP > goodHorseHPThreshold) {
            horseHeartsString = "\u00a7a" + horseHeartsString + "\u00a7f";
        } else if (horseHP < badHorseHPThreshold) {
            horseHeartsString = "\u00a7c" + horseHeartsString + "\u00a7f";
        }
        return horseHeartsString;
    }

    private static String GetHorseJumpText(EntityHorse horse) {
        double horseJump = AnimalInfo.GetHorseMaxJump(horse);
        String horseJumpString = decimalFormat.format(horseJump);
        if (horseJump > perfectHorseJumpThreshold) {
            horseJumpString = "\u00a7b" + horseJumpString + "\u00a7f";
        } else if (horseJump > goodHorseJumpThreshold) {
            horseJumpString = "\u00a7a" + horseJumpString + "\u00a7f";
        } else if (horseJump < badHorseJumpThreshold) {
            horseJumpString = "\u00a7c" + horseJumpString + "\u00a7f";
        }
        return horseJumpString;
    }

    private static String GetHorseColoringText(EntityHorse horse) {
        String texture = horse.func_110212_cp()[0];
        if (texture == null || texture.isEmpty()) {
            return "";
        }
        String[] textureArray = texture.split("/");
        texture = textureArray[textureArray.length - 1];
        texture = texture.substring(6, texture.length() - 4);
        texture = WordUtils.capitalize((String)texture);
        return texture;
    }

    private static String GetHorseMarkingText(EntityHorse horse) {
        String texture = horse.func_110212_cp()[1];
        if (texture == null || texture.isEmpty()) {
            return "";
        }
        String[] textureArray = texture.split("/");
        texture = textureArray[textureArray.length - 1];
        texture = texture.substring(15, texture.length() - 4);
        texture = WordUtils.capitalize((String)texture);
        return texture;
    }

    private static double GetHorseMaxJump(EntityHorse horse) {
        double jumpHeight = 0.0;
        for (double yVelocity = horse.func_110215_cj(); yVelocity > 0.0; yVelocity *= 0.98) {
            jumpHeight += yVelocity;
            yVelocity -= 0.08;
        }
        return jumpHeight;
    }

    private static int GetEntityMaxHP(EntityLivingBase entity) {
        return (int)entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
    }

    private static int GetEntityMaxHearts(EntityLivingBase entity) {
        return (int)Math.round(entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() / 2.0);
    }

    private static double GetEntityMaxSpeed(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 43.0;
    }

    public static boolean ToggleShowHorseStatsOnF3Menu() {
        ShowHorseStatsOnF3Menu = !ShowHorseStatsOnF3Menu;
        return ShowHorseStatsOnF3Menu;
    }

    public static boolean ToggleShowHorseStatsOverlay() {
        ShowHorseStatsOverlay = !ShowHorseStatsOverlay;
        return ShowHorseStatsOverlay;
    }

    public static boolean ToggleShowTextBackgrounds() {
        ShowTextBackgrounds = !ShowTextBackgrounds;
        return ShowTextBackgrounds;
    }

    public static boolean ToggleShowBreedingHorses() {
        ShowBreedingTimerForHorses = !ShowBreedingTimerForHorses;
        return ShowBreedingTimerForHorses;
    }

    public static boolean ToggleShowBreedingVillagers() {
        ShowBreedingTimerForVillagers = !ShowBreedingTimerForVillagers;
        return ShowBreedingTimerForVillagers;
    }

    public static boolean ToggleShowBreedingCows() {
        ShowBreedingTimerForCows = !ShowBreedingTimerForCows;
        return ShowBreedingTimerForCows;
    }

    public static boolean ToggleShowBreedingSheep() {
        ShowBreedingTimerForSheep = !ShowBreedingTimerForSheep;
        return ShowBreedingTimerForSheep;
    }

    public static boolean ToggleShowBreedingPigs() {
        ShowBreedingTimerForPigs = !ShowBreedingTimerForPigs;
        return ShowBreedingTimerForPigs;
    }

    public static boolean ToggleShowBreedingChickens() {
        ShowBreedingTimerForChickens = !ShowBreedingTimerForChickens;
        return ShowBreedingTimerForChickens;
    }

    public static boolean ToggleShowBreedingIcons() {
        ShowBreedingIcons = !ShowBreedingIcons;
        return ShowBreedingIcons;
    }

    public static boolean ToggleShowBreedingTimers() {
        ShowBreedingTimers = !ShowBreedingTimers;
        return ShowBreedingTimers;
    }

    static {
        numberOfDecimalsDisplayed = 1;
        minNumberOfDecimalsDisplayed = 0;
        maxNumberOfDecimalsDisplayed = 20;
        perfectHorseSpeedThreshold = 13.0;
        goodHorseSpeedThreshold = 11.0;
        badHorseSpeedThreshold = 9.5;
        perfectHorseJumpThreshold = 5.0;
        goodHorseJumpThreshold = 4.0;
        badHorseJumpThreshold = 2.5;
        perfectHorseHPThreshold = 28;
        goodHorseHPThreshold = 24;
        badHorseHPThreshold = 20;
        viewDistanceCutoff = 8;
        minViewDistanceCutoff = 0;
        maxViewDistanceCutoff = 120;
        decimalFormat = AnimalInfo.GetDecimalFormat();
        twoDigitFormat = new DecimalFormat("00");
    }

    public static enum Modes {
        OFF(Localization.get("safeoverlay.mode.0")),
        ON(Localization.get("safeoverlay.mode.1"));

        private String friendlyName;

        private Modes(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public static Modes ToggleMode() {
            Mode = Mode.ordinal() < Modes.values().length - 1 ? Modes.values()[Mode.ordinal() + 1] : Modes.values()[0];
            return Mode;
        }

        public static Modes GetMode(String modeName) {
            try {
                return Modes.valueOf(modeName);
            }
            catch (IllegalArgumentException e) {
                return Modes.values()[0];
            }
        }

        public String GetFriendlyName() {
            return this.friendlyName;
        }
    }
}

