/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.LogHelper;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.DungeonLootLists;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class RoomBoss
extends RoomBase {
    public static final int[] facingToOrientation = new int[]{3, 4, 2, 5};
    private int doorSide = 0;
    private final BossType type;

    public RoomBoss(BossType bossType, int chunkX, int chunkZ, Random rand, int size, Block blockRequired) {
        super(chunkX, chunkZ, Math.max(size, 9), rand.nextInt(4) + 7, blockRequired);
        this.isLocked = true;
        this.type = bossType;
    }

    public BossType getBossType() {
        return this.type;
    }

    @Override
    public boolean generate(ZSSMapGenBase mapGen, World world, Random rand, int x, int y, int z) {
        if (this.initDungeon(world, x, y, z) && this.canGenerate(world)) {
            this.doStandardRoomGen(world, rand);
            return true;
        }
        return false;
    }

    protected boolean initDungeon(World world, int x, int y, int z) {
        this.bBox.func_78886_a(x, y, z);
        if (this.type == null || y < this.bBox.func_78882_c() || y > (this.type == BossType.HELL ? 96 : 160)) {
            return false;
        }
        switch (this.type) {
            case HELL: {
                this.inNether = true;
                if (this.placeInNether(world)) {
                    this.doDefaultAdjustments(world);
                    if (!(world.field_73012_v.nextFloat() < 0.75f)) break;
                    this.submerged = true;
                    this.inLava = true;
                    break;
                }
                return false;
            }
            case OCEAN: {
                if (this.placeInOcean(world, false)) break;
                return false;
            }
            case SWAMP: {
                this.submerged = true;
                this.doDefaultAdjustments(world);
                this.bBox.func_78886_a(0, -1, 0);
                break;
            }
            default: {
                this.doDefaultAdjustments(world);
            }
        }
        if (this.submerged) {
            --this.bBox.field_78895_b;
        }
        this.determineDoorSide(world);
        this.setMetadata(world, x, z);
        boolean flag = StructureGenUtils.getAverageDistanceToGround(world, this.bBox, 6) < 4;
        return this.doorSide != -1 && flag && (this.submerged || !this.isWaterAroundOrUnder(world));
    }

    private void doDefaultAdjustments(World world) {
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151578_c, 4, false, true);
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151577_b, 4, false, true);
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151595_p, 4, false, true);
        StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151579_a, 4, false, false);
        if (this.type != BossType.SWAMP) {
            StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151586_h, 4, false, false);
        }
    }

    protected boolean isWaterAroundOrUnder(World world) {
        if (StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, Material.field_151586_h, -1) > 1) {
            return true;
        }
        if (StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.field_151586_h, this.bBox.field_78897_a - 1, this.bBox.field_78897_a, this.bBox.field_78895_b, this.bBox.field_78895_b + 2, this.bBox.field_78896_c, this.bBox.field_78892_f) > 2) {
            return true;
        }
        if (StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.field_151586_h, this.bBox.field_78893_d + 1, this.bBox.field_78893_d + 2, this.bBox.field_78895_b, this.bBox.field_78895_b + 2, this.bBox.field_78896_c, this.bBox.field_78892_f) > 2) {
            return true;
        }
        if (StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.field_151586_h, this.bBox.field_78897_a, this.bBox.field_78893_d, this.bBox.field_78895_b, this.bBox.field_78895_b + 2, this.bBox.field_78896_c - 1, this.bBox.field_78896_c) > 2) {
            return true;
        }
        return StructureGenUtils.getNumBlocksOfMaterialInArea(world, Material.field_151586_h, this.bBox.field_78897_a, this.bBox.field_78893_d, this.bBox.field_78895_b, this.bBox.field_78895_b + 2, this.bBox.field_78892_f + 1, this.bBox.field_78892_f + 2) > 2;
    }

    @Override
    protected void setMetadata(World world, int x, int z) {
        this.metadata = this.type.metadata;
    }

    @Override
    protected void decorateDungeon(World world, Random rand) {
        int meta = this.getMetadata();
        StructureGenUtils.fillDown(world, this.bBox, BlockSecretStone.getBlockFromMeta(meta), 0);
        this.placeDoor(world);
        this.placeDungeonCore(world);
        this.placePillars(world, meta);
        this.placeCenterPiece(world, rand, meta);
        this.placeChandelier(world);
        this.placeParapet(world, meta);
        this.placeLedge(world, rand, meta);
        this.placeChestOnRoof(world, rand);
        this.placeJars(world, rand, rand.nextInt(5), false);
        this.placeJars(world, rand, rand.nextInt(5) + 3, true);
        this.placeWindows(world);
    }

    @Override
    protected void placeDungeonCore(World world) {
        StructureGenUtils.setBlockAtPosition(world, this.bBox, this.bBox.func_78883_b() / 2, 0, this.bBox.func_78880_d() / 2, ZSSBlocks.dungeonCore, this.getMetadata() | 8);
        int x = StructureGenUtils.getXWithOffset(this.bBox, this.bBox.func_78883_b() / 2, this.bBox.func_78880_d() / 2);
        int y = StructureGenUtils.getYWithOffset(this.bBox, 0);
        int z = StructureGenUtils.getZWithOffset(this.bBox, this.bBox.func_78883_b() / 2, this.bBox.func_78880_d() / 2);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDungeonCore) {
            TileEntityDungeonCore core = (TileEntityDungeonCore)te;
            core.setDungeonBoundingBox(this.bBox);
            core.setBossType(this.type);
            core.setDoor(ZSSBlocks.doorLocked, this.doorSide);
        }
    }

    protected void determineDoorSide(World world) {
        int x = this.bBox.func_78881_e();
        int y = this.bBox.field_78895_b + 1;
        int z = this.bBox.func_78891_g();
        Block block1 = world.func_147439_a(x, y, this.bBox.field_78892_f + 1);
        Block block2 = world.func_147439_a(x, y + 1, this.bBox.field_78892_f + 1);
        if (!block1.func_149730_j() && !block2.func_149730_j()) {
            this.doorSide = 0;
            return;
        }
        block1 = world.func_147439_a(x, y, this.bBox.field_78896_c - 1);
        block2 = world.func_147439_a(x, y + 1, this.bBox.field_78896_c - 1);
        if (!block1.func_149730_j() && !block2.func_149730_j()) {
            this.doorSide = 2;
            return;
        }
        block1 = world.func_147439_a(this.bBox.field_78893_d + 1, y, z);
        block2 = world.func_147439_a(this.bBox.field_78893_d + 1, y + 1, z);
        if (!block1.func_149730_j() && !block2.func_149730_j()) {
            this.doorSide = 3;
            return;
        }
        block1 = world.func_147439_a(this.bBox.field_78897_a - 1, y, z);
        block2 = world.func_147439_a(this.bBox.field_78897_a - 1, y + 1, z);
        if (!block1.func_149730_j() && !block2.func_149730_j()) {
            this.doorSide = 1;
            return;
        }
        this.doorSide = -1;
    }

    protected void placeDoor(World world) {
        int x = this.bBox.func_78881_e();
        int y = this.bBox.field_78895_b + (this.submerged ? 2 : 1);
        int z = this.bBox.func_78891_g();
        switch (this.doorSide) {
            case 0: {
                z = this.bBox.field_78892_f;
                break;
            }
            case 2: {
                z = this.bBox.field_78896_c;
                break;
            }
            case 3: {
                x = this.bBox.field_78893_d;
                break;
            }
            case 1: {
                x = this.bBox.field_78897_a;
                break;
            }
            default: {
                LogHelper.log(Level.WARNING, "Placing Boss door with invalid door side");
            }
        }
        world.func_147465_d(x, y, z, ZSSBlocks.doorLocked, this.type.ordinal() & 0xFFFFFFF7, 2);
        world.func_147465_d(x, y + 1, z, ZSSBlocks.doorLocked, this.type.ordinal() | 8, 2);
    }

    protected void placeCenterPiece(World world, Random rand, int meta) {
        int minX = this.bBox.func_78883_b() / 2 - 1;
        int minY = 1;
        int minZ = this.bBox.func_78880_d() / 2 - 1;
        if (this.submerged) {
            StructureGenUtils.fillWithBlocks(world, this.bBox, minX, minX + 3, minY, minY + 1, minZ, minZ + 3, BlockSecretStone.getBlockFromMeta(this.getMetadata()), 0);
            ++minY;
        }
        if (!this.inOcean) {
            StructureGenUtils.fillWithBlocks(world, this.bBox, minX, minX + 3, minY, minY + 1, minZ, minZ + 3, (Block)Blocks.field_150333_U, BlockSecretStone.getSlabTypeFromMeta(meta));
        }
        world.func_147465_d(this.bBox.func_78881_e(), this.bBox.field_78895_b + (this.submerged && !this.inOcean ? 2 : 1), this.bBox.func_78891_g(), this.type == BossType.TAIGA ? Blocks.field_150371_ca : BlockSecretStone.getBlockFromMeta(this.getMetadata()), 0, 2);
        this.placeHinderBlock(world);
        boolean hasChest = false;
        switch (this.type) {
            case OCEAN: 
            case DESERT: 
            case MOUNTAIN: {
                this.placeChest(world, rand, true);
                hasChest = true;
                break;
            }
            case FOREST: {
                this.placePedestal(world, minY + 1);
                break;
            }
            case HELL: {
                this.placeFlame(world, 1);
                break;
            }
            case SWAMP: {
                this.placeFlame(world, 2);
                break;
            }
            case TAIGA: {
                this.placeFlame(world, 4);
                break;
            }
        }
        if (!hasChest) {
            this.placeChest(world, rand, false);
        }
    }

    protected void placeChandelier(World world) {
        if (this.bBox.func_78882_c() > 7) {
            int x = this.bBox.func_78881_e();
            int y = this.bBox.field_78894_e - 1;
            int z = this.bBox.func_78891_g();
            if (this.type == BossType.OCEAN) {
                world.func_147465_d(x + 1, y, z + 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x + 1, y, z - 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x - 1, y, z + 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x - 1, y, z - 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x, y, z, Blocks.field_150426_aN, 0, 2);
            } else {
                world.func_147465_d(x, y, z, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x + 1, y, z, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x + 1, y, z, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x, y, z + 1, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x, y, z - 1, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x + 1, y, z + 1, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x + 1, y, z - 1, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x - 1, y, z + 1, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x - 1, y, z - 1, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x, y - 1, z, Blocks.field_150422_aJ, 0, 2);
                world.func_147465_d(x + 1, y - 1, z + 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x + 1, y - 1, z - 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x - 1, y - 1, z + 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x - 1, y - 1, z - 1, Blocks.field_150426_aN, 0, 2);
                world.func_147465_d(x, y - 2, z, Blocks.field_150426_aN, 0, 2);
            }
        }
    }

    protected void placeChest(World world, Random rand, boolean inCenter) {
        int x = inCenter ? this.bBox.func_78881_e() : (rand.nextFloat() < 0.5f ? this.bBox.field_78897_a + 1 : this.bBox.field_78893_d - 1);
        int y = this.bBox.field_78895_b + (inCenter ? 2 : 1) + (this.submerged && !this.inOcean ? 1 : 0);
        int z = inCenter ? this.bBox.func_78891_g() : (rand.nextFloat() < 0.5f ? this.bBox.field_78896_c + 1 : this.bBox.field_78892_f - 1);
        BlockChest block = inCenter ? Blocks.field_150486_ae : ZSSBlocks.chestLocked;
        world.func_147449_b(x, y, z, (Block)block);
        if (inCenter) {
            world.func_72921_c(x, y, z, facingToOrientation[this.doorSide], 2);
        } else if (this.submerged && !this.inOcean) {
            world.func_147465_d(x, y - 1, z, BlockSecretStone.getBlockFromMeta(this.getMetadata()), 0, 2);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            DungeonLootLists.generateBossChestContents(world, rand, (IInventory)te, this);
        }
    }

    protected void placeChestOnRoof(World world, Random rand) {
        if (rand.nextFloat() < 0.1f) {
            int x = rand.nextFloat() < 0.5f ? this.bBox.field_78897_a : this.bBox.field_78893_d;
            int y = this.bBox.field_78894_e + 1;
            int z = rand.nextFloat() < 0.5f ? this.bBox.field_78896_c : this.bBox.field_78892_f;
            world.func_147449_b(x, y, z, (Block)Blocks.field_150486_ae);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IInventory) {
                DungeonLootLists.generateChestContents(world, rand, (IInventory)te, this, true);
            }
        }
    }

    protected void placeFlame(World world, int meta) {
        world.func_147465_d(this.bBox.func_78881_e(), this.bBox.field_78895_b + (this.submerged ? 3 : 2), this.bBox.func_78891_g(), ZSSBlocks.sacredFlame, meta, 2);
    }

    protected void placeHinderBlock(World world) {
        int x = this.bBox.func_78881_e() + (this.doorSide == 3 ? 1 : (this.doorSide == 1 ? -1 : 0));
        int y = this.bBox.field_78895_b + (this.submerged && !this.inOcean ? 3 : 2);
        int z = this.bBox.func_78891_g() + (this.doorSide == 0 ? 1 : (this.doorSide == 2 ? -1 : 0));
        world.func_147465_d(x, y, z, ZSSBlocks.secretStone, this.getMetadata(), 2);
    }

    protected void placeJars(World world, Random rand, int n, boolean onRoof) {
        for (int i = 0; i < n; ++i) {
            int z;
            int y;
            int x = this.bBox.field_78897_a + rand.nextInt(this.bBox.func_78883_b());
            Material m = world.func_147439_a(x, y = (onRoof ? this.bBox.field_78894_e : this.bBox.field_78895_b) + 1, z = this.bBox.field_78896_c + rand.nextInt(this.bBox.func_78880_d())).func_149688_o();
            if (m != Material.field_151579_a && !m.func_76224_d()) continue;
            world.func_147449_b(x, y, z, ZSSBlocks.ceramicJar);
        }
    }

    protected void placeLedge(World world, Random rand, int meta) {
        if (this.type != BossType.OCEAN && this.bBox.func_78882_c() > 7) {
            float f = rand.nextFloat();
            float f2 = this.type == BossType.HELL ? 0.75f : 0.5f;
            if (f < f2) {
                int y = this.bBox.func_78879_f();
                Block block = BlockSecretStone.getBlockFromMeta(meta);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.field_78897_a + 1, this.bBox.field_78897_a + 2, y, y + 1, this.bBox.field_78896_c + 1, this.bBox.field_78892_f, block, 0, 3);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.field_78893_d - 1, this.bBox.field_78893_d, y, y + 1, this.bBox.field_78896_c + 1, this.bBox.field_78892_f, block, 0, 3);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.field_78897_a + 2, this.bBox.field_78893_d - 1, y, y + 1, this.bBox.field_78896_c + 1, this.bBox.field_78896_c + 2, block, 0, 3);
                StructureGenUtils.fillWithoutReplace(world, this.bBox.field_78897_a + 2, this.bBox.field_78893_d - 1, y, y + 1, this.bBox.field_78892_f - 1, this.bBox.field_78892_f, block, 0, 3);
            }
        }
    }

    protected void placeParapet(World world, int meta) {
        int i;
        int x1 = this.bBox.field_78897_a - 1;
        int x2 = this.bBox.field_78893_d + 1;
        int z1 = this.bBox.field_78896_c - 1;
        int z2 = this.bBox.field_78892_f + 1;
        int y = this.bBox.field_78894_e;
        Block block = BlockSecretStone.getBlockFromMeta(meta);
        Block stairs = BlockSecretStone.getStairsFromMeta(meta);
        for (i = x1; i <= x2; ++i) {
            world.func_147465_d(i, y, z1, stairs, 6, 3);
            world.func_147465_d(i, y + 1, z1, block, 0, 2);
            world.func_147465_d(i, y, z2, stairs, 7, 3);
            world.func_147465_d(i, y + 1, z2, block, 0, 2);
            if (i % 2 != 0) continue;
            world.func_147465_d(i, y + 2, z1, block, 0, 2);
            world.func_147465_d(i, y + 2, z2, block, 0, 2);
        }
        for (i = z1; i <= z2; ++i) {
            world.func_147465_d(x1, y, i, stairs, 4, 3);
            world.func_147465_d(x1, y + 1, i, block, 0, 2);
            world.func_147465_d(x2, y, i, stairs, 5, 3);
            world.func_147465_d(x2, y + 1, i, block, 0, 2);
            if (i % 2 != 0) continue;
            if (world.func_147439_a(x1 + 1, y + 2, i) != block) {
                world.func_147465_d(x1, y + 2, i, block, 0, 2);
            }
            if (world.func_147439_a(x2 - 1, y + 2, i) == block) continue;
            world.func_147465_d(x2, y + 2, i, block, 0, 2);
        }
    }

    protected void placePillars(World world, int meta) {
        if (this.type != BossType.DESERT && world.field_73012_v.nextFloat() < (float)this.bBox.func_78883_b() * 0.06f) {
            int offset = this.bBox.func_78883_b() < 11 ? 2 : 3;
            int x1 = (this.bBox.func_78883_b() < 11 ? this.bBox.func_78881_e() : this.bBox.field_78897_a) + offset;
            int x2 = (this.bBox.func_78883_b() < 11 ? this.bBox.func_78881_e() : this.bBox.field_78893_d) - offset;
            int z1 = (this.bBox.func_78880_d() < 11 ? this.bBox.func_78891_g() : this.bBox.field_78896_c) + offset;
            int z2 = (this.bBox.func_78880_d() < 11 ? this.bBox.func_78891_g() : this.bBox.field_78892_f) - offset;
            Block block = BlockSecretStone.getBlockFromMeta(meta);
            for (int y = this.bBox.field_78895_b + 1; y < this.bBox.field_78894_e; ++y) {
                world.func_147465_d(x1, y, z1, block, 0, 2);
                world.func_147465_d(x1, y, z2, block, 0, 2);
                world.func_147465_d(x2, y, z1, block, 0, 2);
                world.func_147465_d(x2, y, z2, block, 0, 2);
            }
            if (this.bBox.func_78883_b() > 10 && world.field_73012_v.nextFloat() < 0.5f) {
                this.placePillarLandings(world, block, x1, this.bBox.func_78879_f(), z1, 0);
                this.placePillarLandings(world, block, x2, this.bBox.func_78879_f(), z1, 1);
                this.placePillarLandings(world, block, x1, this.bBox.func_78879_f(), z2, 2);
                this.placePillarLandings(world, block, x2, this.bBox.func_78879_f(), z2, 3);
            }
        }
    }

    protected void placePillarLandings(World world, Block block, int x, int y, int z, int corner) {
        switch (corner % 4) {
            case 0: {
                world.func_147449_b(x + 1, y, z, block);
                world.func_147449_b(x, y, z + 1, block);
                break;
            }
            case 1: {
                world.func_147449_b(x - 1, y, z, block);
                world.func_147449_b(x, y, z + 1, block);
                break;
            }
            case 2: {
                world.func_147449_b(x + 1, y, z, block);
                world.func_147449_b(x, y, z - 1, block);
                break;
            }
            case 3: {
                world.func_147449_b(x - 1, y, z, block);
                world.func_147449_b(x, y, z - 1, block);
            }
        }
    }

    protected void placeWindows(World world) {
        if (Config.areWindowsEnabled() && world.field_73012_v.nextFloat() < (float)this.bBox.func_78883_b() * 0.06f) {
            int interval = this.bBox.func_78883_b() % 2 == 1 ? 2 : 3;
            int j = this.bBox.func_78879_f() + 1;
            for (int i = this.bBox.field_78897_a + 1; i < this.bBox.field_78893_d; ++i) {
                if (i % interval != 0) continue;
                world.func_147468_f(i, j, this.bBox.field_78896_c);
                world.func_147468_f(i, j, this.bBox.field_78892_f);
            }
            for (int k = this.bBox.field_78896_c + 1; k < this.bBox.field_78892_f; ++k) {
                if (k % interval != 0) continue;
                world.func_147468_f(this.bBox.field_78897_a, j, k);
                world.func_147468_f(this.bBox.field_78893_d, j, k);
            }
        }
    }

    @Override
    protected boolean canReplaceBlockAt(int y, Block block) {
        boolean flag1 = block != null && !block.func_149688_o().func_76230_c();
        boolean flag2 = block != null && block.func_149688_o() == Material.field_151584_j;
        boolean flag3 = this.type == BossType.TAIGA && (block == Blocks.field_150364_r || block == Blocks.field_150363_s || block != null && block.func_149688_o() == Material.field_151588_w);
        return block == null || flag1 || flag2 || flag3 || super.canReplaceBlockAt(y, block);
    }

    @Override
    protected boolean placeInOcean(World world, boolean sink) {
        if (this.type == BossType.OCEAN) {
            while (this.bBox.field_78895_b > 60 && world.func_147439_a(this.bBox.func_78881_e(), this.bBox.field_78895_b, this.bBox.func_78891_g()).func_149688_o() == Material.field_151579_a) {
                this.bBox.func_78886_a(0, -1, 0);
            }
            while (this.bBox.field_78895_b > 16 && world.func_147439_a(this.bBox.func_78881_e(), this.bBox.field_78895_b, this.bBox.func_78891_g()).func_149688_o() == Material.field_151586_h) {
                this.bBox.func_78886_a(0, -1, 0);
            }
            if (world.func_147439_a(this.bBox.func_78881_e(), this.bBox.field_78895_b, this.bBox.func_78891_g()).func_149688_o() != Material.field_151586_h && world.func_147439_a(this.bBox.func_78881_e(), this.bBox.field_78894_e, this.bBox.func_78891_g()).func_149688_o() == Material.field_151586_h) {
                this.inOcean = true;
                this.submerged = true;
                StructureGenUtils.adjustCornersForMaterial(world, this.bBox, Material.field_151586_h, 6, false, false);
                return true;
            }
        }
        return false;
    }
}

