/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import java.util.logging.Level;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.LogHelper;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.RoomSecret;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class MapGenSecretRoom
extends ZSSMapGenBase {
    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        NBTTagList roomList = this.getStructureListFor(chunkX, chunkZ);
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        int posY = StructureGenUtils.getAverageSurfaceHeight(world, posX, posZ);
        if (posY < 1) {
            return;
        }
        for (int i = 0; i < Config.getAttemptsPerChunk(); ++i) {
            if (!(rand.nextFloat() < Config.getSecretRoomChance())) continue;
            int x = posX + rand.nextInt(16);
            int y = rand.nextInt(posY) + (i % 2 == 0 ? rand.nextInt(16) : rand.nextInt(8));
            int z = posZ + rand.nextInt(16);
            RoomSecret room = new RoomSecret(chunkX, chunkZ, Math.min(rand.nextInt(6) + 3, 6), Blocks.field_150348_b);
            if (!room.generate(this, world, rand, x, y, z)) continue;
            roomList.func_74742_a((NBTBase)room.writeToNBT());
            this.updateChunkStructureMap(roomList, chunkX, chunkZ);
        }
        if (roomList.func_74745_c() > 0) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("roomList", (NBTBase)roomList);
            this.addRoomTag(compound, chunkX, chunkZ);
        }
    }

    @Override
    public String getTagName() {
        return "zssSecretRooms";
    }

    @Override
    protected StructureBoundingBox getStructureBBAt(int x, int y, int z) {
        NBTTagList roomList = this.getStructureListFor(x >> 4, z >> 4);
        for (int i = 0; i < roomList.func_74745_c(); ++i) {
            StructureBoundingBox box;
            NBTTagCompound compound = roomList.func_150305_b(i);
            if (!compound.func_74764_b("BB") || !(box = new StructureBoundingBox(compound.func_74759_k("BB"))).func_78890_b(x, y, z)) continue;
            return box;
        }
        return null;
    }

    @Override
    protected void translateNbtIntoMap(NBTTagCompound compound) {
        if (compound.func_74764_b("chunkX") && compound.func_74764_b("chunkZ") && compound.func_74764_b("roomList")) {
            int i = compound.func_74762_e("chunkX");
            int j = compound.func_74762_e("chunkZ");
            NBTTagList roomList = compound.func_150295_c("roomList", (int)compound.func_74732_a());
            this.structureMap.put(ChunkCoordIntPair.func_77272_a((int)i, (int)j), roomList);
        } else {
            LogHelper.log(Level.WARNING, "Failed to translate NBT compound into structure map");
        }
    }

    protected NBTTagList getStructureListFor(int chunkX, int chunkZ) {
        this.loadOrCreateData(this.worldObj);
        if (this.structureMap.containsKey(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ))) {
            return (NBTTagList)this.structureMap.get(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ));
        }
        return new NBTTagList();
    }

    protected void updateChunkStructureMap(NBTTagList roomList, int chunkX, int chunkZ) {
        this.structureMap.put(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ), roomList);
    }

    @Override
    public boolean areStructuresWithinRange(RoomBase room, int range) {
        StructureBoundingBox box = room.getBoundingBox();
        if (this.isNearStructureInChunk(room, box, room.chunkX, room.chunkZ, range)) {
            return true;
        }
        for (int i = 0; i <= (range + 8) / 16; ++i) {
            if (this.isNearStructureInChunk(room, box, room.chunkX + i + 1, room.chunkZ, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX - i - 1, room.chunkZ, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX, room.chunkZ + i + 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX, room.chunkZ - i - 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX + i + 1, room.chunkZ + i + 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX + i + 1, room.chunkZ - i - 1, range)) {
                return true;
            }
            if (this.isNearStructureInChunk(room, box, room.chunkX - i - 1, room.chunkZ + i + 1, range)) {
                return true;
            }
            if (!this.isNearStructureInChunk(room, box, room.chunkX - i - 1, room.chunkZ - i - 1, range)) continue;
            return true;
        }
        return false;
    }

    protected boolean isNearStructureInChunk(RoomBase room, StructureBoundingBox box1, int chunkX, int chunkZ, int range) {
        NBTTagList roomList = this.getStructureListFor(chunkX, chunkZ);
        for (int i = 0; i < roomList.func_74745_c(); ++i) {
            NBTTagCompound compound = roomList.func_150305_b(i);
            if (compound.func_74764_b("BB")) {
                StructureBoundingBox box2 = new StructureBoundingBox(compound.func_74759_k("BB"));
                double dx = (box1.func_78883_b() + box2.func_78883_b()) / 2;
                if (!(StructureGenUtils.getDistanceSqBetween(box1, box2) < ((double)range + dx) * ((double)range + dx)) || room.inOcean && box1.field_78895_b > box2.field_78894_e + range / 4 + 2) continue;
                return true;
            }
            LogHelper.log(Level.WARNING, "Invalid tag while checking for structures in chunk " + chunkX + "/" + chunkZ);
        }
        return false;
    }
}

