/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import java.util.logging.Level;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.LogHelper;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.RoomBoss;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class MapGenBossRoom
extends ZSSMapGenBase {
    @Override
    public void generate(IChunkProvider provider, World world, Random rand, int chunkX, int chunkZ) {
        this.worldObj = world;
        this.loadOrCreateData(this.worldObj);
        int posX = (chunkX << 4) + rand.nextInt(16);
        int posZ = (chunkZ << 4) + rand.nextInt(16);
        BossType type = BossType.getBossType(world, posX, posZ);
        if (type != null) {
            int posY;
            RoomBoss room = new RoomBoss(type, chunkX, chunkZ, rand, rand.nextInt(5) + 9, Blocks.field_150348_b);
            if (rand.nextFloat() < 0.2f && !this.areStructuresWithinRange(room, Config.getMinBossDistance()) && room.generate(this, world, rand, posX, posY = StructureGenUtils.getAverageSurfaceHeight(world, posX, posZ), posZ)) {
                this.onStructureGenerated(type, chunkX, chunkZ);
            }
        }
    }

    @Override
    public String getTagName() {
        return "zssBossRooms";
    }

    @Override
    protected StructureBoundingBox getStructureBBAt(int x, int y, int z) {
        return null;
    }

    public boolean shouldDenyLakeAt(int chunkX, int chunkZ) {
        return this.isRoomInChunk(chunkX, chunkZ) || this.isRoomInChunk(chunkX + 1, chunkZ + 1) || this.isRoomInChunk(chunkX + 1, chunkZ - 1) || this.isRoomInChunk(chunkX - 1, chunkZ + 1) || this.isRoomInChunk(chunkX - 1, chunkZ - 1) || this.isRoomInChunk(chunkX, chunkZ + 1) || this.isRoomInChunk(chunkX, chunkZ - 1) || this.isRoomInChunk(chunkX + 1, chunkZ) || this.isRoomInChunk(chunkX - 1, chunkZ);
    }

    protected boolean isRoomInChunk(int chunkX, int chunkZ) {
        return this.structureMap.containsKey(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ));
    }

    @Override
    public boolean areStructuresWithinRange(RoomBase room, int range) {
        this.loadOrCreateData(this.worldObj);
        for (int i = room.chunkX - range; i <= room.chunkX + range; ++i) {
            for (int j = room.chunkZ - range; j <= room.chunkZ + range; ++j) {
                if (!this.structureMap.containsKey(ChunkCoordIntPair.func_77272_a((int)i, (int)j))) continue;
                BossType type = ((RoomBoss)room).getBossType();
                if (type != null && type.ordinal() == this.getBossTypeFor(i, j)) {
                    return true;
                }
                if ((room.chunkX - i) * (room.chunkX - i) + (room.chunkZ - j) * (room.chunkZ - j) >= range * range / 2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void translateNbtIntoMap(NBTTagCompound compound) {
        if (compound.func_74764_b("chunkX") && compound.func_74764_b("chunkZ") && compound.func_74764_b("bossType")) {
            int i = compound.func_74762_e("chunkX");
            int j = compound.func_74762_e("chunkZ");
            int bossType = compound.func_74762_e("bossType");
            this.structureMap.put(ChunkCoordIntPair.func_77272_a((int)i, (int)j), bossType);
        } else {
            LogHelper.log(Level.WARNING, "Failed to translate Boss Room NBT compound into structure map");
        }
    }

    protected int getBossTypeFor(int chunkX, int chunkZ) {
        if (this.structureMap.containsKey(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ))) {
            return (Integer)this.structureMap.get(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ));
        }
        return -1;
    }

    protected void onStructureGenerated(BossType type, int chunkX, int chunkZ) {
        this.structureMap.put(ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ), type.ordinal());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("bossType", type.ordinal());
        this.addRoomTag(compound, chunkX, chunkZ);
    }
}

