/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.feature;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.WorldUtils;

public class FairySpawner {
    protected final TileEntityDungeonCore core;
    protected final StructureBoundingBox box;
    protected int maxFairies = 0;
    protected int fairiesSpawned = 0;
    protected long nextResetDate = 0L;
    protected int itemUpdate = -1;
    protected String playerName = "";
    protected int rupees = 0;

    public FairySpawner(TileEntityDungeonCore core) {
        this.core = core;
        this.box = core.getDungeonBoundingBox();
        if (this.box == null) {
            throw new IllegalArgumentException("Dungeon Core bounding box can not be null!");
        }
    }

    public FairySpawner setMaxFairies(int maxFairies) {
        this.maxFairies = maxFairies;
        return this;
    }

    public boolean consumeRupees(int amount) {
        if (amount > this.rupees) {
            return false;
        }
        this.rupees -= amount;
        return true;
    }

    public void scheduleItemUpdate(EntityPlayer player) {
        if (this.itemUpdate < 0) {
            this.itemUpdate = 2;
        }
        if (this.playerName.equals("")) {
            this.playerName = player.func_70005_c_();
        }
    }

    public void onBlockBroken() {
        this.onBlockBroken(this.core.func_145831_w(), this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e);
    }

    private void onBlockBroken(World world, int x, int y, int z) {
        while (this.rupees > 0) {
            int k = this.rupees > 64 ? 64 : this.rupees;
            this.rupees -= k;
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 1.0f, 1.0f);
            WorldUtils.spawnItemWithRandom(world, new ItemStack(Items.field_151166_bC, k), x, y, z);
        }
    }

    public void onUpdate() {
        this.updateSpawner(this.core.func_145831_w(), this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e);
        this.updateItems(this.core.func_145831_w(), this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e);
    }

    private void updateSpawner(World world, int x, int y, int z) {
        if (this.fairiesSpawned < this.maxFairies) {
            int nearby;
            float f = world.field_73012_v.nextFloat();
            float f2 = world.func_72935_r() ? 0.01f : 0.2f;
            if (f < f2 && (nearby = world.func_72872_a(EntityFairy.class, AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)this.box.func_78879_f(), (double)z, (double)(x + 1), (double)(this.box.func_78879_f() + 1), (double)(z + 1)).func_72314_b((double)(this.box.func_78883_b() / 2), (double)(this.box.func_78882_c() / 2), (double)(this.box.func_78880_d() / 2))).size()) < 4) {
                EntityFairy fairy = new EntityFairy(world);
                fairy.setFairyHome(x, y + 2, z);
                world.func_72838_d((Entity)fairy);
                if (++this.fairiesSpawned == this.maxFairies) {
                    this.nextResetDate = world.func_72820_D() + (long)(24000 * (world.field_73012_v.nextInt(Config.getDaysToRespawn()) + 1));
                }
            }
        }
        if (this.fairiesSpawned == this.maxFairies && !world.func_72935_r() && world.func_72820_D() > this.nextResetDate) {
            this.fairiesSpawned = 0;
        }
    }

    private void updateItems(World world, int x, int y, int z) {
        if (this.itemUpdate > 0) {
            --this.itemUpdate;
        } else if (this.itemUpdate == 0) {
            EntityPlayer player = world.func_72924_a(this.playerName);
            if (player != null) {
                List list = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)this.box.func_78879_f(), (double)z, (double)(x + 1), (double)(this.box.func_78879_f() + 1), (double)(z + 1)).func_72314_b((double)(this.box.func_78883_b() / 2), (double)(this.box.func_78882_c() / 2), (double)(this.box.func_78880_d() / 2)));
                for (EntityItem item : list) {
                    ItemStack stack = item.func_92059_d();
                    if (stack.func_77973_b() == Items.field_151166_bC) {
                        player.func_71029_a((StatBase)ZSSAchievements.fairyEmerald);
                        world.func_72908_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5, "random.orb", 1.0f, 1.0f);
                        this.rupees += stack.field_77994_a;
                        item.func_70106_y();
                        continue;
                    }
                    if (!(stack.func_77973_b() instanceof IFairyUpgrade) || !((IFairyUpgrade)stack.func_77973_b()).hasFairyUpgrade(stack)) continue;
                    ((IFairyUpgrade)stack.func_77973_b()).handleFairyUpgrade(item, player, this.core);
                }
            }
            this.itemUpdate = -1;
            this.playerName = "";
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("maxFairies", this.maxFairies);
        data.func_74768_a("spawned", this.fairiesSpawned);
        data.func_74772_a("nextResetDate", this.nextResetDate);
        data.func_74768_a("itemUpdate", this.itemUpdate);
        data.func_74768_a("rupees", this.rupees);
        data.func_74778_a("playerName", this.playerName);
        compound.func_74782_a("FairySpawner", (NBTBase)data);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound data = compound.func_74775_l("FairySpawner");
        this.maxFairies = data.func_74762_e("maxFairies");
        this.fairiesSpawned = data.func_74762_e("spawned");
        this.nextResetDate = data.func_74781_a("nextResetDate").func_74732_a() == 4 ? data.func_74763_f("nextResetDate") : 0L;
        this.itemUpdate = data.func_74762_e("itemUpdate");
        this.rupees = data.func_74762_e("rupees");
        this.playerName = data.func_74779_i("playerName");
    }
}

