/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import zeldaswordskills.lib.Config;
import zeldaswordskills.world.gen.feature.WorldGenJars;
import zeldaswordskills.world.gen.structure.MapGenBossRoom;
import zeldaswordskills.world.gen.structure.MapGenBossRoomNether;
import zeldaswordskills.world.gen.structure.MapGenSecretRoom;
import zeldaswordskills.world.gen.structure.MapGenSecretRoomNether;

public class ZSSWorldGenEvent {
    private MapGenSecretRoom secretRoomGen = new MapGenSecretRoom();
    private MapGenSecretRoomNether netherRoomGen = new MapGenSecretRoomNether();
    private MapGenBossRoom bossRoomGen = new MapGenBossRoom();
    private MapGenBossRoomNether netherBossGen = new MapGenBossRoomNether();

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Populate event) {
        switch (event.world.field_73011_w.field_76574_g) {
            case -1: {
                if (event.type != PopulateChunkEvent.Populate.EventType.GLOWSTONE) break;
                this.netherBossGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                break;
            }
            case 0: {
                if (event.type == PopulateChunkEvent.Populate.EventType.ICE) {
                    this.bossRoomGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                    break;
                }
                if (event.type != PopulateChunkEvent.Populate.EventType.LAKE || !this.bossRoomGen.shouldDenyLakeAt(event.chunkX, event.chunkZ)) break;
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }

    @SubscribeEvent
    public void postPopulate(PopulateChunkEvent.Post event) {
        switch (event.world.field_73011_w.field_76574_g) {
            case -1: {
                if (Config.getNetherAttemptsPerChunk() <= 0) break;
                this.netherRoomGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                break;
            }
            case 0: {
                if (Config.getAttemptsPerChunk() <= 0) break;
                this.secretRoomGen.generate(event.chunkProvider, event.world, event.rand, event.chunkX, event.chunkZ);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        block6: {
            try {
                if (event.world.field_73011_w.field_76575_d) {
                    for (int n = 0; n < Config.getJarClustersPerChunkNether(); ++n) {
                        if (!(event.rand.nextFloat() < Config.getJarGenChanceNether())) continue;
                        new WorldGenJars().doJarGen(event.world, event.rand, event.chunkX, event.chunkZ, Config.getJarsPerClusterNether(), true);
                    }
                } else if (event.rand.nextFloat() < Config.getJarGenChance() && event.rand.nextInt(4) == 0) {
                    new WorldGenJars().doJarGen(event.world, event.rand, event.chunkX, event.chunkZ, Config.getJarsPerCluster(), false);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (e.getMessage() != null && e.getMessage().equals("Already decorating!!") || cause != null && cause.getMessage() != null && cause.getMessage().equals("Already decorating!!")) break block6;
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Post event) {
        block4: {
            try {
                if (event.world.field_73011_w.func_76569_d()) {
                    for (int n = 0; n < Config.getJarClustersPerChunkSub(); ++n) {
                        if (!(event.rand.nextFloat() < Config.getJarGenChanceSub())) continue;
                        int i = event.chunkX + event.rand.nextInt(16) + 8;
                        int j = event.rand.nextInt(48) + event.rand.nextInt(48);
                        int k = event.chunkZ + event.rand.nextInt(16) + 8;
                        if (j >= 60) continue;
                        new WorldGenJars().generate2(event.world, event.rand, i, j, k, Config.getJarsPerClusterSub(), true);
                    }
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (e.getMessage() != null && e.getMessage().equals("Already decorating!!") || cause != null && cause.getMessage() != null && cause.getMessage().equals("Already decorating!!")) break block4;
                e.printStackTrace();
            }
        }
    }
}

