/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.item.HookshotType;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ItemKeyBig;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.lib.LibPotionID;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.RoomBoss;

public class DungeonLootLists {
    public static String BASIC_LOOT = "zss.basic_chest_loot";
    public static String BOSS_LOOT = "zss.boss_chest_loot";
    public static String JAR_DROPS = "zss.jar_drops";
    public static String LOCKED_LOOT = "zss.locked_chest_loot";
    public static String NETHER_LOOT = "zss.nether_chest_loot";
    private static final List<WeightedRandomChestContent> skillOrbLootList = new ArrayList<WeightedRandomChestContent>();
    private static final WeightedRandomChestContent[] lavaLoot = new WeightedRandomChestContent[]{DungeonLootLists.getLoot(Items.field_151075_bm, 1, 2, 1), DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.FIRERESIST.id, 1, 1, 2), DungeonLootLists.getLoot(Items.field_151059_bz, 1, 2, 3), DungeonLootLists.getLoot(ZSSItems.arrowBombFire, 2, 5, 3), DungeonLootLists.getLoot(ZSSItems.bomb, BombType.BOMB_FIRE.ordinal(), 1, 2, Config.getBombWeight() * 2), DungeonLootLists.getLoot(ZSSItems.tunicGoronHelm, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicGoronChest, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicGoronLegs, 1, 1, 1)};
    private static final WeightedRandomChestContent[] mountainLoot = new WeightedRandomChestContent[]{DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.STRENGTH_II.id, 1, 1, 1), DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.STRENGTH.id, 1, 1, 3), DungeonLootLists.getLoot(Items.field_151045_i, 1, 3, 3), DungeonLootLists.getLoot(ZSSItems.arrowBomb, 2, 5, 3), DungeonLootLists.getLoot(ZSSItems.bomb, BombType.BOMB_STANDARD.ordinal(), 1, 2, Config.getBombWeight() * 2), DungeonLootLists.getLoot(ZSSItems.rocsFeather, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.swordBroken, Item.func_150891_b((Item)ZSSItems.swordOrdon), 1, 1, 1)};
    private static final WeightedRandomChestContent[] oceanLoot = new WeightedRandomChestContent[]{DungeonLootLists.getLoot((Item)Items.field_151112_aM, 1, 1, 2), DungeonLootLists.getLoot(Items.field_151115_aP, 1, 2, 4), DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.WATER_BREATHING.id, 1, 1, 3), DungeonLootLists.getLoot(ZSSItems.arrowBombWater, 2, 5, 3), DungeonLootLists.getLoot(ZSSItems.bomb, BombType.BOMB_WATER.ordinal(), 1, 2, Config.getBombWeight() * 2), DungeonLootLists.getLoot(ZSSItems.tunicZoraHelm, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicZoraChest, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicZoraLegs, 1, 1, 1)};
    private static final WeightedRandomChestContent[] regularLoot = new WeightedRandomChestContent[]{DungeonLootLists.getLoot(Items.field_151125_bZ, 1, 1, 1), DungeonLootLists.getLoot(Items.field_151136_bY, 1, 1, 1), DungeonLootLists.getLoot(Items.field_151138_bX, 1, 1, 2), DungeonLootLists.getLoot(Items.field_151141_av, 1, 1, 3), DungeonLootLists.getLoot(ZSSItems.arrowBomb, 2, 5, 3), DungeonLootLists.getLoot(ZSSItems.bomb, BombType.BOMB_STANDARD.ordinal(), 1, 2, Config.getBombWeight() * 2), DungeonLootLists.getLoot(ZSSItems.swordBroken, Item.func_150891_b((Item)ZSSItems.swordOrdon), 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.swordKokiri, 1, 1, 1)};

    public static void setCategoryStats(ChestGenHooks category, int min, int max, WeightedRandomChestContent[] contents) {
        category.setMin(min);
        category.setMax(max);
        for (WeightedRandomChestContent item : contents) {
            category.addItem(item);
        }
    }

    public static WeightedRandomChestContent getLoot(Item item, int min, int max, int weight) {
        return new WeightedRandomChestContent(new ItemStack(item), min, max, weight);
    }

    public static WeightedRandomChestContent getLoot(Item item, int damage, int min, int max, int weight) {
        return new WeightedRandomChestContent(new ItemStack(item, 1, damage), min, max, weight);
    }

    public static void initLootLists() {
        DungeonLootLists.initBasicConsumables();
        DungeonLootLists.initBossLoot();
        DungeonLootLists.initJarDrops();
        DungeonLootLists.initLockedLoot();
        DungeonLootLists.initNetherLoot();
        DungeonLootLists.initSkillOrbLoot();
    }

    public static WeightedRandomChestContent[] getSkillOrbList() {
        ArrayList<WeightedRandomChestContent> lootTable = new ArrayList<WeightedRandomChestContent>(skillOrbLootList);
        return lootTable.toArray(new WeightedRandomChestContent[lootTable.size()]);
    }

    public static void generateChestContents(World world, Random rand, IInventory chest, RoomBase room, boolean isLockedChest) {
        ChestGenHooks info = ChestGenHooks.getInfo((String)BASIC_LOOT);
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chest, (int)info.getCount(rand));
        int n = rand.nextInt(3);
        if (n > 0 && (isLockedChest || rand.nextInt(4) == 0)) {
            if (room.inLava) {
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])lavaLoot, (IInventory)chest, (int)n);
            } else if (room.inOcean) {
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])oceanLoot, (IInventory)chest, (int)n);
            } else if (room.inMountain) {
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])mountainLoot, (IInventory)chest, (int)n);
            } else {
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])regularLoot, (IInventory)chest, (int)n);
            }
        }
        if (room.inNether) {
            info = ChestGenHooks.getInfo((String)NETHER_LOOT);
            WorldUtils.generateRandomChestContents(rand, info.getItems(rand), chest, info.getCount(rand), true);
        }
        if (isLockedChest) {
            info = ChestGenHooks.getInfo((String)LOCKED_LOOT);
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chest, (int)info.getCount(rand));
            if (!(room instanceof RoomBoss)) {
                ItemStack key;
                if (rand.nextFloat() < Config.getRandomBossItemChance()) {
                    WorldUtils.addItemToInventoryAtRandom(rand, ChestGenHooks.getInfo((String)BOSS_LOOT).getOneItem(rand), chest, 3);
                }
                if (rand.nextInt(20) < Config.getBigKeyWeight() && (key = ItemKeyBig.getKeyForBiome(world, room.getBoundingBox().func_78881_e(), room.getBoundingBox().func_78891_g())) != null) {
                    WorldUtils.addItemToInventoryAtRandom(rand, key, chest, 3);
                }
            }
        }
    }

    public static void generateBossChestContents(World world, Random rand, IInventory chest, RoomBoss room) {
        DungeonLootLists.generateChestContents(world, rand, chest, room, true);
        ChestGenHooks info = ChestGenHooks.getInfo((String)BOSS_LOOT);
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chest, (int)info.getCount(rand));
        WorldUtils.addItemToInventoryAtRandom(rand, new ItemStack(ZSSItems.skillOrb, 1, (int)SkillBase.bonusHeart.getId()), chest, 3);
        ItemStack stack = room.getBossType().getSpecialItem();
        if (stack != null) {
            WorldUtils.addItemToInventoryAtRandom(rand, stack, chest, 3);
        }
        if ((stack = room.getBossType().getRandomSpecialItem(rand)) != null && rand.nextFloat() < 0.2f) {
            WorldUtils.addItemToInventoryAtRandom(rand, stack, chest, 3);
        } else {
            WorldUtils.generateRandomChestContents(rand, DungeonLootLists.getSkillOrbList(), chest, 1, false);
        }
    }

    private static void initBasicConsumables() {
        DungeonLootLists.setCategoryStats(ChestGenHooks.getInfo((String)BASIC_LOOT), Config.getMinNumItems(), Config.getMinNumItems() + 4, new WeightedRandomChestContent[]{DungeonLootLists.getLoot(Items.field_151034_e, 1, 2, 5), DungeonLootLists.getLoot(Items.field_151025_P, 1, 2, 5), DungeonLootLists.getLoot(Items.field_151111_aL, 1, 2, 4), DungeonLootLists.getLoot((Item)Items.field_151148_bJ, 1, 3, 4), DungeonLootLists.getLoot(Items.field_151062_by, 1, 5, 5), DungeonLootLists.getLoot(Items.field_151057_cb, 1, 2, 5), DungeonLootLists.getLoot(Items.field_151045_i, 1, 2, 2), DungeonLootLists.getLoot(Items.field_151043_k, 1, 2, 3), DungeonLootLists.getLoot(Items.field_151042_j, 1, 2, 4), DungeonLootLists.getLoot(Items.field_151069_bo, 1, 3, 5), DungeonLootLists.getLoot(Items.field_151166_bC, 2, 5, 7), DungeonLootLists.getLoot(Items.field_151032_g, 3, 7, 7), DungeonLootLists.getLoot(Items.field_151081_bc, 1, 2, 3), DungeonLootLists.getLoot(ZSSItems.bombBag, 1, 1, Config.getBombBagWeight() / 2), DungeonLootLists.getLoot(ZSSItems.keySmall, 1, 1, Config.getSmallKeyWeight()), DungeonLootLists.getLoot(ZSSItems.potionRed, 1, 1, 3), DungeonLootLists.getLoot(ZSSItems.potionGreen, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.shieldDeku, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.swordBroken, Item.func_150891_b((Item)ZSSItems.swordKokiri), 1, 1, 1)});
    }

    private static void initBossLoot() {
        DungeonLootLists.setCategoryStats(ChestGenHooks.getInfo((String)BOSS_LOOT), 1, 2, new WeightedRandomChestContent[]{DungeonLootLists.getLoot(ZSSItems.arrowFire, 7, 15, 1), DungeonLootLists.getLoot(ZSSItems.arrowIce, 7, 15, 1), DungeonLootLists.getLoot(ZSSItems.arrowLight, 3, 7, 1), DungeonLootLists.getLoot(ZSSItems.bombBag, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.boomerang, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.bootsHeavy, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.bootsHover, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.bootsPegasus, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.bootsRubber, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.crystalSpirit, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.dekuLeaf, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.hammer, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.heroBow, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.hookshot, HookshotType.WOOD_SHOT.ordinal(), 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.hookshotAddon, ItemHookShotUpgrade.AddonType.EXTENSION.ordinal(), 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.hookshotAddon, ItemHookShotUpgrade.AddonType.STONECLAW.ordinal(), 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.hookshotAddon, ItemHookShotUpgrade.AddonType.MULTI.ordinal(), 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.keySkeleton, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.magicMirror, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.masterOre, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.potionBlue, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.rocsFeather, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.shieldHylian, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.slingshot, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.treasure, ItemTreasure.Treasures.ZELDAS_LETTER.ordinal(), 1, 1, 1)});
    }

    private static void initJarDrops() {
        DungeonLootLists.setCategoryStats(ChestGenHooks.getInfo((String)JAR_DROPS), 1, 1, new WeightedRandomChestContent[]{DungeonLootLists.getLoot(ZSSItems.bomb, BombType.BOMB_STANDARD.ordinal(), 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.potionRed, 1, 1, 3), DungeonLootLists.getLoot(ZSSItems.potionGreen, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.smallHeart, 1, 1, 5), DungeonLootLists.getLoot(ZSSItems.dekuNut, 1, 1, 4), DungeonLootLists.getLoot(Items.field_151032_g, 1, 1, 5), DungeonLootLists.getLoot(Items.field_151166_bC, 1, 1, 10)});
    }

    private static void initLockedLoot() {
        DungeonLootLists.setCategoryStats(ChestGenHooks.getInfo((String)LOCKED_LOOT), 1, 3, new WeightedRandomChestContent[]{DungeonLootLists.getLoot(ZSSItems.arrowFire, 2, 5, Config.getLockedLootWeight()), DungeonLootLists.getLoot(ZSSItems.arrowIce, 2, 5, Config.getLockedLootWeight()), DungeonLootLists.getLoot(ZSSItems.arrowLight, 1, 3, 1), DungeonLootLists.getLoot(Items.field_151153_ao, 1, 2, Math.max(Config.getLockedLootWeight() / 3, 1)), DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.HEALING_II.id, 1, 1, Math.max(Config.getLockedLootWeight() / 2, 2)), DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.HEALING_SPLASH.id, 1, 1, Math.max(Config.getLockedLootWeight() / 2, 2)), DungeonLootLists.getLoot(ZSSItems.bombBag, 1, 1, Config.getBombBagWeight()), DungeonLootLists.getLoot(ZSSItems.magicMirror, 1, 1, Config.getLockedLootWeight()), DungeonLootLists.getLoot(ZSSItems.potionBlue, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.swordOrdon, 1, 1, Config.getLockedLootWeight()), DungeonLootLists.getLoot(ZSSItems.tunicHeroBoots, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicHeroLegs, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicHeroChest, 1, 1, 1), DungeonLootLists.getLoot(ZSSItems.tunicHeroHelm, 1, 1, 1)});
    }

    private static void initNetherLoot() {
        DungeonLootLists.setCategoryStats(ChestGenHooks.getInfo((String)NETHER_LOOT), 1, 2, new WeightedRandomChestContent[]{DungeonLootLists.getLoot(Items.field_151073_bk, 1, 2, 1), DungeonLootLists.getLoot(Items.field_151075_bm, 1, 2, 1), DungeonLootLists.getLoot((Item)Items.field_151068_bn, LibPotionID.FIRERESIST.id, 1, 1, 2), DungeonLootLists.getLoot(Items.field_151072_bj, 1, 3, 2), DungeonLootLists.getLoot(Items.field_151059_bz, 1, 3, 3), DungeonLootLists.getLoot(Items.field_151064_bs, 1, 3, 3), DungeonLootLists.getLoot(ZSSItems.arrowBombFire, 2, 5, 3), DungeonLootLists.getLoot(ZSSItems.bomb, BombType.BOMB_FIRE.ordinal(), 1, 2, Config.getBombWeight() * 2)});
    }

    private static void initSkillOrbLoot() {
        for (SkillBase skill : SkillBase.getSkills()) {
            if (!skill.isLoot()) continue;
            skillOrbLootList.add(DungeonLootLists.getLoot(ZSSItems.skillOrb, skill.getId(), 1, 1, Config.getLockedLootWeight()));
        }
    }
}

