/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.EntityOctorok;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.crisis.AbstractCrisis;

public class BossBattle
extends AbstractCrisis {
    protected final TileEntityDungeonCore core;
    protected final StructureBoundingBox box;
    protected int difficulty = -1;

    public BossBattle(TileEntityDungeonCore core) {
        this.core = core;
        this.box = core.getDungeonBoundingBox();
        this.eventTimer = 6000;
        if (core.getBossType() == null) {
            throw new IllegalArgumentException("Dungeon Core must have a valid BossType!");
        }
        if (this.box == null) {
            throw new IllegalArgumentException("Dungeon Core bounding box can not be null!");
        }
    }

    @Override
    public void beginCrisis(World world) {
        this.difficulty = world.field_73013_u.ordinal();
        this.fillAllGaps(world);
        this.generateBossMobs(world, Config.getNumBosses());
        this.core.removeHinderBlock();
    }

    @Override
    protected void endCrisis(World world) {
        world.func_72908_a((double)this.box.func_78881_e() + 0.5, (double)(this.box.func_78879_f() + 1), (double)this.box.func_78891_g() + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        if (world.field_73013_u != EnumDifficulty.PEACEFUL) {
            WorldUtils.spawnXPOrbsWithRandom(world, world.field_73012_v, this.box.func_78881_e(), this.box.func_78879_f(), this.box.func_78891_g(), 1000 * this.difficulty);
        }
    }

    @Override
    protected boolean canCrisisConclude(World world) {
        return this.areAllEnemiesDead(world);
    }

    @Override
    protected void onUpdateTick(World world) {
    }

    private boolean areAllEnemiesDead(World world) {
        return world.func_72872_a(IMob.class, AxisAlignedBB.func_72332_a().func_72299_a((double)this.box.func_78881_e() - 0.5, (double)this.box.func_78879_f(), (double)this.box.func_78891_g() - 0.5, (double)this.box.func_78881_e() + 0.5, (double)(this.box.func_78879_f() + 1), (double)this.box.func_78891_g() + 0.5).func_72314_b((double)(this.box.func_78883_b() / 2), (double)(this.box.func_78882_c() / 2), (double)(this.box.func_78880_d() / 2))).isEmpty();
    }

    protected void destroyRandomPillar(World world, boolean explode) {
        int z;
        int offset;
        int corner = world.field_73012_v.nextInt(4);
        int n = offset = this.box.func_78883_b() < 11 ? 2 : 3;
        int x = corner < 2 ? (this.box.func_78883_b() < 11 ? this.box.func_78881_e() : this.box.field_78897_a) + offset : (this.box.func_78883_b() < 11 ? this.box.func_78881_e() : this.box.field_78893_d) - offset;
        int y = this.box.field_78895_b + (world.field_73012_v.nextInt(3) + 1);
        int n2 = corner % 2 == 0 ? (this.box.func_78880_d() < 11 ? this.box.func_78891_g() : this.box.field_78896_c) + offset : (z = (this.box.func_78880_d() < 11 ? this.box.func_78891_g() : this.box.field_78892_f) - offset);
        if (!world.func_147437_c(x, y, z)) {
            if (explode) {
                float radius = 1.5f + (float)this.difficulty * 0.5f;
                CustomExplosion.createExplosion(world, x, y, z, radius, BombType.BOMB_STANDARD);
            }
            world.func_72908_a((double)x + 0.5, (double)this.box.func_78879_f(), (double)z + 0.5, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
            StructureGenUtils.destroyBlocksAround(world, x - 1, x + 2, y, this.box.field_78894_e - 2, z - 1, z + 2, null, false);
        }
    }

    protected void fillAllGaps(World world) {
        Block block = this.core.getRenderBlock();
        if (block == null) {
            block = BlockSecretStone.getBlockFromMeta(world.func_72805_g(this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e));
        }
        for (int i = this.box.field_78897_a; i <= this.box.field_78893_d; ++i) {
            for (int j = this.box.field_78895_b; j <= this.box.field_78894_e; ++j) {
                for (int k = this.box.field_78896_c; k <= this.box.field_78892_f; ++k) {
                    if (i != this.box.field_78897_a && i != this.box.field_78893_d && j != this.box.field_78895_b && j != this.box.field_78894_e && k != this.box.field_78896_c && k != this.box.field_78892_f || world.func_147439_a(i, j, k).func_149730_j()) continue;
                    world.func_147465_d(i, j, k, block, 0, 2);
                }
            }
        }
    }

    protected void setDungeonFloorTo(World world, Block block, int meta, Block toReplace) {
        Block replace = toReplace != null ? toReplace : BlockSecretStone.getBlockFromMeta(world.func_72805_g(this.core.field_145851_c, this.core.field_145848_d, this.core.field_145849_e));
        for (int i = this.box.field_78897_a + 1; i < this.box.field_78893_d; ++i) {
            for (int j = this.box.field_78896_c + 1; j < this.box.field_78892_f; ++j) {
                if (world.func_147439_a(i, this.box.field_78895_b, j) != replace) continue;
                world.func_147465_d(i, this.box.field_78895_b, j, block, meta, 2);
            }
        }
    }

    protected void setRandomBlockTo(World world, Block block, int meta, String sound) {
        int z;
        int y;
        int x = this.box.field_78897_a + world.field_73012_v.nextInt(this.box.func_78883_b() - 1) + 1;
        if (world.func_147437_c(x, y = this.box.field_78895_b + world.field_73012_v.nextInt(4) + 3, z = this.box.field_78896_c + world.field_73012_v.nextInt(this.box.func_78880_d() - 1) + 1)) {
            world.func_147465_d(x, y, z, block, meta, 3);
            if (sound.length() > 0) {
                world.func_72908_a((double)x, (double)y, (double)z, sound, 1.0f, 1.0f);
            }
        }
    }

    public final void generateBossMobs(World world, int number) {
        for (int i = 0; i < number; ++i) {
            Entity mob = this.core.getBossType().getNewMob(world);
            if (mob == null) continue;
            this.spawnMobInCorner(world, mob, i, true, true);
        }
    }

    protected void spawnMobInCorner(World world, Entity mob, int corner, boolean equip, boolean health) {
        int x = corner < 2 ? this.box.field_78897_a + 2 : this.box.field_78893_d - 2;
        int z = corner % 2 == 0 ? this.box.field_78896_c + 2 : this.box.field_78892_f - 2;
        int y = World.func_147466_a((IBlockAccess)world, (int)x, (int)(this.box.field_78895_b + 1), (int)z) ? this.box.field_78895_b + 1 : this.box.field_78895_b + 3;
        WorldUtils.setEntityInStructure(world, mob, x, y, z);
        if (mob instanceof EntityLivingBase) {
            if (health) {
                this.boostHealth(world, (EntityLivingBase)mob);
            }
            if (equip) {
                this.equipEntity(world, (EntityLivingBase)mob);
            }
        }
        if (mob instanceof EntityLiving) {
            ((EntityLiving)mob).func_110163_bv();
        }
        if (!world.field_72995_K) {
            world.func_72838_d(mob);
        }
    }

    protected void boostHealth(World world, EntityLivingBase entity) {
        double d = (float)(2 * this.difficulty) * Config.getBossHealthFactor();
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() * d);
        entity.func_70606_j(entity.func_110138_aP());
    }

    protected void equipEntity(World world, EntityLivingBase entity) {
        ItemStack melee = null;
        ItemStack ranged = new ItemStack((Item)Items.field_151031_f);
        Item[] armorSet = null;
        switch (this.difficulty) {
            case 1: {
                armorSet = new Item[]{Items.field_151029_X, Items.field_151022_W, Items.field_151023_V, Items.field_151020_U};
                melee = new ItemStack(Items.field_151040_l);
                ranged.func_77966_a(Enchantment.field_77345_t, 1);
                break;
            }
            case 2: {
                armorSet = new Item[]{Items.field_151167_ab, Items.field_151165_aa, Items.field_151030_Z, Items.field_151028_Y};
                melee = new ItemStack(Items.field_151040_l);
                melee.func_77966_a(Enchantment.field_77338_j, 2);
                ranged.func_77966_a(Enchantment.field_77344_u, 1);
                ranged.func_77966_a(Enchantment.field_77345_t, 3);
                break;
            }
            case 3: {
                armorSet = new Item[]{Items.field_151175_af, Items.field_151173_ae, Items.field_151163_ad, Items.field_151161_ac};
                melee = new ItemStack(Items.field_151048_u);
                melee.func_77966_a(Enchantment.field_77338_j, 4);
                melee.func_77966_a(Enchantment.field_77334_n, 1);
                ranged.func_77966_a(Enchantment.field_77343_v, 1);
                ranged.func_77966_a(Enchantment.field_77344_u, 2);
                ranged.func_77966_a(Enchantment.field_77345_t, 5);
            }
        }
        if (armorSet != null) {
            for (int i = 0; i < armorSet.length; ++i) {
                ItemStack armor = new ItemStack((Item)armorSet[i]);
                EnchantmentHelper.func_77504_a((Random)world.field_73012_v, (ItemStack)armor, (int)(this.difficulty + world.field_73012_v.nextInt(this.difficulty * 5)));
                entity.func_70062_b(i + 1, armor);
            }
        }
        if (entity instanceof EntityZombie) {
            ((EntityZombie)entity).func_70062_b(0, melee);
        } else if (entity instanceof EntitySkeleton) {
            EntitySkeleton skeleton = (EntitySkeleton)entity;
            if (this.core.getBossType() == BossType.HELL) {
                skeleton.func_82201_a(1);
                skeleton.func_70062_b(0, melee);
            } else {
                skeleton.func_70062_b(0, ranged);
            }
        } else {
            if (entity instanceof EntityOctorok) {
                ((EntityOctorok)entity).setType(1);
            }
            IAttributeInstance iattribute = entity.func_110148_a(SharedMonsterAttributes.field_111264_e);
            AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), "Boss Attack Bonus", (double)this.difficulty * 2.0, 0).func_111168_a(true);
            iattribute.func_111121_a(modifier);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("difficulty", this.difficulty);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.difficulty = compound.func_74762_e("difficulty");
    }
}

