/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.util;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.AbstractPacket;

public class WorldUtils {
    public static final int MAX_RADIUS = 16;

    public static void activateButton(World world, Block block, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        world.func_72921_c(x, y, z, meta < 8 ? meta | 8 : meta & 0xFFFFFFF7, 3);
        world.func_147479_m(x, y, z);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        world.func_147464_a(x, y, z, block, block.func_149738_a(world));
        world.func_147459_d(x, y, z, block);
        switch (meta & 7) {
            case 0: 
            case 7: {
                world.func_147459_d(x, y + 1, z, block);
                break;
            }
            case 1: {
                world.func_147459_d(x - 1, y, z, block);
                break;
            }
            case 2: {
                world.func_147459_d(x + 1, y, z, block);
                break;
            }
            case 3: {
                world.func_147459_d(x, y, z - 1, block);
                break;
            }
            case 4: {
                world.func_147459_d(x, y, z + 1, block);
                break;
            }
            default: {
                world.func_147459_d(x, y - 1, z, block);
            }
        }
    }

    public static boolean canMeltBlock(World world, Block block, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        boolean flag = Config.enableFireArrowMelt() ? (meta & 0xFFFFFFF7) == 5 : meta == 5;
        return block.func_149688_o() == Material.field_151588_w || block.func_149688_o() == Material.field_151597_y || block == ZSSBlocks.secretStone && flag;
    }

    public static void dropContainerBlockInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)tileEntity;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            WorldUtils.spawnItemWithRandom(world, inv.func_70304_b(i), x, y, z);
        }
    }

    public static void generateRandomChestContents(Random rand, WeightedRandomChestContent[] weightedContents, IInventory chest, int numItems, boolean atRandom) {
        for (int i = 0; i < numItems; ++i) {
            ItemStack[] stacks;
            WeightedRandomChestContent weightedChest = (WeightedRandomChestContent)WeightedRandom.func_76274_a((Random)rand, (WeightedRandom.Item[])weightedContents);
            for (ItemStack item : stacks = ChestGenHooks.generateStacks((Random)rand, (ItemStack)weightedChest.field_76297_b, (int)weightedChest.field_76295_d, (int)weightedChest.field_76296_e)) {
                if (atRandom) {
                    chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), item);
                    continue;
                }
                WorldUtils.addItemToInventoryAtRandom(rand, item, chest, 3);
            }
        }
    }

    public static int addItemToInventoryAtRandom(Random rand, ItemStack stack, IInventory inv, int numAttempts) {
        for (int i = 0; i < numAttempts; ++i) {
            int slot = rand.nextInt(inv.func_70302_i_());
            if (inv.func_70301_a(slot) != null) continue;
            inv.func_70299_a(slot, stack);
            return 0;
        }
        return WorldUtils.addItemToInventory(stack, inv);
    }

    public static int addItemToInventory(ItemStack stack, IInventory inv) {
        int remaining = stack.field_77994_a;
        for (int i = 0; i < inv.func_70302_i_() && remaining > 0; ++i) {
            ItemStack slotstack = inv.func_70301_a(i);
            if (slotstack == null && inv.func_94041_b(i, stack)) {
                stack.field_77994_a = (remaining -= inv.func_70297_j_()) > 0 ? inv.func_70297_j_() : stack.field_77994_a;
                inv.func_70299_a(i, stack);
                inv.func_70296_d();
                continue;
            }
            if (slotstack == null || !stack.func_77985_e() || !inv.func_94041_b(i, stack) || slotstack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != slotstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotstack)) continue;
            int l = slotstack.field_77994_a + remaining;
            if (l <= stack.func_77976_d() && l <= inv.func_70297_j_()) {
                remaining = 0;
                slotstack.field_77994_a = l;
                inv.func_70296_d();
                continue;
            }
            if (slotstack.field_77994_a >= stack.func_77976_d() || stack.func_77976_d() > inv.func_70297_j_()) continue;
            remaining -= stack.func_77976_d() - slotstack.field_77994_a;
            slotstack.field_77994_a = stack.func_77976_d();
            inv.func_70296_d();
        }
        return remaining;
    }

    public static HashSet<ChunkPosition> getAffectedBlocksList(World world, Random rand, float radius, double posX, double posY, double posZ, Block targetBlock) {
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double d3 = (float)i / 15.0f * 2.0f - 1.0f;
                    double d4 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d5 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d0 = posX;
                    double d1 = posY;
                    double d2 = posZ;
                    float f2 = 0.3f;
                    for (float f1 = radius * (0.7f + rand.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int j1;
                        int i1;
                        int l = MathHelper.func_76128_c((double)d0);
                        Block block = world.func_147439_a(l, i1 = MathHelper.func_76128_c((double)d1), j1 = MathHelper.func_76128_c((double)d2));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            f1 -= 1.3f * f2;
                        }
                        if (f1 > 0.0f && (targetBlock == null || block == targetBlock)) {
                            hashset.add(new ChunkPosition(l, i1, j1));
                        }
                        d0 += d3 * (double)f2;
                        d1 += d4 * (double)f2;
                        d2 += d5 * (double)f2;
                    }
                }
            }
        }
        return hashset;
    }

    public static List getTileEntitiesWithinAABB(World world, Class clazz, AxisAlignedBB aabb) {
        int maxZ;
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        int minX = MathHelper.func_76128_c((double)(aabb.field_72340_a - World.MAX_ENTITY_RADIUS));
        int maxX = MathHelper.func_76128_c((double)(aabb.field_72336_d + World.MAX_ENTITY_RADIUS));
        int minY = MathHelper.func_76128_c((double)(aabb.field_72338_b - World.MAX_ENTITY_RADIUS));
        int maxY = MathHelper.func_76128_c((double)(aabb.field_72337_e + World.MAX_ENTITY_RADIUS));
        int minZ = MathHelper.func_76128_c((double)(aabb.field_72339_c - World.MAX_ENTITY_RADIUS));
        if (!world.func_72904_c(minX, minY, minZ, maxX, maxY, maxZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + World.MAX_ENTITY_RADIUS)))) {
            return list;
        }
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    TileEntity te = world.func_147438_o(i, j, k);
                    if (te == null || !clazz.isAssignableFrom(te.getClass())) continue;
                    list.add(te);
                }
            }
        }
        return list;
    }

    public static TileEntityDungeonCore getNearbyFairySpawner(World world, double x, double y, double z, boolean requiresFairy) {
        List list = WorldUtils.getTileEntitiesWithinAABB(world, TileEntityDungeonCore.class, AxisAlignedBB.func_72330_a((double)(x - 3.0), (double)(y - 2.0), (double)(z - 3.0), (double)(x + 3.0), (double)(y + 2.0), (double)(z + 3.0)));
        for (TileEntityDungeonCore core : list) {
            if (!core.isSpawner() || requiresFairy && world.func_72872_a(EntityFairy.class, AxisAlignedBB.func_72330_a((double)((double)core.field_145851_c - 5.0), (double)((double)core.field_145848_d - 1.0), (double)((double)core.field_145849_e - 5.0), (double)((double)core.field_145851_c + 5.0), (double)((double)core.field_145848_d + 5.0), (double)((double)core.field_145849_e + 5.0))).size() <= 0) continue;
            return core;
        }
        return null;
    }

    public static void playSoundAtEntity(World world, Entity entity, String sound, float f, float add) {
        WorldUtils.playSoundAt(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, f, add);
    }

    public static void playSoundAt(World world, double x, double y, double z, String sound, float f, float add) {
        float volume = world.field_73012_v.nextFloat() * f + add;
        float pitch = 1.0f / (world.field_73012_v.nextFloat() * f + add);
        world.func_72908_a(x, y, z, sound, volume, pitch);
    }

    public static void sendPacketToAllAround(AbstractPacket packet, World world, EntityPlayer player, double distance) {
        WorldUtils.sendPacketToAllAround(packet, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, distance);
    }

    public static void sendPacketToAllAround(AbstractPacket packet, World world, double x, double y, double z, double distance) {
        ZSSMain.dispatcher.sendToAllAround(packet, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, distance));
    }

    public static void spawnItemWithRandom(World world, ItemStack stack, double x, double y, double z) {
        if (!world.field_72995_K && stack != null) {
            double spawnX = x + (double)world.field_73012_v.nextFloat();
            double spawnY = y + (double)world.field_73012_v.nextFloat();
            double spawnZ = z + (double)world.field_73012_v.nextFloat();
            float f3 = 0.05f;
            EntityItem entityitem = new EntityItem(world, spawnX, spawnY, spawnZ, stack);
            entityitem.field_70159_w = (-0.5 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_70181_x = (4.0 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_70179_y = (-0.5 + world.field_73012_v.nextGaussian()) * (double)f3;
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnWorldParticles(World world, EntityFX particle) {
        Minecraft mc = Minecraft.func_71410_x();
        if (particle != null && mc != null && mc.field_71451_h != null && mc.field_71452_i != null) {
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (particleSetting == 2 || particleSetting == 1 && world.field_73012_v.nextInt(3) == 0) {
                return;
            }
            double dx = mc.field_71451_h.field_70165_t - particle.field_70165_t;
            double dy = mc.field_71451_h.field_70163_u - particle.field_70163_u;
            double dz = mc.field_71451_h.field_70161_v - particle.field_70161_v;
            if (dx * dx + dy * dy + dz * dz < 256.0) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
            }
        }
    }

    public static void spawnXPOrbsWithRandom(World world, Random rand, int x, int y, int z, int xpAmount) {
        if (!world.field_72995_K) {
            while (xpAmount > 0) {
                int xp = xpAmount > 50 ? 50 : EntityXPOrb.func_70527_a((int)xpAmount);
                xpAmount -= xp;
                float spawnX = (float)x + rand.nextFloat();
                float spawnY = (float)y + rand.nextFloat();
                float spawnZ = (float)z + rand.nextFloat();
                EntityXPOrb xpOrb = new EntityXPOrb(world, (double)spawnX, (double)spawnY, (double)spawnZ, xp);
                xpOrb.field_70181_x += (4.0 + rand.nextGaussian()) * (double)0.05f;
                world.func_72838_d((Entity)xpOrb);
            }
        }
    }

    public static boolean setEntityInStructure(World world, Entity entity, int x, int y, int z) {
        if (entity == null) {
            return false;
        }
        entity.func_70012_b((double)x, (double)y, (double)z, 0.0f, 0.0f);
        block6: for (int i = 0; entity.func_70094_T() && i < 8; ++i) {
            if (i == 4) {
                entity.func_70107_b((double)(x + 1), (double)y, (double)(z + 1));
            }
            switch (i % 4) {
                case 0: {
                    entity.func_70107_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5);
                    continue block6;
                }
                case 1: {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v - 1.0);
                    continue block6;
                }
                case 2: {
                    entity.func_70107_b(entity.field_70165_t - 1.0, entity.field_70163_u, entity.field_70161_v);
                    continue block6;
                }
                case 3: {
                    entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v + 1.0);
                }
            }
        }
        if (entity.func_70094_T()) {
            entity.func_70107_b(entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5);
            return false;
        }
        return true;
    }
}

