/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.ActivateSkillPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class SwordBreak
extends SkillActive {
    private int breakTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private boolean playMissSound;

    public SwordBreak(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private SwordBreak(SwordBreak skill) {
        super(skill);
    }

    @Override
    public SwordBreak newInstance() {
        return new SwordBreak(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{this.getMaxDamage()}));
        desc.add(this.getTimeLimitDisplay(this.getActiveTime() - this.getUseDelay()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.breakTimer > 0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSkillItem(player);
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (super.activate(world, player)) {
            this.breakTimer = this.getActiveTime();
            this.playMissSound = true;
            if (world.field_72995_K) {
                KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i(), (boolean)false);
                KeyBinding.func_74510_a((int)ZSSKeyHandler.keys[6].func_151463_i(), (boolean)false);
                player.func_71038_i();
            }
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (--this.breakTimer <= this.getUseDelay() && this.playMissSound) {
                this.playMissSound = false;
                WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            }
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            if (!Config.requiresDoubleTap() && !Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
                ZSSMain.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                --this.ticksTilFail;
            }
        }
    }

    private int getActiveTime() {
        return 6 + this.level;
    }

    private int getUseDelay() {
        return 5 - this.level / 2;
    }

    private int getMaxDamage() {
        return (this.level + 1) * 15;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(EntityPlayer player) {
        if (!this.isActive()) {
            if (Config.requiresDoubleTap() && this.ticksTilFail > 0) {
                ZSSMain.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                this.ticksTilFail = Config.requiresDoubleTap() ? 6 : 3;
            }
        }
    }

    public boolean breakAttack(EntityPlayer player, EntityLivingBase attacker) {
        ItemStack stackToDamage = attacker.func_70694_bm();
        if (this.breakTimer > this.getUseDelay() && stackToDamage != null && PlayerUtils.isHoldingSkillItem(player)) {
            this.breakTimer = this.getUseDelay();
            WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:swordstrike", 0.4f, 0.5f);
            this.playMissSound = false;
            int dmg = Math.max(this.getMaxDamage() / 3, player.field_70170_p.field_73012_v.nextInt(this.getMaxDamage()));
            stackToDamage.func_77972_a(dmg, attacker);
            if (stackToDamage.field_77994_a <= 0) {
                player.field_70170_p.func_72956_a((Entity)attacker, "random.break", 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                attacker.func_70062_b(0, null);
            }
            TargetUtils.knockTargetBack(attacker, (EntityLivingBase)player);
            return true;
        }
        return false;
    }
}

