/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.ActivateSkillPacket;
import zeldaswordskills.network.EndComboPacket;
import zeldaswordskills.network.TargetIdPacket;
import zeldaswordskills.skills.Combo;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class SwordBasic
extends SkillActive
implements ICombo,
ILockOnTarget {
    private boolean isActive = false;
    @SideOnly(value=Side.CLIENT)
    private boolean packetSent;
    private EntityLivingBase currentTarget = null;
    @SideOnly(value=Side.CLIENT)
    private EntityLivingBase prevTarget;
    private Combo combo = null;

    public SwordBasic(String name) {
        super(name);
    }

    private SwordBasic(SwordBasic skill) {
        super(skill);
    }

    @Override
    public SwordBasic newInstance() {
        return new SwordBasic(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{this.getMaxComboSize()}));
        desc.add(this.getTimeLimitDisplay(this.getComboTimeLimit()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.1f", Float.valueOf(0.5f * (float)this.level))}));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 0.0f;
    }

    @Override
    public byte getMaxLevel() {
        return 10;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (super.activate(world, player)) {
            boolean bl = this.isActive = !this.isActive;
            if (this.isActive) {
                if (!this.isComboInProgress()) {
                    this.combo = null;
                }
                this.currentTarget = TargetUtils.acquireLookTarget((EntityLivingBase)player, this.getRange(), this.getRange(), true);
            } else {
                this.currentTarget = null;
                if (world.field_72995_K) {
                    this.prevTarget = null;
                    if (this.packetSent) {
                        this.packetSent = false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive && player.field_70170_p.field_72995_K && !this.packetSent && (Minecraft.func_71410_x().field_71462_r != null || !this.updateTargets(player))) {
            ZSSMain.dispatcher.sendToServer(new ActivateSkillPacket(this));
            this.packetSent = true;
        }
        if (this.isComboInProgress()) {
            this.combo.onUpdate(player);
        }
    }

    @Override
    public final boolean isLockedOn() {
        return this.currentTarget != null;
    }

    public final EntityLivingBase getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public void setCurrentTarget(Entity entity) {
        if (entity == null || entity instanceof EntityLivingBase) {
            this.currentTarget = (EntityLivingBase)entity;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void getNextTarget(EntityPlayer player) {
        EntityLivingBase nextTarget = null;
        double dTarget = 0.0;
        List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, this.getRange(), this.getRange());
        for (EntityLivingBase entity : list) {
            if (entity == player || entity == this.currentTarget || entity == this.prevTarget || !this.isTargetValid(player, entity)) continue;
            if (nextTarget == null) {
                dTarget = player.func_70068_e((Entity)entity);
                nextTarget = entity;
                continue;
            }
            double distance = player.func_70068_e((Entity)entity);
            if (!(distance < dTarget)) continue;
            nextTarget = entity;
            dTarget = distance;
        }
        if (nextTarget != null) {
            this.prevTarget = this.currentTarget;
            this.currentTarget = nextTarget;
        } else {
            nextTarget = this.currentTarget;
            this.currentTarget = this.prevTarget;
            this.prevTarget = nextTarget;
        }
        ZSSMain.dispatcher.sendToServer(new TargetIdPacket(this));
    }

    private final int getRange() {
        return 6 + this.level;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean updateTargets(EntityPlayer player) {
        if (!this.isTargetValid(player, this.prevTarget) || !TargetUtils.isTargetInSight((EntityLivingBase)player, (Entity)this.prevTarget)) {
            this.prevTarget = null;
        }
        if (!this.isTargetValid(player, this.currentTarget)) {
            this.currentTarget = null;
            if (Config.autoTargetEnabled()) {
                this.getNextTarget(player);
            }
        }
        return this.isTargetValid(player, this.currentTarget);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isTargetValid(EntityPlayer player, EntityLivingBase target) {
        return target != null && !target.field_70128_L && target.func_110143_aJ() > 0.0f && player.func_70032_d((Entity)target) < (float)this.getRange() && !target.func_82150_aj() && (Config.canTargetPlayers() || !(target instanceof EntityPlayer));
    }

    @Override
    public final Combo getCombo() {
        return this.combo;
    }

    @Override
    public final void setCombo(Combo combo) {
        this.combo = combo;
    }

    @Override
    public final boolean isComboInProgress() {
        return this.combo != null && !this.combo.isFinished();
    }

    private final int getMaxComboSize() {
        return 2 + this.level;
    }

    private final int getComboTimeLimit() {
        return 20 + this.level * 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onAttack(EntityPlayer player) {
        boolean attackHit;
        Entity mouseOver = TargetUtils.getMouseOverEntity();
        boolean bl = attackHit = this.isLockedOn() && mouseOver != null && TargetUtils.canReachTarget(player, mouseOver);
        if (!attackHit) {
            PlayerUtils.playRandomizedSound(player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            if (this.isComboInProgress()) {
                ZSSMain.dispatcher.sendToServer(new EndComboPacket(this));
            }
        }
        return attackHit;
    }

    @Override
    public void onHurtTarget(EntityPlayer player, LivingHurtEvent event) {
        float damage;
        if (event.source.func_76352_a()) {
            return;
        }
        if ((this.combo == null || this.combo.isFinished()) && !player.field_70170_p.field_72995_K) {
            this.combo = new Combo(player, this, this.getMaxComboSize(), this.getComboTimeLimit());
        }
        if ((damage = DirtyEntityAccessor.getModifiedDamage(event.entityLiving, event.source, event.ammount)) > 0.0f) {
            boolean flag = event.source.field_76373_n.equals("iArmorBreak");
            if (flag || event.source.field_76373_n.equals("indirectSword")) {
                this.combo.addDamageOnly(player, damage, flag);
            } else {
                this.combo.add(player, (Entity)event.entityLiving, damage);
            }
        }
        if (event.source.field_76373_n.equals("player")) {
            String sound = PlayerUtils.isHoldingSword(player) ? "zeldaswordskills:swordcut" : "zeldaswordskills:hurtflesh";
            WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, sound, 0.4f, 0.5f);
        }
    }

    @Override
    public void onPlayerHurt(EntityPlayer player, LivingHurtEvent event) {
        if (this.isComboInProgress() && DirtyEntityAccessor.getModifiedDamage((EntityLivingBase)player, event.source, event.ammount) > 0.5f * (float)this.level) {
            this.combo.endCombo(player);
        }
    }
}

