/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.AddExhaustionPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

public class SpinAttack
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private int charge;
    @SideOnly(value=Side.CLIENT)
    private float currentSpin;
    private boolean isActive = false;
    @SideOnly(value=Side.CLIENT)
    private boolean clockwise;
    @SideOnly(value=Side.CLIENT)
    private boolean wasKeyPressed;
    @SideOnly(value=Side.CLIENT)
    private float arc;
    @SideOnly(value=Side.CLIENT)
    private List<EntityLivingBase> targets;
    private int refreshed;
    private boolean isFlaming;
    private int superLevel;

    public SpinAttack(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private SpinAttack(SpinAttack skill) {
        super(skill);
    }

    @Override
    public SpinAttack newInstance() {
        return new SpinAttack(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        byte temp = this.level;
        if (!this.isActive()) {
            this.superLevel = PlayerUtils.getHealthMissing(player) == 0.0f ? (int)ZSSPlayerInfo.get(player).getSkillLevel(superSpinAttack) : 0;
            this.level = ZSSPlayerInfo.get(player).getSkillLevel(spinAttack);
        }
        desc.add(this.getChargeDisplay(this.getChargeTime()));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1).replace("super", ""), (Object[])new Object[]{this.superLevel + 1}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
        this.level = temp;
    }

    @Override
    public boolean canDrop() {
        return this == spinAttack;
    }

    @Override
    public boolean isLoot() {
        return this == spinAttack;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSkillItem(player);
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            this.isActive = super.activate(world, player);
            if (this.isActive()) {
                this.refreshed = 0;
                this.arc = 360.0f;
                this.charge = this.getChargeTime();
                this.superLevel = PlayerUtils.getHealthMissing(player) == 0.0f ? (int)ZSSPlayerInfo.get(player).getSkillLevel(superSpinAttack) : 0;
                this.isFlaming = EnchantmentHelper.func_90036_a((EntityLivingBase)player) > 0;
            }
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive() && this.isCharging()) {
            if (this.isKeyPressed()) {
                if (this.charge < this.getChargeTime() - 1) {
                    Minecraft.func_71410_x().field_71442_b.func_78769_a(player, player.field_70170_p, player.func_70694_bm());
                }
                --this.charge;
                if (this.charge == 0) {
                    this.startSpin(player.field_70170_p, player);
                }
            } else {
                this.isActive = false;
                this.charge = 0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int getChargeTime() {
        return 20 - this.level * 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isCharging() {
        return this.charge > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(KeyBinding key, EntityPlayer player) {
        if (key == ZSSKeyHandler.keys[2] || key == Minecraft.func_71410_x().field_71474_y.field_74312_F) {
            if (PlayerUtils.isHoldingSkillItem(player) && this.isActive && this.arc < 360.0f * (float)(this.superLevel + 1) && this.arc == 360.0f * (float)this.refreshed) {
                this.arc += 360.0f;
            }
        } else {
            if (this.wasKeyPressed) {
                this.wasKeyPressed = false;
            } else {
                this.clockwise = key == ZSSKeyHandler.keys[4] || Config.allowVanillaControls() && key == Minecraft.func_71410_x().field_71474_y.field_74366_z;
                this.wasKeyPressed = true;
            }
            if (this.isKeyPressed()) {
                this.wasKeyPressed = false;
                this.activate(player.field_70170_p, player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return ZSSKeyHandler.keys[3].func_151470_d() || ZSSKeyHandler.keys[4].func_151470_d() || Config.allowVanillaControls() && Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d() && Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
    }

    @SideOnly(value=Side.CLIENT)
    private float getRange() {
        return 3.0f + (float)(this.superLevel + this.level) * 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSpinSpeed() {
        return 70 + 3 * (this.superLevel + this.level);
    }

    @SideOnly(value=Side.CLIENT)
    private void startSpin(World world, EntityPlayer player) {
        ++this.refreshed;
        PlayerUtils.playRandomizedSound(player, "zeldaswordskills:spinattack", 0.4f, 0.5f);
        ZSSMain.dispatcher.sendToServer(new AddExhaustionPacket(this.getExhaustion()));
        this.targets = world.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b((double)this.getRange(), 0.0, (double)this.getRange()));
        if (this.targets.contains(player)) {
            this.targets.remove(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void incrementSpin(EntityPlayer player) {
        player.field_70733_aJ = 0.5f;
        player.func_70082_c(this.clockwise ? this.getSpinSpeed() : -this.getSpinSpeed(), 0.0f);
        this.currentSpin = (float)((double)this.currentSpin + (double)this.getSpinSpeed() * 0.15);
        if (this.currentSpin >= this.arc) {
            this.currentSpin = 0.0f;
            this.isActive = false;
        } else if (this.currentSpin > 360.0f * (float)this.refreshed) {
            this.startSpin(player.field_70170_p, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player) {
        if (!this.isCharging() && PlayerUtils.isHoldingSkillItem(player)) {
            List<EntityLivingBase> list = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, (int)(this.getRange() + 0.5f), 1.0);
            for (EntityLivingBase target : list) {
                if (this.targets == null || !this.targets.contains(target)) continue;
                Minecraft.func_71410_x().field_71442_b.func_78764_a(player, (Entity)target);
                this.targets.remove(target);
            }
            this.spawnParticles(player);
            this.incrementSpin(player);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EntityPlayer player) {
        String particle = this.isFlaming ? "flame" : (this.superLevel > 0 ? "magicCrit" : "crit");
        Vec3 vec3 = player.func_70040_Z();
        double posX = player.field_70165_t + vec3.field_72450_a * (double)this.getRange();
        double posY = player.field_70163_u + (double)player.func_70047_e() - 0.1;
        double posZ = player.field_70161_v + vec3.field_72449_c * (double)this.getRange();
        for (int i = 0; i < 2; ++i) {
            player.field_70170_p.func_72869_a(particle, posX, posY, posZ, vec3.field_72450_a * 0.15, 0.01, vec3.field_72449_c * 0.15);
        }
    }
}

