/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;

public class RisingCut
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int activeTimer;
    private Entity entityHit;

    public RisingCut(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private RisingCut(RisingCut skill) {
        super(skill);
    }

    @Override
    public RisingCut newInstance() {
        return new RisingCut(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getRangeDisplay(2 + this.level));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.ticksTilFail > 0 && player.field_70181_x > 0.0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSword(player);
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - (float)this.level * 0.2f;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (super.activate(world, player)) {
            this.activeTimer = 5 + this.level;
            player.field_70181_x += 0.3 + 0.115 * (double)this.level;
            ZSSPlayerInfo.get((EntityPlayer)player).reduceFallAmount = this.level;
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
        }
        if (this.isActive()) {
            --this.activeTimer;
            if (this.entityHit != null) {
                if (!this.entityHit.field_70128_L) {
                    double addY = 0.3 + 0.125 * (double)this.level;
                    double resist = 1.0;
                    if (this.entityHit instanceof EntityLivingBase) {
                        resist = 1.0 - ((EntityLivingBase)this.entityHit).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                    }
                    this.entityHit.func_70024_g(0.0, addY * resist, 0.0);
                }
                this.entityHit = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed() {
        this.ticksTilFail = 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player) {
        player.field_70733_aJ = 0.5f;
        return false;
    }

    public void onImpact(Entity entity) {
        boolean flag = !(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_70632_aY();
        this.entityHit = flag ? entity : null;
    }
}

