/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.MortalDrawPacket;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class MortalDraw
extends SkillActive {
    private static final int DELAY = 30;
    private int attackTimer;
    private int swordSlot;

    public MortalDraw(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private int getAttackTime() {
        return this.level + 30 + 2;
    }

    private MortalDraw(MortalDraw skill) {
        super(skill);
    }

    @Override
    public MortalDraw newInstance() {
        return new MortalDraw(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(100, true) + "%");
        desc.add(this.getTimeLimitDisplay(this.getAttackTime() - 30));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public boolean isLoot() {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.attackTimer > 30;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.func_70694_bm() == null && (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() || ZSSKeyHandler.keys[6].func_151470_d());
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && this.attackTimer == 0 && this.swordSlot > -1 && player.func_70694_bm() == null;
    }

    @Override
    protected float getExhaustion() {
        return 3.0f - 0.2f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (this.attackTimer == 0) {
            this.swordSlot = -1;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !PlayerUtils.isSwordItem(stack.func_77973_b())) continue;
                this.swordSlot = i;
                break;
            }
        }
        if (super.activate(world, player)) {
            this.attackTimer = this.getAttackTime();
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.attackTimer > 0) {
            --this.attackTimer;
            if (this.attackTimer == 30 && !player.field_70170_p.field_72995_K) {
                this.drawSword(player, null);
                if (player.func_70694_bm() != null) {
                    ZSSMain.dispatcher.sendTo(new MortalDrawPacket(), (EntityPlayerMP)player);
                }
            }
        }
    }

    public boolean drawSword(EntityPlayer player, Entity attacker) {
        boolean flag = false;
        if (this.swordSlot > -1 && this.swordSlot != player.field_71071_by.field_70461_c) {
            player.func_70062_b(0, player.field_71071_by.func_70301_a(this.swordSlot));
            if (!player.field_70170_p.field_72995_K) {
                player.field_71071_by.func_70299_a(this.swordSlot, null);
                ILockOnTarget skill = ZSSPlayerInfo.get(player).getTargetingSkill();
                flag = skill != null && skill.getCurrentTarget() == attacker;
            }
        }
        this.swordSlot = -1;
        return flag;
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.attackTimer = 30;
        event.ammount *= 2.0f;
        WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:mortaldraw", 0.4f, 0.5f);
    }
}

