/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.projectile.EntityLeapingBlow;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.network.AddExhaustionPacket;
import zeldaswordskills.network.SpawnLeapingBlowPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.sword.SwordBasic;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class LeapingBlow
extends SkillActive {
    private boolean isActive = false;
    private boolean isMaster;

    public LeapingBlow(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private LeapingBlow(LeapingBlow skill) {
        super(skill);
    }

    @Override
    public LeapingBlow newInstance() {
        return new LeapingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(PlayerUtils.isHoldingMasterSword(player) ? this.level * 2 : this.level, true));
        desc.add(this.getRangeDisplay(3.0f + 0.5f * (float)this.level));
        desc.add(this.getAreaDisplay(0.5f + 0.25f * (float)this.level));
        desc.add(this.getDurationDisplay(this.getPotionDuration(player), false));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    private float getDamage(EntityPlayer player) {
        return (float)((double)(PlayerUtils.isHoldingMasterSword(player) ? this.level * 2 : this.level) + player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }

    private int getPotionDuration(EntityPlayer player) {
        return (PlayerUtils.isHoldingMasterSword(player) ? 110 : 50) + this.level * 10;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && !player.field_70122_E && PlayerUtils.isHoldingSword(player);
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (this.canUse(player)) {
            ZSSPlayerInfo.get(player).setCurrentActiveSkill(this);
            this.isActive = true;
            this.isMaster = PlayerUtils.isHoldingMasterSword(player) && PlayerUtils.getHealthMissing(player) == 0.0f;
        }
        return this.isActive();
    }

    @SideOnly(value=Side.CLIENT)
    public void onImpact(EntityPlayer player, float distance) {
        SwordBasic swordSkill = (SwordBasic)ZSSPlayerInfo.get(player).getPlayerSkill(swordBasic);
        if (this.isActive() && swordSkill != null && swordSkill.isActive() && PlayerUtils.isHoldingSword(player)) {
            this.isActive = false;
            if (distance < 1.0f) {
                ZSSCombatEvents.performComboAttack(Minecraft.func_71410_x(), swordSkill);
            } else {
                player.func_71038_i();
                ZSSMain.dispatcher.sendToServer(new AddExhaustionPacket(this.getExhaustion()));
                ZSSMain.dispatcher.sendToServer(new SpawnLeapingBlowPacket(this.isMaster));
            }
        }
    }

    public void spawnLeapingBlowEntity(World world, EntityPlayer player, boolean isMaster) {
        this.isMaster = isMaster;
        EntityLeapingBlow entity = new EntityLeapingBlow(world, (EntityLivingBase)player).setDamage(this.getDamage(player)).setLevel(this.level, isMaster);
        world.func_72838_d((Entity)entity);
        WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:leapingblow", 0.4f, 0.5f);
    }
}

