/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class EndingBlow
extends SkillActive {
    private int activeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    @SideOnly(value=Side.CLIENT)
    private int keyPressed;
    private int lastNumHits;
    private EntityLivingBase entityHit;
    private int xp;

    public EndingBlow(String name) {
        super(name);
    }

    private EndingBlow(EndingBlow skill) {
        super(skill);
    }

    @Override
    public EndingBlow newInstance() {
        return new EndingBlow(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.level * 20, true) + "%");
        desc.add(this.getDurationDisplay(this.getDuration(), true));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return this.keyPressed > 1;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        ICombo skill;
        if (super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSkillItem(player) && (skill = ZSSPlayerInfo.get(player).getComboSkill()) != null && skill.isComboInProgress()) {
            if (this.lastNumHits > 0) {
                return skill.getCombo().getConsecutiveHits() > 1 && skill.getCombo().getSize() > this.lastNumHits + 2;
            }
            return skill.getCombo().getConsecutiveHits() > 1;
        }
        return false;
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - (float)this.level * 0.1f;
    }

    public int getDuration() {
        return 110 - this.level * 10;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (super.activate(world, player)) {
            this.activeTimer = 1;
            ICombo skill = ZSSPlayerInfo.get(player).getComboSkill();
            if (skill.getCombo() != null) {
                this.lastNumHits = skill.getCombo().getSize();
            }
            if (world.field_72995_K) {
                this.keyPressed = 0;
            }
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            --this.ticksTilFail;
            if (this.ticksTilFail == 0) {
                this.keyPressed = 0;
            }
        }
        if (this.lastNumHits > 0) {
            ICombo skill;
            if (this.entityHit != null && this.xp > 0) {
                this.updateEntityState(player);
            }
            if ((skill = ZSSPlayerInfo.get(player).getComboSkill()) == null || !skill.isComboInProgress()) {
                this.lastNumHits = 0;
            }
        }
        if (this.isActive()) {
            this.activeTimer = 0;
            if (!player.field_70170_p.field_72995_K) {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.DEFENSE_DOWN, this.getDuration() * 2, 50);
            }
        }
    }

    private void updateEntityState(EntityPlayer player) {
        if (this.entityHit.func_110143_aJ() <= 0.0f) {
            if (this.entityHit instanceof EntityLiving) {
                DirtyEntityAccessor.setLivingXp((EntityLiving)this.entityHit, this.xp, true);
            } else {
                WorldUtils.spawnXPOrbsWithRandom(player.field_70170_p, player.field_70170_p.field_73012_v, MathHelper.func_76128_c((double)this.entityHit.field_70165_t), MathHelper.func_76128_c((double)this.entityHit.field_70163_u), MathHelper.func_76128_c((double)this.entityHit.field_70161_v), this.xp);
            }
        } else {
            WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:grunt", 0.3f, 0.8f);
            ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.DEFENSE_DOWN, this.getDuration(), 50);
        }
        this.entityHit = null;
        this.xp = 0;
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.activeTimer = 0;
        ICombo combo = ZSSPlayerInfo.get(player).getComboSkill();
        ILockOnTarget lock = ZSSPlayerInfo.get(player).getTargetingSkill();
        if (combo != null && combo.isComboInProgress() && lock != null && lock.getCurrentTarget() == combo.getCombo().getLastEntityHit()) {
            event.ammount *= 1.0f + (float)this.level * 0.2f;
            WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:mortaldraw", 0.4f, 0.5f);
            this.entityHit = event.entityLiving;
            this.xp = this.level + 1 + player.field_70170_p.field_73012_v.nextInt(Math.max(2, MathHelper.func_76123_f((float)event.entityLiving.func_110143_aJ())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed() {
        if (this.ticksTilFail == 0) {
            this.ticksTilFail = 6;
        }
        ++this.keyPressed;
    }
}

