/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.ActivateSkillPacket;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;

public class Dodge
extends SkillActive {
    @SideOnly(value=Side.CLIENT)
    private int ticksTilFail;
    private int dodgeTimer = 0;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keyPressed;

    public Dodge(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private Dodge(Dodge skill) {
        super(skill);
    }

    @Override
    public Dodge newInstance() {
        return new Dodge(this);
    }

    @Override
    public boolean isActive() {
        return this.dodgeTimer > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{(int)(this.getBaseDodgeChance(player) * 100.0f)}));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{(this.getDodgeTime() + this.level - 5) * 2}));
        desc.add(this.getTimeLimitDisplay(this.getDodgeTime()));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && ZSSPlayerInfo.get(player).isSkillActive(swordBasic);
    }

    @Override
    protected float getExhaustion() {
        return 0.05f;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        if (this.canUse(player)) {
            ZSSPlayerInfo.get(player).setCurrentActiveSkill(this);
            this.dodgeTimer = this.getDodgeTime();
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71020_j(this.getExhaustion());
            }
        }
        return this.isActive();
    }

    private int getDodgeTime() {
        return 5 + this.level;
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            --this.dodgeTimer;
        } else if (player.field_70170_p.field_72995_K && this.ticksTilFail > 0) {
            if (!Config.requiresDoubleTap() && !this.keyPressed.func_151470_d()) {
                this.activate(player.field_70170_p, player);
                ZSSMain.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                --this.ticksTilFail;
            }
        }
    }

    private float getBaseDodgeChance(EntityPlayer player) {
        float evadeUp = (float)ZSSEntityInfo.get((EntityLivingBase)player).getBuffAmplifier(Buff.EVADE_UP) * 0.01f;
        float evadeDown = (float)ZSSEntityInfo.get((EntityLivingBase)player).getBuffAmplifier(Buff.EVADE_DOWN) * 0.01f;
        return (float)this.level * 0.1f + evadeUp - evadeDown;
    }

    private float getTimeBonus() {
        return (float)(this.dodgeTimer + this.level - 5) * 0.02f;
    }

    private float getDodgeChance(EntityPlayer player) {
        return this.getBaseDodgeChance(player) + this.getTimeBonus();
    }

    public boolean dodgeAttack(EntityPlayer player) {
        if (player.field_70170_p.field_73012_v.nextFloat() < this.getDodgeChance(player)) {
            PlayerUtils.playRandomizedSound(player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(KeyBinding key, EntityPlayer player) {
        if (!this.isActive()) {
            if (Config.requiresDoubleTap() && this.ticksTilFail > 0 && key == this.keyPressed) {
                this.activate(player.field_70170_p, player);
                ZSSMain.dispatcher.sendToServer(new ActivateSkillPacket(this));
                this.ticksTilFail = 0;
            } else {
                this.keyPressed = key;
                this.ticksTilFail = Config.requiresDoubleTap() ? 6 : 3;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRenderTick(EntityPlayer player) {
        if (this.dodgeTimer > this.level) {
            double d = 0.05;
            if (player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() == ZSSItems.bootsHeavy) {
                d = 0.01;
            }
            Vec3 vec3 = player.func_70040_Z();
            if (this.keyPressed == ZSSKeyHandler.keys[4] || Config.allowVanillaControls() && this.keyPressed == Minecraft.func_71410_x().field_71474_y.field_74366_z) {
                player.func_70024_g(-vec3.field_72449_c * d, 0.0, vec3.field_72450_a * d);
            } else {
                player.func_70024_g(vec3.field_72449_c * d, 0.0, -vec3.field_72450_a * d);
            }
            return true;
        }
        return false;
    }
}

