/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.IDashItem;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class Dash
extends SkillActive {
    private boolean isActive = false;
    private double distance;
    private Entity target;

    public Dash(String name) {
        super(name);
        this.setDisablesLMB();
    }

    private Dash(Dash skill) {
        super(skill);
    }

    @Override
    public Dash newInstance() {
        return new Dash(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getDamageDisplay(this.getDamage(), false));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 1), (Object[])new Object[]{2 + this.level}));
        desc.add(this.getRangeDisplay(this.getRange()));
        desc.add(StatCollector.func_74837_a((String)this.getInfoString("info", 2), (Object[])new Object[]{String.format("%.1f", this.getMinDistance())}));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return player.field_70122_E && PlayerUtils.isUsingItem(player) && this.canUse(player);
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        Item item = player.func_70694_bm() != null ? player.func_70694_bm().func_77973_b() : null;
        return super.canUse(player) && !this.isActive() && (PlayerUtils.isSkillItem(item) || item instanceof IDashItem);
    }

    private int getDamage() {
        return 2 + this.level;
    }

    private double getRange() {
        return 3.0 + (double)this.level;
    }

    private double getMinDistance() {
        return 2.0 - 0.2 * (double)this.level;
    }

    private void deactivate() {
        this.isActive = false;
        this.distance = 0.0;
    }

    @Override
    protected float getExhaustion() {
        return 1.0f - 0.1f * (float)this.level;
    }

    @Override
    public boolean activate(World world, EntityPlayer player) {
        this.isActive = super.activate(world, player);
        if (this.isActive) {
            ILockOnTarget skill = ZSSPlayerInfo.get(player).getTargetingSkill();
            this.target = skill != null && skill.isLockedOn() ? skill.getCurrentTarget() : TargetUtils.acquireLookTarget((EntityLivingBase)player, (int)this.getRange(), this.getRange(), true);
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isActive()) {
            if (this.target instanceof EntityLivingBase) {
                double d0 = this.target.field_70165_t - player.field_70165_t;
                double d1 = this.target.field_70163_u + (double)(this.target.field_70131_O / 3.0f) - player.field_70163_u;
                double d2 = this.target.field_70161_v - player.field_70161_v;
                Vec3 vec3 = player.field_70170_p.func_82732_R().func_72345_a(d0, d1, d2).func_72432_b();
                float f = 1.0f;
                if (player.func_82169_q(0) != null) {
                    if (player.func_82169_q(0).func_77973_b() == ZSSItems.bootsPegasus) {
                        f = 1.5f;
                    } else if (player.func_82169_q(0).func_77973_b() == ZSSItems.bootsHeavy) {
                        f = 0.2f;
                    }
                }
                player.func_70024_g(vec3.field_72450_a * (double)f, 0.0, vec3.field_72449_c * (double)f);
                this.distance += vec3.func_72433_c();
                if (f > 0.5f && this.target.func_70068_e((Entity)player) <= 9.0) {
                    if (this.distance > this.getMinDistance()) {
                        this.target.func_70097_a(DamageUtils.causeNonSwordDamage((Entity)player), (float)this.getDamage() * f);
                        this.target.func_70024_g(vec3.field_72450_a * (double)f * (0.2 + 0.1 * (double)this.level), 0.1 + (double)f * ((double)this.level * 0.025), vec3.field_72449_c * (double)f * (0.2 + 0.1 * (double)this.level));
                    }
                    player.field_70179_y = 0.0;
                    player.field_70159_w = 0.0;
                    player.func_70024_g(-vec3.field_72450_a, 0.0, -vec3.field_72449_c);
                    WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:slam", 0.4f, 0.5f);
                    this.deactivate();
                }
                if (this.distance > this.getRange()) {
                    this.deactivate();
                }
            } else {
                this.deactivate();
            }
        }
    }
}

