/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills.sword;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.ActivateSkillPacket;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.sword.SwordBasic;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ArmorBreak
extends SkillActive {
    private int activeTimer = 0;
    private int charge = 0;
    private boolean buttonState = false;

    public ArmorBreak(String name) {
        super(name);
        this.setDisablesLMB();
        this.disableUserActivation();
    }

    private int getChargeTime(EntityPlayer player) {
        return (PlayerUtils.isHoldingMasterSword(player) ? 15 : 20) - this.level;
    }

    public boolean isCharging(EntityPlayer player) {
        ILockOnTarget target = ZSSPlayerInfo.get(player).getTargetingSkill();
        return this.charge > 0 && target != null && target.isLockedOn();
    }

    private ArmorBreak(ArmorBreak skill) {
        super(skill);
    }

    @Override
    public ArmorBreak newInstance() {
        return new ArmorBreak(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
        desc.add(this.getChargeDisplay(this.getChargeTime(player)));
        desc.add(this.getExhaustionDisplay(this.getExhaustion()));
    }

    @Override
    public boolean isActive() {
        return this.activeTimer > 0;
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return super.canUse(player) && !this.isActive() && PlayerUtils.isHoldingSkillItem(player);
    }

    @Override
    protected float getExhaustion() {
        return 2.0f - 0.1f * (float)this.level;
    }

    @SideOnly(value=Side.CLIENT)
    public void keyPressed(EntityPlayer player, boolean state) {
        this.buttonState = state;
        this.charge = this.isKeyPressed() ? this.getChargeTime(player) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isKeyPressed() {
        return ZSSKeyHandler.keys[2].func_151470_d() || Config.allowVanillaControls() && this.buttonState;
    }

    @Override
    public boolean trigger(World world, EntityPlayer player) {
        if (super.trigger(world, player)) {
            this.activeTimer = 1;
            ILockOnTarget skill = ZSSPlayerInfo.get(player).getTargetingSkill();
            if (skill != null && skill.isLockedOn()) {
                player.func_71059_n(skill.getCurrentTarget());
            }
        }
        return this.isActive();
    }

    @Override
    public void onUpdate(EntityPlayer player) {
        if (this.isCharging(player)) {
            if (this.isKeyPressed() && PlayerUtils.isHoldingSkillItem(player)) {
                if (!player.field_82175_bq) {
                    if (this.charge < this.getChargeTime(player) - 1) {
                        Minecraft.func_71410_x().field_71442_b.func_78769_a(player, player.field_70170_p, player.func_70694_bm());
                    }
                    --this.charge;
                }
                if (this.charge == 0) {
                    this.buttonState = false;
                    player.field_70724_aR = 4;
                    player.func_71038_i();
                    SwordBasic skill = (SwordBasic)ZSSPlayerInfo.get(player).getPlayerSkill(swordBasic);
                    if (skill != null && skill.onAttack(player)) {
                        ZSSMain.dispatcher.sendToServer(new ActivateSkillPacket(this, true));
                    }
                }
            } else {
                this.buttonState = false;
                this.charge = 0;
            }
        }
        if (this.isActive()) {
            --this.activeTimer;
        }
    }

    public void onImpact(EntityPlayer player, LivingHurtEvent event) {
        this.activeTimer = 0;
        WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:armorbreak", 0.4f, 0.5f);
        DirtyEntityAccessor.damageEntity(event.entityLiving, DamageUtils.causeArmorBreakDamage((Entity)player), event.ammount);
        event.ammount = 0.0f;
    }
}

