/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.network.SyncSkillPacket;
import zeldaswordskills.skills.BonusHeart;
import zeldaswordskills.skills.sword.ArmorBreak;
import zeldaswordskills.skills.sword.Dash;
import zeldaswordskills.skills.sword.Dodge;
import zeldaswordskills.skills.sword.EndingBlow;
import zeldaswordskills.skills.sword.LeapingBlow;
import zeldaswordskills.skills.sword.MortalDraw;
import zeldaswordskills.skills.sword.Parry;
import zeldaswordskills.skills.sword.RisingCut;
import zeldaswordskills.skills.sword.SpinAttack;
import zeldaswordskills.skills.sword.SwordBasic;
import zeldaswordskills.skills.sword.SwordBeam;
import zeldaswordskills.skills.sword.SwordBreak;
import zeldaswordskills.util.LogHelper;

public abstract class SkillBase {
    public static final byte MAX_LEVEL = 5;
    private static byte skillIndex = 0;
    private static final Map<Byte, SkillBase> skillsMap = new HashMap<Byte, SkillBase>();
    public static final SkillBase swordBasic = new SwordBasic("swordbasic").addDescriptions(1);
    public static final SkillBase armorBreak = new ArmorBreak("armorbreak").addDescriptions(1);
    public static final SkillBase dodge = new Dodge("dodge").addDescriptions(1);
    public static final SkillBase leapingBlow = new LeapingBlow("leapingblow").addDescriptions(1);
    public static final SkillBase parry = new Parry("parry").addDescriptions(1);
    public static final SkillBase dash = new Dash("dash").addDescriptions(1);
    public static final SkillBase spinAttack = new SpinAttack("spinattack").addDescriptions(1);
    public static final SkillBase superSpinAttack = new SpinAttack("superspinattack").addDescriptions(1);
    public static final SkillBase swordBeam = new SwordBeam("swordbeam").addDescriptions(1);
    public static final SkillBase swordBreak = new SwordBreak("swordbreak").addDescriptions(1);
    public static final SkillBase mortalDraw = new MortalDraw("mortaldraw").addDescriptions(1);
    public static final SkillBase bonusHeart = new BonusHeart("bonusheart").addDescriptions(1);
    public static final SkillBase risingCut = new RisingCut("risingcut").addDescriptions(1);
    public static final SkillBase endingBlow = new EndingBlow("endingblow").addDescriptions(1);
    private final String unlocalizedName;
    private final byte id;
    protected byte level = 0;
    private final List<String> tooltip = new ArrayList<String>();

    protected SkillBase(String name, boolean register) {
        this.unlocalizedName = name;
        byte by = skillIndex;
        skillIndex = (byte)(by + 1);
        this.id = by;
        if (register) {
            if (skillsMap.containsKey(this.id)) {
                LogHelper.log(Level.WARNING, "CONFLICT @ skill " + this.id + " id already occupied by " + SkillBase.skillsMap.get((Object)Byte.valueOf((byte)this.id)).unlocalizedName + " while adding " + name);
            }
            skillsMap.put(this.id, this);
        }
    }

    protected SkillBase(SkillBase skill) {
        this.unlocalizedName = skill.unlocalizedName;
        this.id = skill.id;
        this.tooltip.addAll(skill.tooltip);
    }

    public static final boolean doesSkillExist(int id) {
        return id >= 0 && id <= 127 && skillsMap.containsKey((byte)id);
    }

    public static final SkillBase getNewSkillInstance(byte id) {
        return skillsMap.containsKey(id) ? skillsMap.get(id).newInstance() : null;
    }

    public static final SkillBase getSkill(int id) {
        return SkillBase.doesSkillExist(id) ? skillsMap.get((byte)id) : null;
    }

    public static final Collection<SkillBase> getSkills() {
        return skillsMap.values();
    }

    public static final int getNumSkills() {
        return skillsMap.size();
    }

    public static final SkillBase createLeveledSkill(int id, byte level) {
        if (SkillBase.doesSkillExist(id) && level > 0) {
            SkillBase skill = SkillBase.getNewSkillInstance((byte)id);
            byte by = level > skill.getMaxLevel() ? skill.getMaxLevel() : level;
            skill.level = by;
            return skill;
        }
        return null;
    }

    public int hashCode() {
        return 31 * (31 + this.id) + this.level;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SkillBase skill = (SkillBase)obj;
        return skill.id == this.id && skill.level == this.level;
    }

    public abstract SkillBase newInstance();

    public final String getDisplayName() {
        return StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".name"));
    }

    public final String getUnlocalizedName() {
        return "skill.zss." + this.unlocalizedName;
    }

    public String getIconTexture() {
        return "zeldaswordskills:skillorb_" + this.unlocalizedName;
    }

    public boolean canDrop() {
        return true;
    }

    public boolean isLoot() {
        return true;
    }

    public final byte getId() {
        return this.id;
    }

    public final byte getLevel() {
        return this.level;
    }

    public byte getMaxLevel() {
        return 5;
    }

    protected final String getInfoString(String label, int n) {
        return this.getUnlocalizedName() + ".desc." + label + (n < 0 ? "" : "." + n);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> desc, EntityPlayer player) {
    }

    protected final SkillBase addDescription(String string) {
        this.tooltip.add(string);
        return this;
    }

    protected final SkillBase addDescription(List<String> list) {
        for (String s : list) {
            this.tooltip.add(s);
        }
        return this;
    }

    protected final SkillBase addDescriptions(int n) {
        for (int i = 1; i <= n; ++i) {
            this.tooltip.add(this.getInfoString("tooltip", i));
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getTranslatedTooltip(EntityPlayer player) {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (String s : this.tooltip) {
            desc.add(StatCollector.func_74838_a((String)s));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            this.addInformation(desc, player);
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<String> getDescription() {
        ArrayList<String> desc = new ArrayList<String>(this.tooltip.size());
        for (String s : this.tooltip) {
            desc.add(StatCollector.func_74838_a((String)s));
        }
        return desc;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getDescription(EntityPlayer player) {
        List<String> desc = this.getDescription();
        this.addInformation(desc, player);
        return desc;
    }

    public String getActivationDisplay() {
        return StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".desc.activate"));
    }

    public String getAreaDisplay(double area) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.area", (Object[])new Object[]{String.format("%.1f", area)});
    }

    public String getChargeDisplay(int chargeTime) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.charge", (Object[])new Object[]{chargeTime});
    }

    public String getDamageDisplay(float damage, boolean displayPlus) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.damage", (Object[])new Object[]{displayPlus ? "+" : "", String.format("%.1f", Float.valueOf(damage))});
    }

    public String getDamageDisplay(int damage, boolean displayPlus) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.damage", (Object[])new Object[]{displayPlus ? "+" : "", damage});
    }

    public String getDurationDisplay(int duration, boolean inTicks) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.duration", (Object[])new Object[]{inTicks ? duration : duration / 20, inTicks ? StatCollector.func_74838_a((String)"skill.zss.ticks") : StatCollector.func_74838_a((String)"skill.zss.seconds")});
    }

    public String getExhaustionDisplay(float exhaustion) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.exhaustion", (Object[])new Object[]{String.format("%.2f", Float.valueOf(exhaustion))});
    }

    public String getFullDescription() {
        return StatCollector.func_74838_a((String)(this.getUnlocalizedName() + ".desc.full"));
    }

    public String getLevelDisplay(boolean simpleMax) {
        return simpleMax && this.level == this.getMaxLevel() ? StatCollector.func_74838_a((String)"skill.zss.level.max") : StatCollector.func_74837_a((String)"skill.zss.desc.level", (Object[])new Object[]{this.level, this.getMaxLevel()});
    }

    public String getRangeDisplay(double range) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.range", (Object[])new Object[]{String.format("%.1f", range)});
    }

    public String getTimeLimitDisplay(int time) {
        return StatCollector.func_74837_a((String)"skill.zss.desc.time", (Object[])new Object[]{time});
    }

    protected boolean canIncreaseLevel(EntityPlayer player, int targetLevel) {
        return this.level + 1 == targetLevel && targetLevel <= this.getMaxLevel();
    }

    protected abstract void levelUp(EntityPlayer var1);

    public void validateSkill(EntityPlayer player) {
        this.levelUp(player);
    }

    public final boolean grantSkill(EntityPlayer player) {
        return this.grantSkill(player, this.level + 1);
    }

    public final boolean grantSkill(EntityPlayer player, int targetLevel) {
        if (targetLevel <= this.level || targetLevel > this.getMaxLevel()) {
            return false;
        }
        byte oldLevel = this.level;
        while (this.level < targetLevel && this.canIncreaseLevel(player, this.level + 1)) {
            this.level = (byte)(this.level + 1);
            this.levelUp(player);
        }
        if (!player.field_70170_p.field_72995_K && oldLevel < this.level) {
            ZSSMain.dispatcher.sendTo(new SyncSkillPacket(this), (EntityPlayerMP)player);
        }
        return oldLevel < this.level;
    }

    public void onUpdate(EntityPlayer player) {
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract SkillBase loadFromNBT(NBTTagCompound var1);
}

