/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.skills;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.network.ActivateSkillPacket;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

public abstract class SkillActive
extends SkillBase {
    private boolean allowUserActivation = true;
    private boolean disablesLMB = false;

    protected SkillActive(String name) {
        super(name, true);
    }

    protected SkillActive(SkillActive skill) {
        super(skill);
        this.allowUserActivation = skill.allowUserActivation;
        this.disablesLMB = skill.disablesLMB;
    }

    public abstract boolean isActive();

    protected abstract float getExhaustion();

    public boolean activate(World world, EntityPlayer player) {
        return this.allowUserActivation ? this.trigger(world, player) : false;
    }

    public boolean trigger(World world, EntityPlayer player) {
        if (this.canUse(player)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71020_j(this.getExhaustion());
            }
            if (!world.field_72995_K) {
                ZSSMain.dispatcher.sendTo(new ActivateSkillPacket(this), (EntityPlayerMP)player);
            } else if (this.disablesLMB) {
                ZSSPlayerInfo.get(player).setCurrentActiveSkill(this);
            }
            return true;
        }
        if (this.level > 0) {
            PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.skill.use.fail", (Object[])new Object[]{this.getDisplayName()}));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canExecute(EntityPlayer player) {
        return true;
    }

    public boolean canUse(EntityPlayer player) {
        return this.level > 0 && player.func_71024_bL().func_75116_a() > 0;
    }

    protected SkillActive disableUserActivation() {
        this.allowUserActivation = false;
        return this;
    }

    protected SkillActive setDisablesLMB() {
        this.disablesLMB = true;
        return this;
    }

    @Override
    protected void levelUp(EntityPlayer player) {
    }

    @Override
    public final void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("id", this.getId());
        compound.func_74774_a("level", this.level);
    }

    @Override
    public final void readFromNBT(NBTTagCompound compound) {
        this.level = compound.func_74771_c("level");
    }

    @Override
    public final SkillActive loadFromNBT(NBTTagCompound compound) {
        SkillActive skill = (SkillActive)SkillActive.getNewSkillInstance(compound.func_74771_c("id"));
        skill.readFromNBT(compound);
        return skill;
    }
}

