/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.BuffBase;
import zeldaswordskills.network.AbstractPacket;

public class UpdateBuffPacket
extends AbstractPacket {
    private BuffBase buff;
    private boolean remove;

    public UpdateBuffPacket() {
    }

    public UpdateBuffPacket(BuffBase buff, boolean remove) {
        this.buff = buff;
        this.remove = remove;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.buff.writeToNBT(new NBTTagCompound()));
        buffer.writeBoolean(this.remove);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.buff = BuffBase.readFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        this.remove = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (this.remove) {
            ZSSEntityInfo.get((EntityLivingBase)player).getActiveBuffsMap().remove((Object)this.buff.getBuff());
        } else {
            ZSSEntityInfo.get((EntityLivingBase)player).getActiveBuffsMap().put(this.buff.getBuff(), this.buff);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

