/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import zeldaswordskills.block.tileentity.TileEntityPedestal;
import zeldaswordskills.network.AbstractPacket;

public class SwordPedestalPacket
extends AbstractPacket {
    private int posX;
    private int posY;
    private int posZ;
    private ItemStack sword = null;
    private byte orientation = 0;

    public SwordPedestalPacket() {
    }

    public SwordPedestalPacket(int x, int y, int z, ItemStack stack, byte o) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.sword = stack;
        this.orientation = o;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
        buffer.writeBoolean(this.sword != null);
        if (this.sword != null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.sword.func_77955_b(new NBTTagCompound()));
            buffer.writeByte((int)this.orientation);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.posX = buffer.readInt();
        this.posY = buffer.readInt();
        this.posZ = buffer.readInt();
        if (buffer.readBoolean()) {
            this.sword = ItemStack.func_77949_a((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buffer));
            this.orientation = buffer.readByte();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(this.posX, this.posY, this.posZ);
        if (te instanceof TileEntityPedestal) {
            ((TileEntityPedestal)te).setSword(this.sword, this.orientation);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

