/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.client.render.item.RenderBigItem;
import zeldaswordskills.client.render.item.RenderHeldItemBlock;
import zeldaswordskills.client.render.item.RenderItemBomb;
import zeldaswordskills.client.render.item.RenderItemBombBag;
import zeldaswordskills.client.render.item.RenderItemCustomBow;
import zeldaswordskills.client.render.item.RenderItemDungeonBlock;
import zeldaswordskills.client.render.item.RenderItemShield;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityChu;
import zeldaswordskills.entity.EntityKeese;
import zeldaswordskills.entity.EntityOctorok;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemArmorBoots;
import zeldaswordskills.item.ItemArmorTunic;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ItemBoomerang;
import zeldaswordskills.item.ItemBrokenSword;
import zeldaswordskills.item.ItemChuJelly;
import zeldaswordskills.item.ItemCustomEgg;
import zeldaswordskills.item.ItemCustomVariantEgg;
import zeldaswordskills.item.ItemDekuLeaf;
import zeldaswordskills.item.ItemDoorLocked;
import zeldaswordskills.item.ItemFairyBottle;
import zeldaswordskills.item.ItemHammer;
import zeldaswordskills.item.ItemHeldBlock;
import zeldaswordskills.item.ItemHeroBow;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.item.ItemHookShotUpgrade;
import zeldaswordskills.item.ItemKeyBig;
import zeldaswordskills.item.ItemMagicMirror;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemMiscZSS;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ItemPickupOnly;
import zeldaswordskills.item.ItemPowerGauntlets;
import zeldaswordskills.item.ItemSkillOrb;
import zeldaswordskills.item.ItemSlingshot;
import zeldaswordskills.item.ItemSpiritCrystal;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ItemZeldaPotion;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.lib.Config;
import zeldaswordskills.skills.SkillBase;

public class ZSSItems {
    private static boolean enableGrassArrowDrop;
    private static boolean enableGrassBombDrop;
    private static boolean enableGrassEmeraldDrop;
    private static boolean enableBombLoot;
    private static boolean enableBombBagLoot;
    private static boolean enableHeartLoot;
    private static boolean allowGoldSmelting;
    private static boolean enableStartingGear;
    private static boolean enableAutoEquip;
    private static boolean enableOrb;
    private static boolean enableFullSet;
    private static boolean enableTunic;
    private static boolean enableSword;
    private static final List<ItemStack> grassDrops;
    public static final ItemArmor.ArmorMaterial WOOD;
    public static Item skillOrb;
    public static Item skillWiper;
    public static Item bomb;
    public static Item bombBag;
    public static Item boomerang;
    public static Item boomerangMagic;
    public static Item crystalSpirit;
    public static Item crystalDin;
    public static Item crystalFarore;
    public static Item crystalNayru;
    public static Item dekuLeaf;
    public static Item dekuNut;
    public static Item doorLocked;
    public static Item fairyBottle;
    public static Item gauntletsSilver;
    public static Item gauntletsGolden;
    public static Item hammer;
    public static Item hammerSkull;
    public static Item hammerMegaton;
    public static Item heartPiece;
    public static Item heldBlock;
    public static Item heroBow;
    public static Item hookshot;
    public static Item hookshotAddon;
    public static Item jellyChu;
    public static Item keyBig;
    public static Item keySkeleton;
    public static Item keySmall;
    public static Item magicMirror;
    public static Item masterOre;
    public static Item pendant;
    public static Item potionRed;
    public static Item potionGreen;
    public static Item potionBlue;
    public static Item potionYellow;
    public static Item powerPiece;
    public static Item rocsFeather;
    public static Item rodFire;
    public static Item rodIce;
    public static Item rodTornado;
    public static Item slingshot;
    public static Item scattershot;
    public static Item supershot;
    public static Item smallHeart;
    public static Item throwingRock;
    public static Item treasure;
    public static Item tunicHeroHelm;
    public static Item tunicHeroChest;
    public static Item tunicHeroLegs;
    public static Item tunicHeroBoots;
    public static Item tunicGoronHelm;
    public static Item tunicGoronChest;
    public static Item tunicGoronLegs;
    public static Item tunicZoraHelm;
    public static Item tunicZoraChest;
    public static Item tunicZoraLegs;
    public static Item bootsHeavy;
    public static Item bootsHover;
    public static Item bootsPegasus;
    public static Item bootsRubber;
    public static Item swordBroken;
    public static Item swordKokiri;
    public static Item swordOrdon;
    public static Item swordGiant;
    public static Item swordBiggoron;
    public static Item swordMaster;
    public static Item swordTempered;
    public static Item swordGolden;
    public static Item swordMasterTrue;
    public static Item shieldDeku;
    public static Item shieldHylian;
    public static Item shieldMirror;
    public static Item maskBlast;
    public static Item maskBunny;
    public static Item maskCouples;
    public static Item maskGerudo;
    public static Item maskGiants;
    public static Item maskGibdo;
    public static Item maskHawkeye;
    public static Item maskKeaton;
    public static Item maskScents;
    public static Item maskSkull;
    public static Item maskSpooky;
    public static Item maskStone;
    public static Item maskTruth;
    public static Item maskDeku;
    public static Item maskGoron;
    public static Item maskZora;
    public static Item maskFierce;
    public static Item maskMajora;
    public static Item arrowBomb;
    public static Item arrowBombWater;
    public static Item arrowBombFire;
    public static Item arrowFire;
    public static Item arrowIce;
    public static Item arrowLight;
    public static Item eggSpawner;
    public static Item eggChu;
    public static Item eggKeese;
    public static Item eggOctorok;

    public static void init(Configuration config) {
        enableGrassArrowDrop = config.get("Drops", "Enable arrow drops from grass (must use sword)", true).getBoolean(true);
        enableGrassBombDrop = config.get("Drops", "Enable bomb drops from grass (must use sword)", false).getBoolean(false);
        enableGrassEmeraldDrop = config.get("Drops", "Enable emerald drops from grass (must use sword)", true).getBoolean(true);
        enableBombLoot = config.get("Loot", "Enable bombs in vanilla chests", false).getBoolean(false);
        enableBombBagLoot = config.get("Loot", "Enable bomb bags in vanilla chests", false).getBoolean(false);
        enableHeartLoot = config.get("Loot", "Enable heart pieces in vanilla chests", false).getBoolean(false);
        allowGoldSmelting = config.get("Recipes", "Smelt all those disarmed pigmen swords into gold ingots", false).getBoolean(false);
        enableStartingGear = config.get("Bonus Gear", "Enable bonus starting equipment", false).getBoolean(false);
        enableAutoEquip = config.get("Bonus Gear", "Automatically equip starting equipment", true).getBoolean(true);
        enableOrb = config.get("Bonus Gear", "Grants a single Basic Sword skill orb", true).getBoolean(true);
        enableFullSet = config.get("Bonus Gear", "Grants a full set of Kokiri clothing: hat, tunic, trousers, boots", true).getBoolean(true);
        enableTunic = config.get("Bonus Gear", "Grants only a Kokiri Tunic (if full set is disabled)", true).getBoolean(true);
        enableSword = config.get("Bonus Gear", "Grants a Kokiri sword (a named wooden sword)", true).getBoolean(true);
    }

    public static void load() {
        ZSSItems.loadItems();
        ZSSItems.registerItems();
        ItemChuJelly.initializeJellies();
        ItemHeroBow.initializeArrows();
        ItemSlingshot.initializeSeeds();
        ZSSItems.registerRecipes();
        ZSSItems.registerDungeonLoot();
        TradeHandler.registerTrades();
        ZSSItems.addGrassDrops();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)bomb, (IItemRenderer)new RenderItemBomb());
        MinecraftForgeClient.registerItemRenderer((Item)bombBag, (IItemRenderer)new RenderItemBombBag());
        MinecraftForgeClient.registerItemRenderer((Item)hammer, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)hammerMegaton, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)hammerSkull, (IItemRenderer)new RenderBigItem(1.0f));
        MinecraftForgeClient.registerItemRenderer((Item)swordBiggoron, (IItemRenderer)new RenderBigItem(0.75f));
        MinecraftForgeClient.registerItemRenderer((Item)swordGiant, (IItemRenderer)new RenderBigItem(0.75f));
        MinecraftForgeClient.registerItemRenderer((Item)heroBow, (IItemRenderer)new RenderItemCustomBow());
        MinecraftForgeClient.registerItemRenderer((Item)shieldDeku, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)shieldHylian, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)shieldMirror, (IItemRenderer)new RenderItemShield());
        MinecraftForgeClient.registerItemRenderer((Item)heldBlock, (IItemRenderer)new RenderHeldItemBlock());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ZSSBlocks.dungeonCore), (IItemRenderer)new RenderItemDungeonBlock());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ZSSBlocks.dungeonStone), (IItemRenderer)new RenderItemDungeonBlock());
    }

    private static void addGrassDrops() {
        for (int i = 0; i < 10; ++i) {
            grassDrops.add(new ItemStack(smallHeart));
            if (enableGrassArrowDrop && i % 3 == 2) {
                grassDrops.add(new ItemStack(Items.field_151032_g));
            }
            if (i % 3 != 0) continue;
            grassDrops.add(new ItemStack(dekuNut));
        }
        if (enableGrassBombDrop) {
            grassDrops.add(new ItemStack(bomb));
        }
        if (enableGrassEmeraldDrop) {
            grassDrops.add(new ItemStack(Items.field_151166_bC));
        }
    }

    public static ItemStack getRandomGrassDrop(Random rand) {
        return grassDrops.get(rand.nextInt(grassDrops.size()));
    }

    public static boolean grantBonusGear(EntityPlayer player) {
        if (!enableStartingGear) {
            return false;
        }
        if (enableSword) {
            player.field_71071_by.func_70441_a(new ItemStack(swordKokiri));
        }
        if (enableOrb) {
            player.field_71071_by.func_70441_a(new ItemStack(skillOrb, 1, (int)SkillBase.swordBasic.getId()));
        }
        if (enableFullSet) {
            ItemStack[] set = new ItemStack[]{new ItemStack(tunicHeroBoots), new ItemStack(tunicHeroLegs), new ItemStack(tunicHeroChest), new ItemStack(tunicHeroHelm)};
            for (int i = 0; i < set.length; ++i) {
                if (enableAutoEquip && player.func_82169_q(i) == null) {
                    player.func_70062_b(i + 1, set[i]);
                    continue;
                }
                player.field_71071_by.func_70441_a(set[i]);
            }
        } else if (enableTunic) {
            if (enableAutoEquip && player.func_82169_q(3) == null) {
                player.func_70062_b(3, new ItemStack(tunicHeroChest));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(tunicHeroChest));
            }
        }
        return true;
    }

    private static void loadItems() {
        skillOrb = new ItemSkillOrb().func_77655_b("zss.skillorb");
        heartPiece = new ItemMiscZSS(12).func_77655_b("zss.heartpiece");
        skillWiper = new ItemMiscZSS(0).func_77655_b("zss.skill_wiper");
        tunicHeroHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.hero_tunic_helm");
        tunicHeroChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).func_77655_b("zss.hero_tunic_chest");
        tunicHeroLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.hero_tunic_legs");
        tunicGoronHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.goron_tunic_helm");
        tunicGoronChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).func_77655_b("zss.goron_tunic_chest");
        tunicGoronLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.goron_tunic_legs");
        tunicZoraHelm = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 0).func_77655_b("zss.zora_tunic_helm");
        tunicZoraChest = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 1).setEffect(new PotionEffect(Potion.field_76427_o.func_76396_c(), 90, 0)).func_77655_b("zss.zora_tunic_chest");
        tunicZoraLegs = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 2).func_77655_b("zss.zora_tunic_legs");
        tunicHeroBoots = new ItemArmorTunic(ZSSMain.proxy.addArmor("tunic"), 3).func_77655_b("zss.hero_tunic_boots");
        bootsHeavy = new ItemArmorBoots(ItemArmor.ArmorMaterial.IRON, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_heavy");
        bootsHover = new ItemArmorBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_hover");
        bootsPegasus = new ItemArmorBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_pegasus");
        bootsRubber = new ItemArmorBoots(ItemArmor.ArmorMaterial.CHAIN, ZSSMain.proxy.addArmor("boots")).func_77655_b("zss.boots_rubber");
        shieldDeku = new ItemZeldaShield(30, 3.0f, 5.0f).func_77655_b("zss.shield_deku");
        shieldHylian = new ItemZeldaShield(18, 5.0f, 3.5f).func_77655_b("zss.shield_hylian");
        shieldMirror = new ItemZeldaShield(24, 4.0f, 4.0f).func_77655_b("zss.shield_mirror");
        swordKokiri = new ItemZeldaSword(Item.ToolMaterial.IRON, -1.0f).func_77655_b("zss.sword_kokiri").func_77656_e(256);
        swordOrdon = new ItemZeldaSword(Item.ToolMaterial.IRON, 1.0f).func_77655_b("zss.sword_ordon").func_77656_e(512);
        swordGiant = new ItemZeldaSword(Item.ToolMaterial.IRON, 6.0f, true).func_77655_b("zss.sword_giant").func_77656_e(32);
        swordBiggoron = new ItemZeldaSword(Item.ToolMaterial.IRON, 6.0f, true).setNoItemOnBreak().func_77655_b("zss.sword_biggoron").func_77656_e(0);
        swordMaster = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 2.0f).setMasterSword().func_77655_b("zss.sword_master").func_77656_e(0);
        swordTempered = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 4.0f).setMasterSword().func_77655_b("zss.sword_tempered").func_77656_e(0);
        swordGolden = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 6.0f).setMasterSword().func_77655_b("zss.sword_golden").func_77656_e(0);
        swordMasterTrue = new ItemZeldaSword(Item.ToolMaterial.EMERALD, 8.0f).setMasterSword().func_77655_b("zss.sword_master_true").func_77656_e(0);
        swordBroken = new ItemBrokenSword().func_77655_b("zss.sword_broken");
        hammer = new ItemHammer(BlockWeight.VERY_LIGHT, 8.0f, 50.0f).func_77655_b("zss.hammer");
        hammerSkull = new ItemHammer(BlockWeight.MEDIUM, 12.0f, 50.0f).func_77655_b("zss.hammer_skull");
        hammerMegaton = new ItemHammer(BlockWeight.VERY_HEAVY, 16.0f, 50.0f).func_77655_b("zss.hammer_megaton");
        boomerang = new ItemBoomerang(4.0f, 12).func_77655_b("zss.boomerang");
        boomerangMagic = new ItemBoomerang(6.0f, 24).setCaptureAll().func_77655_b("zss.boomerang_magic");
        heroBow = new ItemHeroBow().func_77655_b("zss.bow_hero");
        arrowBomb = new Item().func_77655_b("zss.arrow_bomb").func_111206_d("zeldaswordskills:arrow_bomb").func_77637_a(ZSSCreativeTabs.tabCombat);
        arrowBombFire = new Item().func_77655_b("zss.arrow_bomb_fire").func_111206_d("zeldaswordskills:arrow_bomb_fire").func_77637_a(ZSSCreativeTabs.tabCombat);
        arrowBombWater = new Item().func_77655_b("zss.arrow_bomb_water").func_111206_d("zeldaswordskills:arrow_bomb_water").func_77637_a(ZSSCreativeTabs.tabCombat);
        arrowFire = new Item().func_77655_b("zss.arrow_fire").func_111206_d("zeldaswordskills:arrow_fire").func_77637_a(ZSSCreativeTabs.tabCombat);
        arrowIce = new Item().func_77655_b("zss.arrow_ice").func_111206_d("zeldaswordskills:arrow_ice").func_77637_a(ZSSCreativeTabs.tabCombat);
        arrowLight = new Item().func_77655_b("zss.arrow_light").func_111206_d("zeldaswordskills:arrow_light").func_77637_a(ZSSCreativeTabs.tabCombat);
        slingshot = new ItemSlingshot().func_77655_b("zss.slingshot");
        scattershot = new ItemSlingshot(3, 30.0f).func_77655_b("zss.scattershot");
        supershot = new ItemSlingshot(5, 15.0f).func_77655_b("zss.supershot");
        doorLocked = new ItemDoorLocked().func_77655_b("zss.doorlocked");
        keyBig = new ItemKeyBig().func_77655_b("zss.keybig").func_77664_n();
        keySmall = new ItemMiscZSS(6).func_77655_b("zss.keysmall").func_77664_n();
        keySkeleton = new ItemMiscZSS(32).func_77655_b("zss.keyskeleton").func_77664_n().func_77625_d(1);
        hookshot = new ItemHookShot().func_77655_b("zss.hookshot");
        hookshotAddon = new ItemHookShotUpgrade().func_77655_b("zss.hookshot.upgrade");
        bombBag = new ItemBombBag().func_77655_b("zss.bombbag");
        bomb = new ItemBomb().func_77655_b("zss.bomb");
        crystalDin = new ItemSpiritCrystal(1, 8, 16).func_77655_b("zss.spirit_crystal_din");
        crystalFarore = new ItemSpiritCrystal(2, 8, 70).func_77655_b("zss.spirit_crystal_farore");
        crystalNayru = new ItemSpiritCrystal(4, 16, 0).func_77655_b("zss.spirit_crystal_nayru");
        gauntletsSilver = new ItemPowerGauntlets(BlockWeight.MEDIUM).func_77655_b("zss.gauntlets_silver");
        gauntletsGolden = new ItemPowerGauntlets(BlockWeight.VERY_HEAVY).func_77655_b("zss.gauntlets_golden");
        magicMirror = new ItemMagicMirror().func_77655_b("zss.magicmirror");
        fairyBottle = new ItemFairyBottle().func_77655_b("zss.fairybottle");
        potionRed = new ItemZeldaPotion(0, 0.0f, 20.0f).func_77655_b("zss.potion_red");
        potionGreen = new ItemZeldaPotion(20, 40.0f, 0.0f).func_77655_b("zss.potion_green");
        potionBlue = new ItemZeldaPotion(20, 40.0f, 40.0f).func_77655_b("zss.potion_blue");
        potionYellow = new ItemZeldaPotion().setBuffEffect(Buff.RESIST_SHOCK, 6000, 100, 1.0f).func_77655_b("zss.potion_yellow");
        rodFire = new ItemMagicRod(EntityMagicSpell.MagicType.FIRE, 8.0f, 8.0f).func_77655_b("zss.rod_fire");
        rodIce = new ItemMagicRod(EntityMagicSpell.MagicType.ICE, 6.0f, 8.0f).func_77655_b("zss.rod_ice");
        rodTornado = new ItemMagicRod(EntityMagicSpell.MagicType.WIND, 4.0f, 4.0f).func_77655_b("zss.rod_tornado");
        maskBlast = new ItemMask(ItemArmor.ArmorMaterial.IRON, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_blast");
        maskBunny = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(1, 64).func_77655_b("zss.mask_bunny");
        maskCouples = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(40, 32).func_77655_b("zss.mask_couples");
        maskGerudo = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_gerudo");
        maskGiants = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_giants");
        maskGibdo = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_gibdo");
        maskHawkeye = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_hawkeye");
        maskKeaton = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(8, 16).func_77655_b("zss.mask_keaton");
        maskScents = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(32, 32).func_77655_b("zss.mask_scents");
        maskSkull = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(20, 10).func_77655_b("zss.mask_skull");
        maskSpooky = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setPrice(16, 8).func_77655_b("zss.mask_spooky");
        maskStone = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setEffect(new PotionEffect(Potion.field_76441_p.func_76396_c(), 100, 0)).func_77655_b("zss.mask_stone");
        maskTruth = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_truth");
        maskDeku = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_deku");
        maskGoron = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_goron");
        maskZora = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_zora");
        maskFierce = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).func_77655_b("zss.mask_fierce");
        maskMajora = new ItemMask(WOOD, ZSSMain.proxy.addArmor("mask")).setEffect(new PotionEffect(Potion.field_82731_v.func_76396_c(), 100, 1)).func_77655_b("zss.mask_majora");
        pendant = new ItemPendant().func_77655_b("zss.pendant");
        crystalSpirit = new ItemMiscZSS(0).func_77655_b("zss.spirit_crystal_empty").func_77625_d(1);
        masterOre = new ItemMiscZSS(24).func_77655_b("zss.masterore");
        rocsFeather = new ItemMiscZSS(12).func_77655_b("zss.rocs_feather");
        dekuLeaf = new ItemDekuLeaf().func_77655_b("zss.deku_leaf");
        dekuNut = new ItemMiscZSS(2).func_77655_b("zss.deku_nut");
        jellyChu = new ItemChuJelly().func_77655_b("zss.jelly_chu");
        treasure = new ItemTreasure().func_77655_b("zss.treasure");
        heldBlock = new ItemHeldBlock().func_77655_b("zss.held_block");
        powerPiece = new ItemPickupOnly().func_77655_b("zss.power_piece");
        smallHeart = new ItemPickupOnly().func_77655_b("zss.heart");
        throwingRock = new Item().func_77655_b("zss.throwing_rock").func_111206_d("zeldaswordskills:throwing_rock").func_77625_d(16);
        eggSpawner = new ItemCustomEgg().func_77655_b("zss.spawn_egg");
        eggChu = new ItemCustomVariantEgg(EntityChu.class, "chu").func_77655_b("zss.eggChu");
        eggKeese = new ItemCustomVariantEgg(EntityKeese.class, "keese").func_77655_b("zss.eggKeese");
        eggOctorok = new ItemCustomVariantEgg(EntityOctorok.class, "octorok").func_77655_b("zss.eggOctorok");
    }

    private static void registerItems() {
        GameRegistry.registerItem((Item)skillOrb, (String)skillOrb.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)heartPiece, (String)heartPiece.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)skillWiper, (String)skillWiper.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicHeroHelm, (String)tunicHeroHelm.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicHeroChest, (String)tunicHeroChest.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicHeroLegs, (String)tunicHeroLegs.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicGoronHelm, (String)tunicGoronHelm.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicGoronChest, (String)tunicGoronChest.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicGoronLegs, (String)tunicGoronLegs.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicZoraHelm, (String)tunicZoraHelm.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicZoraChest, (String)tunicZoraChest.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicZoraLegs, (String)tunicZoraLegs.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)tunicHeroBoots, (String)tunicHeroBoots.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)bootsHeavy, (String)bootsHeavy.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)bootsHover, (String)bootsHover.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)bootsPegasus, (String)bootsPegasus.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)bootsRubber, (String)bootsRubber.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)shieldDeku, (String)shieldDeku.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)shieldHylian, (String)shieldHylian.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)shieldMirror, (String)shieldMirror.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordKokiri, (String)swordKokiri.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordOrdon, (String)swordOrdon.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordGiant, (String)swordGiant.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordBiggoron, (String)swordBiggoron.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordMaster, (String)swordMaster.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordTempered, (String)swordTempered.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordGolden, (String)swordGolden.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordMasterTrue, (String)swordMasterTrue.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)swordBroken, (String)swordBroken.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)hammer, (String)hammer.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)hammerSkull, (String)hammerSkull.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)hammerMegaton, (String)hammerMegaton.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)boomerang, (String)boomerang.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)boomerangMagic, (String)boomerangMagic.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)heroBow, (String)heroBow.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)arrowBomb, (String)arrowBomb.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)arrowBombFire, (String)arrowBombFire.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)arrowBombWater, (String)arrowBombWater.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)arrowFire, (String)arrowFire.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)arrowIce, (String)arrowIce.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)arrowLight, (String)arrowLight.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)slingshot, (String)slingshot.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)scattershot, (String)scattershot.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)supershot, (String)supershot.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)doorLocked, (String)doorLocked.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)keyBig, (String)keyBig.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)keySmall, (String)keySmall.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)keySkeleton, (String)keySkeleton.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)hookshot, (String)hookshot.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)hookshotAddon, (String)hookshotAddon.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)bombBag, (String)bombBag.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)bomb, (String)bomb.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)crystalDin, (String)crystalDin.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)crystalFarore, (String)crystalFarore.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)crystalNayru, (String)crystalNayru.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)gauntletsSilver, (String)gauntletsSilver.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)gauntletsGolden, (String)gauntletsGolden.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)rodFire, (String)rodFire.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)rodIce, (String)rodIce.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)rodTornado, (String)rodTornado.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)magicMirror, (String)magicMirror.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)fairyBottle, (String)fairyBottle.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)potionRed, (String)potionRed.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)potionGreen, (String)potionGreen.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)potionBlue, (String)potionBlue.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)potionYellow, (String)potionYellow.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskBlast, (String)maskBlast.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskBunny, (String)maskBunny.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskCouples, (String)maskCouples.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskGerudo, (String)maskGerudo.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskGiants, (String)maskGiants.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskGibdo, (String)maskGibdo.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskHawkeye, (String)maskHawkeye.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskKeaton, (String)maskKeaton.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskScents, (String)maskScents.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskSkull, (String)maskSkull.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskSpooky, (String)maskSpooky.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskStone, (String)maskStone.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskTruth, (String)maskTruth.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskDeku, (String)maskDeku.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskGoron, (String)maskGoron.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskZora, (String)maskZora.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskFierce, (String)maskFierce.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)maskMajora, (String)maskMajora.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)pendant, (String)pendant.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)crystalSpirit, (String)crystalSpirit.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)masterOre, (String)masterOre.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)rocsFeather, (String)rocsFeather.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)dekuLeaf, (String)dekuLeaf.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)dekuNut, (String)dekuNut.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)jellyChu, (String)jellyChu.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)treasure, (String)treasure.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)heldBlock, (String)heldBlock.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)powerPiece, (String)powerPiece.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)smallHeart, (String)smallHeart.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)throwingRock, (String)throwingRock.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)eggSpawner, (String)eggSpawner.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)eggChu, (String)eggChu.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)eggKeese, (String)eggKeese.func_77658_a().substring(5));
        GameRegistry.registerItem((Item)eggOctorok, (String)eggOctorok.func_77658_a().substring(5));
    }

    private static void registerRecipes() {
        if (allowGoldSmelting) {
            FurnaceRecipes.func_77602_a().func_151396_a(Items.field_151010_B, new ItemStack(Items.field_151043_k), 0.0f);
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.pedestal, 3, 8), (Object[])new Object[]{"qqq", "qpq", "qqq", Character.valueOf('q'), Blocks.field_150371_ca, Character.valueOf('p'), new ItemStack(ZSSBlocks.pedestal, 1, 8)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(arrowBomb), (Object[])new Object[]{"b", "a", Character.valueOf('b'), new ItemStack(bomb, 1, BombType.BOMB_STANDARD.ordinal()), Character.valueOf('a'), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(arrowBombFire), (Object[])new Object[]{"b", "a", Character.valueOf('b'), new ItemStack(bomb, 1, BombType.BOMB_FIRE.ordinal()), Character.valueOf('a'), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(arrowBombWater), (Object[])new Object[]{"b", "a", Character.valueOf('b'), new ItemStack(bomb, 1, BombType.BOMB_WATER.ordinal()), Character.valueOf('a'), Items.field_151032_g});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ZSSBlocks.ceramicJar, 8), (Object[])new Object[]{"c c", "c c", " c ", Character.valueOf('c'), Items.field_151118_aC});
        GameRegistry.addRecipe((ItemStack)new ItemStack(skillOrb, 1, (int)SkillBase.bonusHeart.getId()), (Object[])new Object[]{"HH", "HH", Character.valueOf('H'), heartPiece});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicGoronHelm), (Object[])new Object[]{tunicHeroHelm, new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicGoronLegs), (Object[])new Object[]{tunicHeroLegs, new ItemStack(Items.field_151100_aR, 1, 1)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicZoraHelm), (Object[])new Object[]{tunicHeroHelm, new ItemStack(Items.field_151100_aR, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(tunicZoraLegs), (Object[])new Object[]{tunicHeroLegs, new ItemStack(Items.field_151100_aR, 1, 4)});
    }

    private static void registerDungeonLoot() {
        if (enableBombLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(bomb, 1, BombType.BOMB_STANDARD.ordinal()), 1, 3, Config.getBombWeight()), true, true);
        }
        if (enableBombBagLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(bombBag), 1, 1, Config.getBombBagWeight()), true, false);
        }
        if (enableHeartLoot) {
            ZSSItems.addLootToAll(new WeightedRandomChestContent(new ItemStack(skillOrb, 1, (int)SkillBase.bonusHeart.getId()), 1, 1, Config.getHeartWeight()), false, false);
        }
    }

    private static void addLootToAll(WeightedRandomChestContent loot, boolean smith, boolean bonus) {
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(loot);
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(loot);
        ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(loot);
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(loot);
        if (smith) {
            ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(loot);
        }
        if (bonus) {
            ChestGenHooks.getInfo((String)"bonusChest").addItem(loot);
        }
    }

    static {
        grassDrops = new ArrayList<ItemStack>();
        WOOD = EnumHelper.addArmorMaterial((String)"Wood", (int)5, (int[])new int[]{1, 3, 2, 1}, (int)5);
    }
}

