/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.ISheathed;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.shield.IArrowCatcher;
import mods.battlegear2.api.shield.IArrowDisplay;
import mods.battlegear2.api.shield.IShield;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.IDashItem;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.ISwingSpeed;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.battlegear2.api.ISheathed", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.shield.IArrowCatcher", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.shield.IArrowDisplay", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.shield.IShield", modid="battlegear2", striprefs=true)})
public class ItemZeldaShield
extends Item
implements IDashItem,
IFairyUpgrade,
ISwingSpeed,
IShield,
ISheathed,
IArrowCatcher,
IArrowDisplay {
    private final int recoveryTime;
    private final float bg2DecayRate;
    private final float bg2RecoveryRate;
    @SideOnly(value=Side.CLIENT)
    private IIcon backIcon;

    public ItemZeldaShield(int recoveryTime, float decayRate, float recoveryRate) {
        this.recoveryTime = recoveryTime;
        this.bg2DecayRate = 1.0f / decayRate / 20.0f;
        this.bg2RecoveryRate = 1.0f / recoveryRate / 20.0f;
        this.func_77664_n();
        this.func_77656_e(64);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public int getRecoveryTime() {
        return this.recoveryTime;
    }

    public boolean canBlockDamage(ItemStack shield, DamageSource source) {
        boolean flag;
        boolean bl = flag = source.func_76363_c() && !(source instanceof DamageUtils.DamageSourceArmorBreak);
        if (this == ZSSItems.shieldDeku) {
            return !flag;
        }
        return !flag || source.func_82725_o() || source.func_76347_k() || source.func_76352_a() && this == ZSSItems.shieldMirror;
    }

    public void onBlock(EntityPlayer player, ItemStack shield, DamageSource source, float damage) {
        ZSSPlayerInfo.get(player).onAttackBlocked(shield, damage);
        WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
        if (this == ZSSItems.shieldDeku) {
            int dmg;
            if (source.func_76352_a() && source.func_76364_f() instanceof IProjectile && ZSSMain.isBG2Enabled && player.func_70694_bm() == shield && shield.func_77973_b() instanceof IArrowCatcher && ((IArrowCatcher)shield.func_77973_b()).catchArrow(shield, player, (IProjectile)source.func_76364_f())) {
                ((InventoryPlayerBattle)player.field_71071_by).hasChanged = true;
            }
            if ((dmg = Math.round(source.func_76347_k() ? damage + 10.0f : damage - 2.0f)) > 0) {
                shield.func_77972_a(dmg, (EntityLivingBase)player);
                if (shield.field_77994_a <= 0) {
                    player.func_71028_bD();
                }
            }
        } else if (this == ZSSItems.shieldMirror && source.func_76352_a() && !source.func_94541_c() && source.func_76364_f() != null) {
            float f = player.field_70170_p.field_73012_v.nextFloat();
            float f2 = source.func_82725_o() ? 0.33333334f : 1.0f;
            if (f < f2) {
                Entity projectile = null;
                try {
                    projectile = (Entity)source.func_76364_f().getClass().getConstructor(World.class).newInstance(player.field_70170_p);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (projectile != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    source.func_76364_f().func_70109_d(data);
                    projectile.func_70020_e(data);
                    projectile.field_70165_t -= projectile.field_70159_w;
                    projectile.field_70163_u -= projectile.field_70181_x;
                    projectile.field_70161_v -= projectile.field_70179_y;
                    double motionX = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI));
                    double motionZ = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI));
                    double motionY = -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI));
                    TargetUtils.setEntityHeading(projectile, motionX, motionY, motionZ, 1.0f, 2.0f + 20.0f * player.field_70170_p.field_73012_v.nextFloat(), false);
                    player.field_70170_p.func_72838_d(projectile);
                }
            }
        }
    }

    @Override
    public float getExhaustion() {
        return 0.3f;
    }

    @Override
    public int getSwingSpeed() {
        return 10;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity target) {
        if (target instanceof EntityLivingBase) {
            WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
            TargetUtils.knockTargetBack((EntityLivingBase)target, (EntityLivingBase)player);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (ZSSPlayerInfo.get(player).canBlock()) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (this == ZSSItems.shieldMirror && player.func_71011_bu() != null && ZSSPlayerInfo.get(player).canBlock()) {
            Vec3 vec3 = player.func_70040_Z();
            double dx = player.field_70165_t + vec3.field_72450_a * 2.0;
            double dy = player.field_70163_u + (double)player.func_70047_e() + vec3.field_72448_b * 2.0;
            double dz = player.field_70161_v + vec3.field_72449_c * 2.0;
            List list = player.field_70170_p.func_72872_a(EntityFireball.class, AxisAlignedBB.func_72330_a((double)(dx - 1.0), (double)(dy - 1.0), (double)(dz - 1.0), (double)(dx + 1.0), (double)(dy + 1.0), (double)(dz + 1.0)));
            for (EntityFireball fireball : list) {
                DamageSource source = DamageSource.func_76362_a((EntityFireball)fireball, (Entity)fireball.field_70235_a);
                if (!this.canBlockDamage(stack, source) || !fireball.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f)) continue;
                ZSSPlayerInfo.get(player).onAttackBlocked(stack, 1.0f);
                WorldUtils.playSoundAtEntity(player.field_70170_p, (Entity)player, "zeldaswordskills:hammer", 0.4f, 0.5f);
                break;
            }
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack stack) {
        return this == ZSSItems.shieldDeku && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBackIcon() {
        return this.backIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
        this.backIcon = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + "_back");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        if (PlayerUtils.hasItem(player, ZSSItems.swordMasterTrue)) {
            item.func_70106_y();
            player.func_71029_a((StatBase)ZSSAchievements.shieldMirror);
            WorldUtils.spawnItemWithRandom(core.func_145831_w(), new ItemStack(ZSSItems.shieldMirror), core.field_145851_c, core.field_145848_d + 2, core.field_145849_e);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.fairy.laugh.sword"));
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this == ZSSItems.shieldHylian;
    }

    @Optional.Method(modid="battlegear2")
    public void setArrowCount(ItemStack stack, int count) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74777_a("arrows", (short)Math.min(count, Short.MAX_VALUE));
    }

    @Optional.Method(modid="battlegear2")
    public int getArrowCount(ItemStack stack) {
        return stack.func_77942_o() ? (int)stack.func_77978_p().func_74765_d("arrows") : 0;
    }

    @Optional.Method(modid="battlegear2")
    public boolean catchArrow(ItemStack shield, EntityPlayer player, IProjectile projectile) {
        if (this == ZSSItems.shieldDeku && projectile instanceof EntityArrow) {
            this.setArrowCount(shield, this.getArrowCount(shield) + 1);
            player.func_85034_r(player.func_85035_bI() - 1);
            ((EntityArrow)projectile).func_70106_y();
            return true;
        }
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public float getDecayRate(ItemStack shield) {
        return this.bg2DecayRate;
    }

    @Optional.Method(modid="battlegear2")
    public float getRecoveryRate(ItemStack shield) {
        return this.bg2RecoveryRate;
    }

    @Optional.Method(modid="battlegear2")
    public boolean canBlock(ItemStack shield, DamageSource source) {
        return this.canBlockDamage(shield, source);
    }

    @Optional.Method(modid="battlegear2")
    public float getDamageDecayRate(ItemStack shield, float amount) {
        return 0.0f;
    }

    @Optional.Method(modid="battlegear2")
    public float getBlockAngle(ItemStack shield) {
        return 60.0f;
    }

    @Optional.Method(modid="battlegear2")
    public int getBashTimer(ItemStack shield) {
        return 10;
    }

    @Optional.Method(modid="battlegear2")
    public void blockAnimation(EntityPlayer player, float amount) {
    }

    @Optional.Method(modid="battlegear2")
    public float getDamageReduction(ItemStack shield, DamageSource source) {
        return 0.0f;
    }
}

