/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.DirtyEntityAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.item.IZoomHelper;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityMaskTrader;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class ItemMask
extends ItemArmor
implements IZoomHelper {
    protected PotionEffect tickingEffect = null;
    private int buyPrice;
    private int sellPrice;
    public static final UUID bunnyHoodMoveBonusUUID = UUID.fromString("8412C9F7-9645-4C24-8FD1-6EFB8282E822");
    public static final AttributeModifier bunnyHoodMoveBonus = new AttributeModifier(bunnyHoodMoveBonusUUID, "Bunny Hood Speed Bonus", 0.3, 2).func_111168_a(false);

    public ItemMask(ItemArmor.ArmorMaterial material, int renderIndex) {
        super(material, renderIndex, 0);
        this.func_77656_e(0);
        this.func_77637_a(ZSSCreativeTabs.tabMasks);
    }

    public ItemMask setPrice(int buy, int sell) {
        this.buyPrice = buy;
        this.sellPrice = sell;
        return this;
    }

    public int getBuyPrice() {
        return this.buyPrice > 0 ? this.buyPrice : 16;
    }

    public int getSellPrice() {
        return this.sellPrice > 0 ? this.sellPrice : 16;
    }

    public ItemMask setEffect(PotionEffect effect) {
        this.tickingEffect = effect;
        return this;
    }

    public void explode(ItemStack stack, World world, double x, double y, double z) {
        if (this == ZSSItems.maskBlast) {
            if (this.isCooling(stack)) {
                world.func_72908_a(x, y, z, "random.click", 0.3f, 0.6f);
            } else {
                CustomExplosion.createExplosion(new EntityBomb(world), world, x, y, z, 3.0f, 10.0f, false);
                this.setCooldown(stack, 40);
            }
        }
    }

    private boolean isCooling(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0;
    }

    private void decrementCooldown(ItemStack stack) {
        stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
    }

    private void setCooldown(ItemStack stack, int time) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("cooldown", time);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMagnificationFactor() {
        return this == ZSSItems.maskHawkeye ? 3.0f : 0.0f;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        if (!info.getFlag((byte)2)) {
            info.setWearingHelm();
        }
        if (this.isCooling(stack)) {
            this.decrementCooldown(stack);
        }
        if (this.tickingEffect != null && world.func_72820_D() % 50L == 0L) {
            player.func_70690_d(new PotionEffect(this.tickingEffect));
        }
        if (this == ZSSItems.maskCouples && world.func_72820_D() % 64L == 0L) {
            List villagers = world.func_72872_a(EntityVillager.class, player.field_70121_D.func_72314_b(8.0, 3.0, 8.0));
            for (EntityVillager villager : villagers) {
                if (!(world.field_73012_v.nextFloat() < 0.5f)) continue;
                ZSSVillagerInfo.get(villager).setMating();
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (this.isCooling(stack)) {
            this.decrementCooldown(stack);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return String.format("%s:textures/armor/%s_layer_%d.png", "zeldaswordskills", this.func_77658_a().substring(9), slot == 2 ? 2 : 1);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        EntityVillager villager;
        if (!player.field_70170_p.field_72995_K && entity instanceof EntityVillager && ZSSVillagerInfo.get(villager = (EntityVillager)entity).getMaskDesired() == this) {
            ZSSVillagerInfo.get(villager).onMaskTrade();
            ZSSPlayerInfo.get(player).completeCurrentMaskStage();
            player.func_70062_b(0, new ItemStack(Items.field_151166_bC, this.getSellPrice()));
            PlayerUtils.playSound(player, "zeldaswordskills:cash_sale", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat.zss.mask.sold." + player.field_70170_p.field_73012_v.nextInt(4))));
            player.func_71029_a((StatBase)ZSSAchievements.maskSold);
        }
        return true;
    }

    public boolean onInteract(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                if (entity.getClass().isAssignableFrom(EntityVillager.class) && this == ZSSVillagerInfo.get(villager).getMaskDesired()) {
                    new TimedChatDialogue(player, Arrays.asList(StatCollector.func_74838_a((String)"chat.zss.mask.desired.0"), StatCollector.func_74837_a((String)"chat.zss.mask.desired.1", (Object[])new Object[]{this.getSellPrice()})));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat." + this.func_77658_a().substring(5) + "." + villager.func_70946_n())));
                }
            } else if (entity instanceof EntityMaskTrader) {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)("chat." + this.func_77658_a().substring(5) + ".salesman")));
            } else {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
    }

    public static void applyAttributeModifiers(ItemStack stack, EntityPlayer player) {
        ZSSEntityInfo buffInfo;
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        info.setFlag((byte)8, false);
        IAttributeInstance movement = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (movement.func_111127_a(bunnyHoodMoveBonusUUID) != null) {
            movement.func_111124_b(bunnyHoodMoveBonus);
        }
        if ((buffInfo = ZSSEntityInfo.get((EntityLivingBase)player)).isBuffPermanent(Buff.EVADE_UP)) {
            buffInfo.removeBuff(Buff.EVADE_UP);
        }
        if (buffInfo.isBuffPermanent(Buff.ATTACK_UP)) {
            buffInfo.removeBuff(Buff.ATTACK_UP);
        }
        if (player.getEntityData().func_74764_b("origWidth") && (stack == null || stack.func_77973_b() != ZSSItems.maskGiants)) {
            DirtyEntityAccessor.restoreOriginalSize((Entity)player);
            if (player.field_70170_p.field_72995_K) {
                player.field_70138_W -= 1.0f;
            }
        }
        if (stack != null && info.getFlag((byte)2)) {
            if (((ItemMask)stack.func_77973_b()).tickingEffect != null) {
                player.func_70690_d(new PotionEffect(((ItemMask)stack.func_77973_b()).tickingEffect));
            }
            if (stack.func_77973_b() == ZSSItems.maskBunny) {
                movement.func_111121_a(bunnyHoodMoveBonus);
                info.setFlag((byte)8, true);
                buffInfo.applyBuff(Buff.EVADE_UP, Integer.MAX_VALUE, 25);
            } else if (stack.func_77973_b() == ZSSItems.maskGiants) {
                DirtyEntityAccessor.setSize((Entity)player, player.field_70130_N * 3.0f, player.field_70131_O * 3.0f);
                if (player.field_70170_p.field_72995_K) {
                    player.field_70138_W += 1.0f;
                }
            } else if (stack.func_77973_b() == ZSSItems.maskMajora) {
                buffInfo.applyBuff(Buff.ATTACK_UP, Integer.MAX_VALUE, 100);
            }
        }
    }
}

