/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.projectile.EntityCyclone;
import zeldaswordskills.entity.projectile.EntityMagicSpell;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.PacketISpawnParticles;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemMagicRod
extends Item
implements IFairyUpgrade,
ISacredFlame,
ISpawnParticles {
    private final EntityMagicSpell.MagicType magicType;
    private final float damage;
    private final float fatigue;

    public ItemMagicRod(EntityMagicSpell.MagicType magicType, float damage, float fatigue) {
        this.magicType = magicType;
        this.damage = damage;
        this.fatigue = fatigue;
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    private int getCooldown(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("cooldown") : 0;
    }

    private void setCooldown(ItemStack stack, int cooldown) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("cooldown", cooldown);
    }

    private boolean hasAbsorbedFlame(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("absorbedFlame");
    }

    private boolean isUpgraded(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("isUpgraded");
    }

    public String func_77653_i(ItemStack stack) {
        String s = this.isUpgraded(stack) ? StatCollector.func_74838_a((String)"item.zss.rodmagic.nice") + " " : "";
        return s + StatCollector.func_74838_a((String)(this.func_77658_a() + ".name"));
    }

    public int func_77619_b() {
        return 0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.getCooldown(stack) == 0 && player.func_71024_bL().func_75116_a() > 0) {
            player.func_71038_i();
            if (player.func_70093_af()) {
                boolean isUpgraded = this.isUpgraded(stack);
                EntityMobThrowable magic = this.magicType == EntityMagicSpell.MagicType.WIND ? new EntityCyclone(world, (EntityLivingBase)player).setArea(this.isUpgraded(stack) ? 3.0f : 2.0f) : new EntityMagicSpell(world, (EntityLivingBase)player).setType(this.magicType).setArea(isUpgraded ? 3.0f : 2.0f);
                magic.setDamage(isUpgraded ? this.damage * 1.5f : this.damage);
                if (!world.field_72995_K) {
                    WorldUtils.playSoundAtEntity(world, (Entity)player, "zeldaswordskills:whoosh", 0.4f, 0.5f);
                    world.func_72838_d((Entity)magic);
                }
                player.func_71020_j(this.fatigue);
                if (!player.field_71075_bZ.field_75098_d) {
                    this.setCooldown(stack, 30);
                }
            } else {
                player.func_71020_j(this.fatigue / 8.0f);
                player.func_71008_a(stack, this.func_77626_a(stack));
                if (this == ZSSItems.rodTornado) {
                    ZSSPlayerInfo.get((EntityPlayer)player).reduceFallAmount = ZSSPlayerInfo.get((EntityPlayer)player).reduceFallAmount + (this.isUpgraded(stack) ? 8.0f : 4.0f);
                }
            }
        } else {
            player.func_85030_a("zeldaswordskills:magic_failure", 1.0f, 1.0f);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (this.getCooldown(stack) > 0) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (this == ZSSItems.rodTornado) {
            player.field_70143_R = 0.0f;
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_71020_j(this.fatigue / 20.0f);
            if (player.func_71024_bL().func_75116_a() < 1) {
                player.func_71041_bz();
            } else {
                int ticksInUse = this.func_77626_a(stack) - count;
                if (this == ZSSItems.rodTornado) {
                    if (ticksInUse % 10 == 0) {
                        player.field_70170_p.func_72838_d((Entity)new EntityCyclone(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v).disableGriefing());
                    }
                } else {
                    this.handleUpdateTick(stack, player.field_70170_p, player, ticksInUse);
                }
            }
        }
    }

    private void handleUpdateTick(ItemStack stack, World world, EntityPlayer player, int ticksInUse) {
        float r = 0.5f + Math.min(5.5f, (float)ticksInUse / 10.0f);
        if (this.isUpgraded(stack)) {
            r *= 1.5f;
        }
        WorldUtils.sendPacketToAllAround(new PacketISpawnParticles(player, this, r), world, player, 4096.0);
        if (ticksInUse % 4 == 3) {
            this.affectBlocks(world, player, r);
            List<EntityLivingBase> targets = TargetUtils.acquireAllLookTargets((EntityLivingBase)player, Math.round(r), 1.0);
            for (EntityLivingBase target : targets) {
                target.func_70097_a(this.getDamageSource(player), r);
                if (this.magicType != EntityMagicSpell.MagicType.FIRE || target.func_70045_F()) continue;
                target.func_70015_d(5);
            }
        }
        switch (this.magicType) {
            case ICE: {
                if (ticksInUse % 4 != 0) break;
                world.func_72956_a((Entity)player, "zeldaswordskills:magic_ice", 0.5f + world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                break;
            }
            default: {
                if (ticksInUse % 12 != 0) break;
                world.func_72956_a((Entity)player, "zeldaswordskills:magic_fire", 1.0f + world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat() * 0.7f + 0.3f);
            }
        }
    }

    private void affectBlocks(World world, EntityPlayer player, float radius) {
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>();
        Vec3 vec3 = player.func_70040_Z();
        double x = player.field_70165_t + vec3.field_72450_a;
        double y = player.field_70163_u + (double)player.func_70047_e() + vec3.field_72448_b;
        double z = player.field_70161_v + vec3.field_72449_c;
        int r = MathHelper.func_76123_f((float)radius);
        for (int n = 0; n < r; ++n) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)x);
            if (this.canAddBlockPosition(world, player, i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z))) {
                affectedBlocks.add(new ChunkPosition(i, j, k));
            }
            x += vec3.field_72450_a;
            y += vec3.field_72448_b;
            z += vec3.field_72449_c;
        }
        ItemMagicRod.affectAllBlocks(world, affectedBlocks, this.magicType);
    }

    private boolean canAddBlockPosition(World world, EntityPlayer player, int i, int j, int k) {
        Vec3 vec32;
        Vec3 vec31 = world.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        MovingObjectPosition mop = world.func_72933_a(vec31, vec32 = world.func_82732_R().func_72345_a((double)i, (double)j, (double)k));
        return mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop.field_72311_b == i && mop.field_72312_c == j && mop.field_72309_d == k || !world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149655_b((IBlockAccess)world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
    }

    public static void affectAllBlocks(World world, Set<ChunkPosition> blocks, EntityMagicSpell.MagicType type) {
        for (ChunkPosition p : blocks) {
            Block block = world.func_147439_a(p.field_151329_a, p.field_151327_b, p.field_151328_c);
            switch (type) {
                case FIRE: {
                    if (WorldUtils.canMeltBlock(world, block, p.field_151329_a, p.field_151327_b, p.field_151328_c) && world.field_73012_v.nextInt(4) == 0) {
                        world.func_147468_f(p.field_151329_a, p.field_151327_b, p.field_151328_c);
                        world.func_72908_a((double)p.field_151329_a + 0.5, (double)p.field_151327_b + 0.5, (double)p.field_151328_c + 0.5, "random.fizz", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block.func_149688_o() != Material.field_151579_a || !world.func_147439_a(p.field_151329_a, p.field_151327_b - 1, p.field_151328_c).func_149730_j() || world.field_73012_v.nextInt(8) != 0) break;
                    world.func_147449_b(p.field_151329_a, p.field_151327_b, p.field_151328_c, (Block)Blocks.field_150480_ab);
                    world.func_72908_a((double)p.field_151329_a + 0.5, (double)p.field_151327_b + 0.5, (double)p.field_151328_c + 0.5, "fire.ignite", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    break;
                }
                case ICE: {
                    if (block.func_149688_o() == Material.field_151586_h && world.field_73012_v.nextInt(4) == 0) {
                        world.func_147449_b(p.field_151329_a, p.field_151327_b, p.field_151328_c, Blocks.field_150432_aD);
                        world.func_72908_a((double)p.field_151329_a + 0.5, (double)p.field_151327_b + 0.5, (double)p.field_151328_c + 0.5, "random.glass", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block.func_149688_o() == Material.field_151587_i && world.field_73012_v.nextInt(8) == 0) {
                        Block solid = block == Blocks.field_150353_l ? Blocks.field_150343_Z : Blocks.field_150347_e;
                        world.func_147449_b(p.field_151329_a, p.field_151327_b, p.field_151328_c, solid);
                        world.func_72908_a((double)p.field_151329_a + 0.5, (double)p.field_151327_b + 0.5, (double)p.field_151328_c + 0.5, "random.fizz", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                        break;
                    }
                    if (block.func_149688_o() != Material.field_151581_o) break;
                    world.func_147468_f(p.field_151329_a, p.field_151327_b, p.field_151328_c);
                    world.func_72908_a((double)p.field_151329_a + 0.5, (double)p.field_151327_b + 0.5, (double)p.field_151328_c + 0.5, "random.fizz", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    break;
                }
            }
        }
    }

    private DamageSource getDamageSource(EntityPlayer player) {
        switch (this.magicType) {
            case ICE: {
                return new DamageUtils.DamageSourceIce("blast.ice", (Entity)player, 60, 1);
            }
        }
        return new EntityDamageSource("blast.fire", (Entity)player).func_76361_j();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double x, double y, double z, float r, Vec3 lookVector) {
        String particle = this.magicType == EntityMagicSpell.MagicType.FIRE ? "flame" : "snowshovel";
        y += 1.62;
        for (float f = 0.0f; f < r; f += 0.5f) {
            x += lookVector.field_72450_a;
            y += lookVector.field_72448_b;
            z += lookVector.field_72449_c;
            for (int i = 0; i < 4; ++i) {
                world.func_72869_a(particle, x + 0.5 - (double)world.field_73012_v.nextFloat(), y + 0.5 - (double)world.field_73012_v.nextFloat(), z + 0.5 - (double)world.field_73012_v.nextFloat(), lookVector.field_72450_a * (double)(0.5f * world.field_73012_v.nextFloat()), lookVector.field_72448_b * 0.15, lookVector.field_72449_c * (double)(0.5f * world.field_73012_v.nextFloat()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isUpgraded(stack) ? EnumRarity.rare : EnumRarity.common;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.1")));
        list.add("");
        list.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)"tooltip.zss.damage", (Object[])new Object[]{"", String.format("%.1f", Float.valueOf(this.isUpgraded(stack) ? this.damage * 1.5f : this.damage))}));
        if (this != ZSSItems.rodTornado) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tooltip.zss.area", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.isUpgraded(stack) ? 3.0f : 2.0f))}));
        }
    }

    @Override
    public boolean onActivatedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        return false;
    }

    @Override
    public boolean onClickedSacredFlame(ItemStack stack, World world, EntityPlayer player, int type, boolean isActive) {
        if (!world.field_72995_K) {
            if (this.hasAbsorbedFlame(stack)) {
                PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.sacred_flame.old.any", (Object[])new Object[]{this.func_77653_i(stack)}));
            } else if (isActive) {
                boolean canAbsorb = false;
                switch (this.magicType) {
                    case FIRE: {
                        canAbsorb = type == 1;
                        break;
                    }
                    case ICE: {
                        canAbsorb = type == 4;
                        break;
                    }
                    case WIND: {
                        boolean bl = canAbsorb = type == 2;
                    }
                }
                if (canAbsorb) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74757_a("absorbedFlame", true);
                    world.func_72956_a((Entity)player, "zeldaswordskills:flame_absorb", 1.0f, 1.0f);
                    PlayerUtils.sendChat(player, StatCollector.func_74837_a((String)"chat.zss.sacred_flame.new", (Object[])new Object[]{this.func_77653_i(stack), StatCollector.func_74838_a((String)("misc.zss.sacred_flame.name." + type))}));
                    return true;
                }
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.sacred_flame.random"));
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.sacred_flame.inactive"));
            }
            WorldUtils.playSoundAtEntity(world, (Entity)player, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
        }
        return false;
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        int cost = Math.round((float)Config.getRodUpgradeCost() * (this.magicType == EntityMagicSpell.MagicType.WIND ? 0.75f : 1.0f));
        if (core.consumeRupees(cost)) {
            if (!item.func_92059_d().func_77942_o()) {
                item.func_92059_d().func_77982_d(new NBTTagCompound());
            }
            item.func_92059_d().func_77978_p().func_74757_a("isUpgraded", true);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.fairy.laugh.unworthy"));
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return !this.isUpgraded(stack) && this.hasAbsorbedFlame(stack);
    }
}

