/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemHookShotUpgrade
extends Item {
    protected static final String[] addonNames = new String[]{"Extender", "Claw", "Multi"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemHookShotUpgrade() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    public AddonType getType(int damage) {
        return damage < AddonType.values().length ? AddonType.values()[damage] : AddonType.EXTENSION;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.use.fail.0"));
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity.getClass().isAssignableFrom(EntityVillager.class) && stack.func_77973_b() instanceof ItemHookShotUpgrade) {
            this.addSpecialTrade(stack, player, (EntityVillager)entity);
        }
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        return entity instanceof EntityVillager;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int type) {
        return this.iconArray[this.getType(type).ordinal()];
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < AddonType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[AddonType.values().length];
        for (int i = 0; i < AddonType.values().length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + addonNames[this.getType(i).ordinal()].toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.upgrade.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.upgrade.desc.1"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.upgrade.desc.2"));
    }

    public void addSpecialTrade(ItemStack stack, EntityPlayer player, EntityVillager villager) {
        if (!player.field_70170_p.field_72995_K) {
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == 3 && trades != null) {
                MerchantRecipe trade = this.getHookShotTradeFromInventory(stack, player, trades);
                if (trade != null && trades.size() >= Config.getFriendTradesRequired()) {
                    MerchantRecipeHelper.addUniqueTrade(trades, trade);
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.new.0"));
                } else {
                    trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 16));
                    if (MerchantRecipeHelper.doesListContain(trades, trade) || player.field_70170_p.field_73012_v.nextFloat() < 0.2f) {
                        MerchantRecipeHelper.addUniqueTrade(trades, trade);
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sell.0"));
                    } else {
                        PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.1"));
                    }
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.0"));
            }
        }
    }

    private MerchantRecipe getHookShotTradeFromInventory(ItemStack stack, EntityPlayer player, MerchantRecipeList list) {
        AddonType type = ((ItemHookShotUpgrade)stack.func_77973_b()).getType(stack.func_77960_j());
        for (ItemStack invStack : player.field_71071_by.field_70462_a) {
            if (invStack == null || !(invStack.func_77973_b() instanceof ItemHookShot) || MerchantRecipeHelper.doesListContain(list, TradeHandler.getTrade(type, invStack))) continue;
            return TradeHandler.getTrade(type, invStack);
        }
        return null;
    }

    public static enum AddonType {
        EXTENSION,
        STONECLAW,
        MULTI;

    }
}

