/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IZoom;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.projectile.EntityArrowBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.entity.projectile.EntityArrowElemental;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemHeroBow
extends ItemBow
implements IFairyUpgrade,
IZoom,
IBattlegearWeapon {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private static final Map<Integer, Class<? extends EntityArrow>> arrowMap = new HashMap<Integer, Class<? extends EntityArrow>>();
    private static BiMap<Integer, BombType> bombArrowMap;
    private static final Map<Integer, EntityArrowElemental.ElementType> elementalArrowMap;

    public ItemHeroBow() {
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public int getLevel(ItemStack bow) {
        if (!bow.func_77942_o() || !bow.func_77978_p().func_74764_b("zssBowLevel")) {
            this.setLevel(bow, 1);
        }
        return bow.func_77978_p().func_74762_e("zssBowLevel");
    }

    public void setLevel(ItemStack bow, int level) {
        if (!bow.func_77942_o()) {
            bow.func_77982_d(new NBTTagCompound());
        }
        bow.func_77978_p().func_74768_a("zssBowLevel", level);
    }

    private boolean canShootArrow(EntityPlayer player, ItemStack bow, int arrowId) {
        if (arrowMap.containsKey(arrowId)) {
            if (elementalArrowMap.containsKey(arrowId)) {
                if (ZSSPlayerInfo.get(player).isNayruActive()) {
                    return false;
                }
                int n = this.getLevel(bow);
                if (n < 3) {
                    EntityArrowElemental.ElementType type = elementalArrowMap.get(arrowId);
                    return player.field_71075_bZ.field_75098_d || n == 2 && type != EntityArrowElemental.ElementType.LIGHT;
                }
            }
            return true;
        }
        return false;
    }

    private void setArrow(ItemStack bow, ItemStack arrow) {
        if (!bow.func_77942_o()) {
            bow.func_77982_d(new NBTTagCompound());
        }
        bow.func_77978_p().func_74768_a("nockedArrow", arrow != null ? Item.func_150891_b((Item)arrow.func_77973_b()) : -1);
    }

    public int getArrow(ItemStack bow) {
        return bow.func_77942_o() && bow.func_77978_p().func_74764_b("nockedArrow") ? bow.func_77978_p().func_74762_e("nockedArrow") : -1;
    }

    private boolean nockArrow(ItemStack bow, EntityPlayer player) {
        ItemStack arrow = null;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !this.canShootArrow(player, bow, Item.func_150891_b((Item)stack.func_77973_b()))) continue;
            arrow = stack;
            break;
        }
        if (arrow == null && (player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)bow) > 0)) {
            arrow = new ItemStack(Items.field_151032_g);
        }
        if (arrow != null && arrow.func_77973_b() == Items.field_151032_g && Config.enableAutoBombArrows() && player.func_70093_af()) {
            ItemStack bombArrow = this.getAutoBombArrow(bow, player);
            arrow = bombArrow != null ? bombArrow : arrow;
        }
        this.setArrow(bow, arrow);
        return arrow != null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMaxZoomTime() {
        return 20.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getZoomFactor() {
        return 0.15f;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (!isHeld && this.hasAutoArrow(stack)) {
            this.setHasAutoArrow(stack, false);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (Config.areArrowTradesEnabled() && entity instanceof EntityVillager && !player.field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == 2 && trades != null && trades.size() >= Config.getFriendTradesRequired()) {
                int level = this.getLevel(stack);
                MerchantRecipe trade = null;
                if (level > 1 && MerchantRecipeHelper.doesListContain(trades, trade = new MerchantRecipe(new ItemStack(ZSSItems.arrowFire, 4), new ItemStack(Items.field_151166_bC, 16)))) {
                    trade = new MerchantRecipe(new ItemStack(ZSSItems.arrowIce, 4), new ItemStack(Items.field_151166_bC, 20));
                    if (level > 2 && MerchantRecipeHelper.doesListContain(trades, trade)) {
                        trade = new MerchantRecipe(new ItemStack(ZSSItems.arrowLight, 4), new ItemStack(Items.field_151166_bC, 40));
                    }
                }
                if (trade != null && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.arrow"));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.1"));
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.0"));
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!ZSSMain.isBG2Enabled) {
            ArrowNockEvent event = new ArrowNockEvent(player, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return event.result;
            }
        }
        if (this.nockArrow(stack, player)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack bow, World world, EntityPlayer player, int ticksRemaining) {
        boolean flag;
        this.setHasAutoArrow(bow, false);
        int ticksInUse = this.func_77626_a(bow) - ticksRemaining;
        int arrowId = this.getArrow(bow);
        if (arrowId < 0) {
            return;
        }
        this.setArrow(bow, null);
        if (!ZSSMain.isBG2Enabled) {
            ArrowLooseEvent event = new ArrowLooseEvent(player, bow, ticksInUse);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            ticksInUse = event.charge;
        }
        boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)bow) > 0;
        if (flag || player.field_71071_by.func_146028_b(Item.func_150899_d((int)arrowId))) {
            float charge = (float)ticksInUse / 20.0f;
            if ((double)(charge = Math.min((charge * charge + charge * 2.0f) / 3.0f, 1.0f)) < 0.1) {
                return;
            }
            EntityArrow arrow = ItemHeroBow.getArrowEntity(arrowId, world, (EntityLivingBase)player, charge * 2.0f);
            if (arrow != null) {
                if (arrow instanceof EntityArrowCustom) {
                    this.applyCustomArrowSettings(player, (EntityArrowCustom)arrow, bow, charge, arrowId);
                } else {
                    ItemHeroBow.applyArrowSettings(arrow, bow, charge);
                }
                world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
                if (flag) {
                    arrow.field_70251_a = 2;
                } else {
                    player.field_71071_by.func_146026_a(Item.func_150899_d((int)arrowId));
                }
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)arrow);
                }
            }
        }
    }

    private ItemStack getAutoBombArrow(ItemStack bow, EntityPlayer player) {
        ItemStack arrow = null;
        boolean hasArrow = this.hasAutoArrow(bow);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemBombBag bombBag;
            int bagType;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == ZSSItems.arrowBomb || stack.func_77973_b() == ZSSItems.arrowBombFire || stack.func_77973_b() == ZSSItems.arrowBombWater) {
                arrow = stack;
                break;
            }
            if (stack.func_77973_b() == ZSSItems.bomb) {
                ItemStack bombArrow = new ItemStack(Item.func_150899_d((int)((Integer)bombArrowMap.inverse().get((Object)ItemBomb.getType(stack)))), 1, 0);
                if (!hasArrow && !player.field_71071_by.func_146026_a(Items.field_151032_g)) continue;
                arrow = bombArrow;
                if (hasArrow) break;
                player.field_71071_by.func_70299_a(i, bombArrow);
                break;
            }
            if (!(stack.func_77973_b() instanceof ItemBombBag) || (bagType = (bombBag = (ItemBombBag)stack.func_77973_b()).getBagBombType(stack)) < 0 || bombBag.getBombsHeld(stack) <= 0 || !player.field_71071_by.func_146028_b(Items.field_151032_g)) continue;
            BombType type = BombType.values()[bagType % BombType.values().length];
            ItemStack bombArrow = new ItemStack(Item.func_150899_d((int)((Integer)bombArrowMap.inverse().get((Object)type))), 1, 0);
            if (!hasArrow && (!player.field_71071_by.func_70441_a(bombArrow) || !bombBag.removeBomb(stack) || !player.field_71071_by.func_146026_a(Items.field_151032_g))) continue;
            arrow = bombArrow;
            break;
        }
        this.setHasAutoArrow(bow, arrow != null);
        return arrow;
    }

    private void setHasAutoArrow(ItemStack bow, boolean value) {
        if (!bow.func_77942_o()) {
            bow.func_77982_d(new NBTTagCompound());
        }
        bow.func_77978_p().func_74757_a("hasAutoArrow", value);
    }

    private boolean hasAutoArrow(ItemStack bow) {
        return bow.func_77942_o() && bow.func_77978_p().func_74764_b("hasAutoArrow") && bow.func_77978_p().func_74767_n("hasAutoArrow");
    }

    public static final void applyArrowSettings(EntityArrow arrow, ItemStack bow, float charge) {
        int l;
        int k;
        if (charge == 1.0f) {
            arrow.func_70243_d(true);
        }
        if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)k * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70240_a(l);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
            arrow.func_70015_d(100);
        }
    }

    private void applyCustomArrowSettings(EntityPlayer player, EntityArrowCustom arrow, ItemStack bow, float charge, int arrowId) {
        int l;
        EntityLivingBase target;
        if (charge == 1.0f) {
            arrow.func_70243_d(true);
        }
        arrow.setArrowItem(Item.func_150899_d((int)arrowId));
        arrow.setShooter((Entity)player);
        if (player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() == ZSSItems.maskHawkeye && (target = TargetUtils.acquireLookTarget((EntityLivingBase)player, 64, 1.0)) != null) {
            arrow.setHomingArrow(true);
            arrow.setTarget(target);
        }
        if (arrow instanceof EntityArrowBomb && bombArrowMap.containsKey((Object)arrowId)) {
            ((EntityArrowBomb)arrow).setType((BombType)((Object)bombArrowMap.get((Object)arrowId)));
            arrow.func_70239_b(0.0);
        } else if (arrow instanceof EntityArrowElemental && elementalArrowMap.containsKey(arrowId)) {
            ((EntityArrowElemental)arrow).setType(elementalArrowMap.get(arrowId));
        }
        int k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow);
        double d = arrow.func_70242_d();
        if (k > 0 && d > 0.0) {
            arrow.func_70239_b(d + (double)k * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70240_a(l);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
            arrow.func_70015_d(100);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem == null) {
            return this.field_77791_bV;
        }
        int ticksInUse = stack.func_77988_m() - useRemaining;
        if (ticksInUse > 17) {
            return this.iconArray[2];
        }
        if (ticksInUse > 13) {
            return this.iconArray[1];
        }
        if (ticksInUse > 0) {
            return this.iconArray[0];
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + "_standard_0");
        this.iconArray = new IIcon[3];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + "_standard_" + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.1"), (Object[])new Object[]{this.getLevel(stack)}));
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.func_92059_d();
        int n = this.getLevel(stack);
        if (n < 3 && core.consumeRupees((n + 1) * Config.getHeroBowUpgradeCost())) {
            this.setLevel(stack, ++n);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
            player.func_71029_a((StatBase)ZSSAchievements.fairyBow);
            if (n == 3) {
                player.func_71029_a((StatBase)ZSSAchievements.fairyBowMax);
            }
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.fairy.laugh.unworthy"));
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this.getLevel(stack) < 3;
    }

    public static void initializeArrows() {
        arrowMap.put(Item.func_150891_b((Item)Items.field_151032_g), EntityArrowCustom.class);
        arrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowBomb), EntityArrowBomb.class);
        arrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowBombFire), EntityArrowBomb.class);
        arrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowBombWater), EntityArrowBomb.class);
        arrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowFire), EntityArrowElemental.class);
        arrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowIce), EntityArrowElemental.class);
        arrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowLight), EntityArrowElemental.class);
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)Item.func_150891_b((Item)ZSSItems.arrowBomb), (Object)BombType.BOMB_STANDARD);
        builder.put((Object)Item.func_150891_b((Item)ZSSItems.arrowBombFire), (Object)BombType.BOMB_FIRE);
        builder.put((Object)Item.func_150891_b((Item)ZSSItems.arrowBombWater), (Object)BombType.BOMB_WATER);
        bombArrowMap = builder.build();
        elementalArrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowFire), EntityArrowElemental.ElementType.FIRE);
        elementalArrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowIce), EntityArrowElemental.ElementType.ICE);
        elementalArrowMap.put(Item.func_150891_b((Item)ZSSItems.arrowLight), EntityArrowElemental.ElementType.LIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EntityArrow getArrowEntity(int arrowId, World world, EntityLivingBase shooter, float charge) {
        if (!arrowMap.containsKey(arrowId)) {
            return null;
        }
        EntityArrow arrow = null;
        try {
            try {
                arrow = arrowMap.get(arrowId).getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(world, shooter, Float.valueOf(charge));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Object var6_8 = null;
                return arrow;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var6_9 = null;
                return arrow;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Object var6_10 = null;
                return arrow;
            }
        }
        finally {
            return arrow;
        }
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return false;
    }

    static {
        elementalArrowMap = new HashMap<Integer, EntityArrowElemental.ElementType>();
    }
}

