/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class ItemBombBag
extends Item {
    private static final int BASE_CAPACITY = 10;
    private static final int MAX_CAPACITY = 50;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] ones;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] tens;

    public ItemBombBag() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.func_70093_af() || !this.increaseCapacity(player, stack)) {
            if (player.field_71075_bZ.field_75098_d || this.removeBomb(stack)) {
                int type;
                if (!player.field_71071_by.func_70441_a(stack)) {
                    player.func_71019_a(stack, false);
                }
                return new ItemStack(ZSSItems.bomb, 1, (type = this.getBagBombType(stack)) > 0 ? type : 0);
            }
            return stack;
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityBomb) {
            return ((EntityBomb)entity).disarm(entity.field_70170_p);
        }
        if (entity instanceof EntityVillager && !player.field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() != 1 && trades != null) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 16));
                if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sell.1"));
                } else {
                    PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.1"));
                }
            } else {
                PlayerUtils.sendChat(player, StatCollector.func_74838_a((String)"chat.zss.trade.generic.sorry.0"));
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        if (isHeld && this.getBombsHeld(stack) < this.getCapacity(stack) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invStack = player.field_71071_by.func_70301_a(i);
                if (invStack == null || !this.areMatchingTypes(stack, invStack, true) || this.addBombs(stack, invStack) >= 1) continue;
                player.field_71071_by.func_70299_a(i, null);
                if (this.getBombsHeld(stack) != this.getCapacity(stack)) continue;
                return;
            }
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        int bombsHeld = this.getBombsHeld(stack);
        switch (pass) {
            case 0: {
                return this.field_77791_bV;
            }
            case 1: {
                return this.ones[bombsHeld % 10];
            }
            case 2: {
                return this.tens[bombsHeld / 10 % 10];
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
        this.ones = new IIcon[10];
        this.tens = new IIcon[10];
        for (int i = 0; i < 10; ++i) {
            this.ones[i] = register.func_94245_a("zeldaswordskills:digits/" + (i == 0 ? "" : "00") + i);
            this.tens[i] = register.func_94245_a("zeldaswordskills:digits/0" + i + (i == 0 ? "" : "0"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.bombbag.desc.0"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.bombbag.desc.1"));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.bombbag.desc.2"));
        String bombName = StatCollector.func_74838_a((String)(this.getBombsHeld(stack) > 0 && this.getBagBombType(stack) > 0 ? "item.zss.bomb." + this.getBagBombType(stack) + ".name" : "item.zss.bomb.0.name"));
        list.add(EnumChatFormatting.BOLD + StatCollector.func_74837_a((String)"tooltip.zss.bombbag.desc.bombs", (Object[])new Object[]{bombName, this.getBombsHeld(stack), this.getCapacity(stack)}));
    }

    private int addBombs(ItemStack stack, int amount) {
        int bombs = this.getBombsHeld(stack);
        if (bombs <= this.getCapacity(stack)) {
            stack.func_77978_p().func_74768_a("bombs", Math.min(bombs + amount, this.getCapacity(stack)));
        }
        return amount - (this.getCapacity(stack) - bombs);
    }

    public int addBombs(ItemStack bag, ItemStack bombs) {
        if (this.areMatchingTypes(bag, bombs, true)) {
            int remaining = this.addBombs(bag, bombs.field_77994_a);
            this.setBagBombType(bag, ItemBomb.getType(bombs).ordinal());
            return remaining;
        }
        return bombs.field_77994_a;
    }

    public boolean removeBomb(ItemStack stack) {
        if (this.getBombsHeld(stack) > 0) {
            this.addBombs(stack, -1);
            return true;
        }
        return false;
    }

    public void emptyBag(ItemStack stack, EntityPlayer player) {
        int n = this.getBombsHeld(stack);
        int type = this.getBagBombType(stack);
        if (type < 0 || n < 1) {
            return;
        }
        ItemStack newBag = new ItemStack(ZSSItems.bombBag);
        this.setCapacity(newBag, this.getCapacity(stack));
        if (player.field_71071_by.func_70441_a(newBag)) {
            player.func_70062_b(0, null);
            while (n-- > 0) {
                ItemStack bomb = new ItemStack(ZSSItems.bomb, 1, type);
                if (player.field_71071_by.func_70441_a(bomb)) continue;
                WorldUtils.spawnItemWithRandom(player.field_70170_p, bomb, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
    }

    public int getCapacity(ItemStack stack) {
        return this.getCapacity(stack, false);
    }

    private int getCapacity(ItemStack stack, boolean trueCapacity) {
        this.verifyNBT(stack);
        int type = this.getBagBombType(stack);
        if (trueCapacity || type == -1 || type == BombType.BOMB_STANDARD.ordinal()) {
            return stack.func_77978_p().func_74762_e("capacity");
        }
        return stack.func_77978_p().func_74762_e("capacity") / 2;
    }

    private void setCapacity(ItemStack stack, int size) {
        this.verifyNBT(stack);
        stack.func_77978_p().func_74768_a("capacity", Math.min(size, 50));
    }

    public int getBombsHeld(ItemStack stack) {
        this.verifyNBT(stack);
        return stack.func_77978_p().func_74762_e("bombs");
    }

    public int getBagBombType(ItemStack bag) {
        this.verifyNBT(bag);
        return bag.func_77978_p().func_74762_e("type");
    }

    private void setBagBombType(ItemStack bag, int type) {
        this.verifyNBT(bag);
        bag.func_77978_p().func_74768_a("type", type);
    }

    public boolean areMatchingTypes(ItemStack bag, ItemStack stack, boolean isBomb) {
        int type = this.getBagBombType(bag);
        if (isBomb && stack.func_77973_b() instanceof ItemBomb) {
            return this.getBombsHeld(bag) == 0 || type == -1 || type == ItemBomb.getType(stack).ordinal();
        }
        if (!isBomb && stack.func_77973_b() instanceof ItemBombBag) {
            int type2 = this.getBagBombType(stack);
            return this.getBombsHeld(bag) == 0 || type == -1 || this.getBombsHeld(stack) == 0 || type == type2 || type2 == -1;
        }
        return false;
    }

    private boolean increaseCapacity(EntityPlayer player, ItemStack stack) {
        int capacity = this.getCapacity(stack, true);
        if (capacity < 50) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                int newCapacity;
                ItemStack invStack = player.field_71071_by.func_70301_a(i);
                if (invStack == null || invStack == stack || !this.areMatchingTypes(stack, invStack, false) || (newCapacity = capacity + this.getCapacity(invStack, true)) > 50) continue;
                this.setCapacity(stack, newCapacity);
                this.addBombs(stack, this.getBombsHeld(invStack));
                if (this.getBagBombType(stack) == -1) {
                    this.setBagBombType(stack, this.getBagBombType(invStack));
                }
                player.field_71071_by.func_70299_a(i, null);
                break;
            }
        }
        return this.getCapacity(stack, true) > capacity;
    }

    private void verifyNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("bombs", 0);
            stack.func_77978_p().func_74768_a("type", -1);
            stack.func_77978_p().func_74768_a("capacity", 10);
        }
    }
}

