/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.EntityGoron;
import zeldaswordskills.entity.EntityMaskTrader;
import zeldaswordskills.entity.ZSSEntities;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.entity.ZSSVillagerInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemCustomEgg;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.SyncEntityInfoPacket;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.LeapingBlow;
import zeldaswordskills.util.PlayerUtils;

public class ZSSEntityEvents {
    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerInfo skills = ZSSPlayerInfo.get(player);
            if (event.entity.field_70170_p.field_72995_K && skills.isSkillActive(SkillBase.leapingBlow)) {
                ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(player, event.distance);
            }
            if (skills.reduceFallAmount > 0.0f) {
                event.distance -= skills.reduceFallAmount;
                skills.reduceFallAmount = 0.0f;
            }
        }
        if (event.entityLiving.func_71124_b(4) != null && event.entityLiving.func_71124_b(4).func_77973_b() == ZSSItems.maskBunny) {
            event.distance -= 5.0f;
        }
    }

    @SubscribeEvent
    public void onCreativeFall(PlayerFlyableFallEvent event) {
        ZSSPlayerInfo skills = ZSSPlayerInfo.get(event.entityPlayer);
        if (skills != null && event.entityPlayer.field_70170_p.field_72995_K && skills.isSkillActive(SkillBase.leapingBlow)) {
            ((LeapingBlow)skills.getPlayerSkill(SkillBase.leapingBlow)).onImpact(event.entityPlayer, event.distance);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving.func_70694_bm() != null && event.entityLiving.func_70694_bm().func_77973_b() == ZSSItems.rocsFeather) {
            event.entityLiving.field_70181_x = event.entityLiving.field_70181_x + (event.entityLiving.func_70051_ag() ? 0.3 : 0.15);
        }
        if (event.entityLiving.func_71124_b(1) != null && event.entityLiving.func_71124_b(1).func_77973_b() == ZSSItems.bootsPegasus) {
            event.entityLiving.field_70181_x += 0.15;
        }
        if (event.entityLiving.func_71124_b(4) != null && event.entityLiving.func_71124_b(4).func_77973_b() == ZSSItems.maskBunny) {
            event.entityLiving.field_70181_x += 0.3;
        }
    }

    @SubscribeEvent
    public void onInteract(EntityInteractEvent event) {
        ItemStack stack;
        ItemStack helm;
        if (event.target.getClass().isAssignableFrom(EntityVillager.class)) {
            EntityVillager villager = (EntityVillager)event.target;
            boolean flag2 = villager.func_94057_bL().contains("Mask Salesman");
            if (!event.entityPlayer.field_70170_p.field_72995_K) {
                ItemStack stack2 = event.entityPlayer.func_70694_bm();
                if (stack2 != null && stack2.func_77973_b() == ZSSItems.treasure && stack2.func_77960_j() == ItemTreasure.Treasures.ZELDAS_LETTER.ordinal()) {
                    if (flag2) {
                        PlayerUtils.sendChat(event.entityPlayer, StatCollector.func_74838_a((String)("chat.zss.treasure." + ItemTreasure.Treasures.ZELDAS_LETTER.name + ".for_me")));
                    } else {
                        PlayerUtils.sendChat(event.entityPlayer, StatCollector.func_74838_a((String)("chat.zss.treasure." + ItemTreasure.Treasures.ZELDAS_LETTER.name + ".fail")));
                    }
                    flag2 = true;
                } else if (flag2) {
                    PlayerUtils.sendChat(event.entityPlayer, StatCollector.func_74838_a((String)("chat.zss.npc.mask_trader.closed." + event.entity.field_70170_p.field_73012_v.nextInt(4))));
                }
            }
            event.setCanceled(flag2);
        }
        if (!event.isCanceled() && (event.target instanceof EntityVillager || event.target instanceof EntityMaskTrader) && (helm = event.entityPlayer.func_82169_q(3)) != null && helm.func_77973_b() instanceof ItemMask) {
            event.setCanceled(((ItemMask)helm.func_77973_b()).onInteract(helm, event.entityPlayer, event.target));
        }
        if (!event.isCanceled() && event.target instanceof EntityAgeable && (stack = event.entityPlayer.func_70694_bm()) != null && stack.func_77973_b() instanceof ItemCustomEgg) {
            event.setCanceled(ItemCustomEgg.spawnChild(event.entity.field_70170_p, stack, event.entityPlayer, (EntityAgeable)event.target));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ZSSPlayerInfo.get(player).onUpdate();
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ZSSItems.rocsFeather && player.field_70181_x < -0.25) {
                player.field_70181_x = -0.25;
                player.field_70143_R = 0.0f;
            }
        }
        if (event.entity instanceof EntityLivingBase) {
            ZSSEntityInfo.get((EntityLivingBase)event.entity).onUpdate();
        }
        if (event.entity instanceof EntityVillager) {
            ZSSVillagerInfo.get((EntityVillager)event.entity).onUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K) {
            NBTTagCompound compound;
            if (event.entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entity;
                ZSSPlayerInfo.loadProxyData(player);
                ZSSMain.dispatcher.sendTo(new SyncEntityInfoPacket(ZSSEntityInfo.get((EntityLivingBase)player)), (EntityPlayerMP)player);
                ZSSPlayerInfo.get(player).verifyStartingGear();
            } else if (event.entity.getClass().isAssignableFrom(EntityVillager.class) && !(compound = event.entity.getEntityData()).func_74764_b("zssFirstJoinFlag")) {
                compound.func_74757_a("zssFirstJoinFlag", true);
                int ratio = ZSSEntities.getGoronRatio();
                if (ratio > 0 && event.world.field_73012_v.nextInt(ratio) == 0) {
                    int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
                    int y = MathHelper.func_76128_c((double)event.entity.field_70163_u);
                    int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
                    try {
                        if (event.entity.field_70170_p.field_72982_D.func_75540_b().isEmpty() || event.entity.field_70170_p.field_72982_D.func_75550_a(x, y, z, 32) != null) {
                            EntityGoron goron = new EntityGoron(event.entity.field_70170_p, event.entity.field_70170_p.field_73012_v.nextInt(5));
                            double posX = event.entity.field_70165_t + (double)event.entity.field_70170_p.field_73012_v.nextInt(8) - 4.0;
                            double posZ = event.entity.field_70161_v + (double)event.entity.field_70170_p.field_73012_v.nextInt(8) - 4.0;
                            goron.func_70012_b(posX, event.entity.field_70163_u + 1.0, posZ, event.entity.field_70177_z, event.entity.field_70125_A);
                            if (goron.func_70601_bi()) {
                                event.entity.field_70170_p.func_72838_d((Entity)goron);
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
            if (!Config.areVanillaBuffsDisabled() && event.entity instanceof EntityLivingBase) {
                this.initBuffs((EntityLivingBase)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && ZSSEntityInfo.get((EntityLivingBase)event.entity) == null) {
            ZSSEntityInfo.register((EntityLivingBase)event.entity);
        }
        if (event.entity instanceof EntityVillager && ZSSVillagerInfo.get((EntityVillager)event.entity) == null) {
            ZSSVillagerInfo.register((EntityVillager)event.entity);
        }
        if (event.entity instanceof EntityPlayer && ZSSPlayerInfo.get((EntityPlayer)event.entity) == null) {
            ZSSPlayerInfo.register((EntityPlayer)event.entity);
        }
    }

    private void initBuffs(EntityLivingBase entity) {
        if (!ZSSEntityInfo.get(entity).getActiveBuffsMap().isEmpty()) {
            return;
        }
        if (entity.func_70045_F()) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 75);
            ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_COLD, Integer.MAX_VALUE, 100);
        }
        if (entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            if (!entity.func_70045_F()) {
                ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_FIRE, Integer.MAX_VALUE, 50);
            }
            ZSSEntityInfo.get(entity).applyBuff(Buff.WEAKNESS_HOLY, Integer.MAX_VALUE, 300);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 50);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 50);
        }
        if (entity instanceof EntityGolem) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
        }
        if (entity instanceof EntityWitch) {
            ZSSEntityInfo.get(entity).applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 75);
        }
        if (entity instanceof EntityWither) {
            ZSSEntityInfo.get(entity).removeBuff(Buff.WEAKNESS_COLD);
        }
    }
}

