/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.entity.ZSSPlayerInfo;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.SwordBeam;
import zeldaswordskills.util.WorldUtils;

public class EntitySwordBeam
extends EntityThrowable {
    private float damage = 4.0f;
    private int level = 1;
    private int lifespan = 12;
    private boolean isMaster = false;

    public EntitySwordBeam(World world) {
        super(world);
    }

    public EntitySwordBeam(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntitySwordBeam(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_70088_a() {
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntitySwordBeam setLevel(int level) {
        this.level = level;
        this.lifespan += level;
        return this;
    }

    public EntitySwordBeam setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public EntitySwordBeam setMasterSword(boolean isMaster) {
        this.isMaster = isMaster;
        return this;
    }

    protected float func_70182_d() {
        return 1.0f + (float)this.level * 0.15f;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public float func_70013_c(float partialTick) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTick) {
        return 0xF000F0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70193_a || this.field_70173_aa > this.lifespan) {
            this.func_70106_y();
        }
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_72869_a(i % 2 == 1 ? "magicCrit" : "crit", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w + this.field_70146_Z.nextGaussian(), 0.01, this.field_70179_y + this.field_70146_Z.nextGaussian());
            this.field_70170_p.func_72869_a(i % 2 == 1 ? "magicCrit" : "crit", this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.field_70159_w + this.field_70146_Z.nextGaussian(), 0.01, -this.field_70179_y + this.field_70146_Z.nextGaussian());
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            SwordBeam skill;
            EntityPlayer player = this.func_85052_h() instanceof EntityPlayer ? (EntityPlayer)this.func_85052_h() : null;
            SwordBeam swordBeam = skill = player != null ? (SwordBeam)ZSSPlayerInfo.get(player).getPlayerSkill(SkillBase.swordBeam) : null;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                Entity entity = mop.field_72308_g;
                if (player != null) {
                    if (skill != null) {
                        skill.onImpact(player, false);
                    }
                    if (entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), this.damage)) {
                        WorldUtils.playSoundAtEntity(this.field_70170_p, entity, "game.player.hurt", 0.4f, 0.5f);
                    }
                    this.damage *= 0.8f;
                }
                if (!this.isMaster) {
                    this.func_70106_y();
                }
            } else {
                Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (block.func_149688_o().func_76230_c()) {
                    if (player != null && skill != null) {
                        skill.onImpact(player, true);
                    }
                    this.func_70106_y();
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isMaster", this.isMaster);
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("level", this.level);
        compound.func_74768_a("lifespan", this.lifespan);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isMaster = compound.func_74767_n("isMaster");
        this.damage = compound.func_74760_g("damage");
        this.level = compound.func_74762_e("level");
        this.lifespan = compound.func_74762_e("lifespan");
    }
}

