/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.util.WorldUtils;

public class EntityMagicSpell
extends EntityMobThrowable {
    private static final int SPELL_TYPE_INDEX = 22;
    private static final int AREA_INDEX = 23;

    public EntityMagicSpell(World world) {
        super(world);
    }

    public EntityMagicSpell(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityMagicSpell(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityMagicSpell(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)MagicType.FIRE.ordinal());
        this.field_70180_af.func_75682_a(23, (Object)Float.valueOf(2.0f));
    }

    public MagicType getType() {
        return MagicType.values()[this.field_70180_af.func_75679_c(22) % MagicType.values().length];
    }

    public EntityMagicSpell setType(MagicType type) {
        this.field_70180_af.func_75692_b(22, (Object)type.ordinal());
        return this;
    }

    public float getArea() {
        return this.field_70180_af.func_111145_d(23);
    }

    public EntityMagicSpell setArea(float radius) {
        this.field_70180_af.func_75692_b(23, (Object)Float.valueOf(radius));
        return this;
    }

    protected DamageSource getDamageSource() {
        switch (this.getType()) {
            case ICE: {
                return new DamageUtils.DamageSourceIceIndirect("blast.ice", (Entity)this, (Entity)this.func_85052_h(), 50, 1).func_76349_b().func_82726_p();
            }
            case WIND: {
                return new EntityDamageSourceIndirect("blast.wind", (Entity)this, (Entity)this.func_85052_h()).func_76349_b().func_82726_p();
            }
        }
        return new EntityDamageSourceIndirect("blast.fire", (Entity)this, (Entity)this.func_85052_h()).func_76361_j().func_76349_b().func_82726_p();
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    protected float func_70185_h() {
        return 0.02f;
    }

    private String getParticle() {
        switch (this.getType()) {
            case ICE: {
                return "snowshovel";
            }
            case WIND: {
                return "cloud";
            }
        }
        return "flame";
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            String particle = this.getParticle();
            boolean flag = this.getType() != MagicType.FIRE;
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_72869_a(particle, this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w * 0.25, -this.field_70181_x + (flag ? 0.1 : 0.0), -this.field_70179_y * 0.25);
            }
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        double x = mop.field_72308_g != null ? mop.field_72308_g.field_70165_t : (double)mop.field_72311_b + 0.5;
        double y = mop.field_72308_g != null ? mop.field_72308_g.field_70163_u : (double)mop.field_72312_c + 0.5;
        double z = mop.field_72308_g != null ? mop.field_72308_g.field_70161_v : (double)mop.field_72309_d + 0.5;
        float r = this.getArea();
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - (double)r), (double)(y - (double)r), (double)(z - (double)r), (double)(x + (double)r), (double)(y + (double)r), (double)(z + (double)r)));
        for (EntityLivingBase entity : list) {
            Block block;
            Vec3 vec31;
            Vec3 vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t - this.field_70159_w, this.field_70163_u - this.field_70181_x, this.field_70161_v - this.field_70179_y);
            MovingObjectPosition mop1 = this.field_70170_p.func_72933_a(vec3, vec31 = this.field_70170_p.func_82732_R().func_72345_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
            if (mop1 != null && mop1.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.field_70170_p.func_147439_a(mop1.field_72311_b, mop1.field_72312_c, mop1.field_72309_d)).func_149688_o().func_76230_c() || !entity.func_70097_a(this.getDamageSource(), this.getDamage()) || entity.field_70128_L) continue;
            this.handlePostDamageEffects(entity);
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnImpactParticles("largeexplode", 4, -0.1f);
            this.spawnImpactParticles(this.getParticle(), 16, this.getType() == MagicType.ICE ? 0.0f : -0.2f);
        } else {
            this.field_70170_p.func_72956_a((Entity)this, "random.explode", 2.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>(WorldUtils.getAffectedBlocksList(this.field_70170_p, this.field_70146_Z, r, this.field_70165_t, this.field_70163_u, this.field_70161_v, null));
            ItemMagicRod.affectAllBlocks(this.field_70170_p, affectedBlocks, this.getType());
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnImpactParticles(String particle, int n, float offsetY) {
        for (int i = 0; i < n; ++i) {
            double dx = this.field_70165_t - this.field_70159_w * (double)i / 4.0;
            double dy = this.field_70163_u - this.field_70181_x * (double)i / 4.0;
            double dz = this.field_70161_v - this.field_70159_w * (double)i / 4.0;
            this.field_70170_p.func_72869_a(particle, dx + (double)this.field_70146_Z.nextFloat() - 0.5, dy + (double)this.field_70146_Z.nextFloat() - 0.5, dz + (double)this.field_70146_Z.nextFloat() - 0.5, (double)(0.25f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(this.field_70146_Z.nextFloat() * 0.25f + offsetY), (double)(0.25f * (this.field_70146_Z.nextFloat() - 0.5f)));
        }
    }

    protected void handlePostDamageEffects(EntityLivingBase entity) {
        switch (this.getType()) {
            case ICE: {
                ZSSEntityInfo.get(entity).stun((int)Math.ceil(this.getDamage()) * 10, true);
                int i = MathHelper.func_76128_c((double)entity.field_70165_t);
                int j = MathHelper.func_76128_c((double)entity.field_70163_u);
                int k = MathHelper.func_76128_c((double)entity.field_70161_v);
                this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150432_aD);
                this.field_70170_p.func_147449_b(i, j + 1, k, Blocks.field_150432_aD);
                this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.glass", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                break;
            }
            case FIRE: {
                if (entity.func_70045_F()) break;
                entity.func_70015_d((int)Math.ceil(this.getDamage()));
                break;
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("magicType", this.getType().ordinal());
        compound.func_74776_a("areaOfEffect", this.getArea());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(MagicType.values()[compound.func_74762_e("magicType") % MagicType.values().length]);
        this.setArea(compound.func_74760_g("areaOfEffect"));
    }

    public static enum MagicType {
        FIRE,
        ICE,
        WIND;

    }
}

