/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityLeapingBlow
extends EntityThrowable {
    private List<Integer> affectedEntities = new ArrayList<Integer>();
    private float damage = 2.0f;
    private int lifespan = 12;
    private int level = 0;
    private boolean isMaster = false;
    private static final float BASE_SIZE = 1.0f;
    private static final float HEIGHT = 0.5f;

    public EntityLeapingBlow(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.5f);
    }

    public EntityLeapingBlow(World world, EntityLivingBase thrower) {
        super(world, thrower);
        this.func_70105_a(1.0f, 0.5f);
        this.field_70163_u = thrower.field_70163_u + 0.2;
        this.field_70181_x = 0.0;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.func_70182_d(), 1.0f);
    }

    public EntityLeapingBlow(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_70105_a(1.0f, 0.5f);
    }

    public EntityLeapingBlow setLevel(int level, boolean isMaster) {
        this.level = level;
        this.lifespan += level;
        this.isMaster = isMaster;
        return this;
    }

    public EntityLeapingBlow setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    private double getRangeSquared() {
        return (3.0 + (double)this.level) * (3.0 + (double)this.level);
    }

    private int getPotionDuration() {
        return (this.isMaster ? 110 : 50) + this.level * 10;
    }

    private AxisAlignedBB getAoE() {
        return this.field_70121_D.func_72314_b((double)(0.25f * (float)this.level), 0.0, (double)(0.25f * (float)this.level));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70193_a || this.field_70173_aa > this.lifespan) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.getAoE());
            for (EntityLivingBase target : targets) {
                double d0;
                if (this.affectedEntities.contains(target.func_145782_y()) || target == this.func_85052_h() || TargetUtils.isTargetInFrontOf((Entity)this, (Entity)target, 30.0f)) continue;
                this.affectedEntities.add(target.func_145782_y());
                float d = this.damage;
                if (this.func_85052_h() != null && (double)(d = (float)((double)d * ((d0 = 1.0 - this.func_85052_h().func_70068_e((Entity)target) / this.getRangeSquared()) > 1.0 ? 1.0 : d0))) < 0.5) {
                    return;
                }
                if (!target.func_70097_a(DamageUtils.causeIndirectSwordDamage((Entity)this, (Entity)this.func_85052_h()), d)) continue;
                target.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.getPotionDuration()));
            }
        }
        double vX = this.field_70179_y;
        double vZ = this.field_70159_w;
        String particle = this.isMaster ? "magicCrit" : "crit";
        Block block = this.field_70170_p.func_147439_a((int)(this.field_70165_t + (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a) / 2.0), (int)this.field_70163_u - 1, (int)(this.field_70161_v + (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c) / 2.0));
        if (block.func_149688_o() != Material.field_151579_a) {
            particle = "blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g((int)(this.field_70165_t + (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a) / 2.0), (int)this.field_70163_u - 1, (int)(this.field_70161_v + (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c) / 2.0));
        }
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_72869_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, vX + this.field_70146_Z.nextGaussian(), 0.01, vZ + this.field_70146_Z.nextGaussian());
            this.field_70170_p.func_72869_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, -vX + this.field_70146_Z.nextGaussian(), 0.01, -vZ + this.field_70146_Z.nextGaussian());
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                Entity entity = mop.field_72308_g;
                if (entity instanceof EntityLivingBase && !this.affectedEntities.contains(entity.func_145782_y()) && entity != this.func_85052_h()) {
                    this.affectedEntities.add(entity.func_145782_y());
                    if (entity.func_70097_a(DamageUtils.causeIndirectSwordDamage((Entity)this, (Entity)this.func_85052_h()), this.damage)) {
                        WorldUtils.playSoundAtEntity(this.field_70170_p, entity, "zeldaswordskills:hurtflesh", 0.4f, 0.5f);
                        if (entity instanceof EntityLivingBase) {
                            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60));
                        }
                    }
                }
            } else {
                Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (block.func_149688_o().func_76230_c()) {
                    this.func_70106_y();
                }
            }
        }
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isMaster", this.isMaster);
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("level", this.level);
        compound.func_74768_a("lifespan", this.lifespan);
        compound.func_74783_a("affectedEntities", ArrayUtils.toPrimitive((Integer[])this.affectedEntities.toArray(new Integer[this.affectedEntities.size()])));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isMaster = compound.func_74767_n("isMaster");
        this.damage = compound.func_74760_g("damage");
        this.level = compound.func_74762_e("level");
        this.lifespan = compound.func_74762_e("lifespan");
        int[] entities = compound.func_74759_k("affectedEntities");
        for (int i = 0; i < entities.length; ++i) {
            this.affectedEntities.add(entities[i]);
        }
    }
}

