/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.lib.Config;

public class EntityArrowBomb
extends EntityArrowCustom
implements IEntityBomb {
    private static final int BOMBTYPE_DATAWATCHER_INDEX = 25;
    private float radius = 0.0f;
    private boolean canGrief = true;

    public EntityArrowBomb(World world) {
        super(world);
    }

    public EntityArrowBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityArrowBomb(World world, EntityLivingBase shooter, float velocity) {
        super(world, shooter, velocity);
    }

    public EntityArrowBomb(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)BombType.BOMB_STANDARD.ordinal());
    }

    @Override
    protected DamageSource getDamageSource(Entity entity) {
        return new EntityDamageSourceIndirect("bomb arrow", (Entity)this, this.getShooter()).func_76349_b().func_94540_d();
    }

    public EntityArrowBomb setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public boolean canGriefAdventureMode() {
        return Config.canGriefAdventure();
    }

    public EntityArrowBomb setNoGrief() {
        this.canGrief = false;
        return this;
    }

    public EntityArrowBomb setType(BombType type) {
        this.field_70180_af.func_75692_b(25, (Object)type.ordinal());
        return this;
    }

    @Override
    public BombType getType() {
        return BombType.values()[this.field_70180_af.func_75679_c(25)];
    }

    @Override
    public float getMotionFactor() {
        return 1.0f;
    }

    @Override
    public float getDestructionFactor() {
        return 1.0f;
    }

    @Override
    protected float getVelocityFactor() {
        return 1.0f;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.065f;
    }

    @Override
    protected String getParticleName() {
        return "smoke";
    }

    @Override
    protected boolean shouldSpawnParticles() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70257_an > 5 && this.field_70170_p.field_73011_w.field_76574_g == -1 && this.getType() == BombType.BOMB_STANDARD && !this.field_70170_p.field_72995_K) {
            CustomExplosion.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.radius == 0.0f ? ItemBomb.getRadius(this.getType()) : this.radius, (float)this.func_70242_d(), this.canGrief);
            this.func_70106_y();
        }
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        Material material = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o();
        if (!this.isDud(material == Material.field_151587_i || material == Material.field_151581_o) || this.field_70170_p.func_147470_e(this.field_70121_D)) {
            if (!this.field_70170_p.field_72995_K) {
                CustomExplosion.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.radius == 0.0f ? ItemBomb.getRadius(this.getType()) : this.radius, (float)this.func_70242_d(), this.canGrief);
                this.func_70106_y();
            }
        } else {
            super.onImpact(mop);
        }
    }

    private boolean isDud(boolean inFire) {
        switch (this.getType()) {
            case BOMB_WATER: {
                return inFire || this.field_70173_aa > 8 && this.field_70170_p.field_73011_w.field_76574_g == -1;
            }
        }
        return this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v).func_149688_o() == Material.field_151586_h;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("arrowType", this.getType().ordinal());
        compound.func_74776_a("bombRadius", this.radius);
        compound.func_74757_a("canGrief", this.canGrief);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(BombType.values()[compound.func_74762_e("arrowType")]);
        this.radius = compound.func_74760_g("bombRadius");
        this.canGrief = compound.func_74767_n("canGrief");
    }
}

