/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.commons.lang3.ArrayUtils;
import zeldaswordskills.CommonProxy;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.client.ZSSKeyHandler;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ItemArmorBoots;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.lib.Config;
import zeldaswordskills.network.AttackBlockedPacket;
import zeldaswordskills.network.SpawnNayruParticlesPacket;
import zeldaswordskills.network.SyncPlayerInfoPacket;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillActive;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.WorldUtils;

public class ZSSPlayerInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "ZSSPlayerInfo";
    private final EntityPlayer player;
    private int blockTime = 0;
    private final Map<Stats, Integer> playerStats = new EnumMap<Stats, Integer>(Stats.class);
    private byte receivedGear = 0;
    private byte flags = 0;
    public static final byte IS_WEARING_BOOTS = 1;
    public static final byte IS_WEARING_HELM = 2;
    public static final byte IS_NAYRU_ACTIVE = 4;
    public static final byte MOBILITY = 8;
    private Item lastBootsWorn;
    private Item lastHelmWorn;
    public int hoverTime = 0;
    private final Map<Byte, SkillBase> skills;
    private int currentActiveSkillId = -1;
    private int fairySpinOrbsReceived = 0;
    private Item borrowedMask = null;
    private int maskStage = 0;
    public float reduceFallAmount = 0.0f;

    public ZSSPlayerInfo(EntityPlayer player) {
        this.player = player;
        this.skills = new HashMap<Byte, SkillBase>(SkillBase.getNumSkills());
        this.initStats();
    }

    public boolean canBlock() {
        return this.blockTime == 0;
    }

    public void onAttackBlocked(ItemStack shield, float damage) {
        ZSSCombatEvents.setPlayerAttackTime(this.player);
        this.blockTime = shield.func_77973_b() instanceof ItemZeldaShield ? ((ItemZeldaShield)shield.func_77973_b()).getRecoveryTime() : 20;
        this.player.func_71041_bz();
        if (!this.player.field_70170_p.field_72995_K) {
            ZSSMain.dispatcher.sendTo(new AttackBlockedPacket(shield), (EntityPlayerMP)this.player);
            this.player.func_71020_j(0.3f * damage);
        }
    }

    private void initStats() {
        for (Stats stat : Stats.values()) {
            this.playerStats.put(stat, 0);
        }
    }

    public int getStat(Stats stat) {
        return this.playerStats.get((Object)stat);
    }

    public void addStat(Stats stat, int value) {
        int i = this.playerStats.remove((Object)stat);
        switch (stat) {
            case STAT_BOSS_ROOMS: {
                this.playerStats.put(stat, i | value);
                break;
            }
            default: {
                this.playerStats.put(stat, i + value);
            }
        }
    }

    public void resetSkills() {
        for (SkillBase skill : SkillBase.getSkills()) {
            this.skills.put(skill.getId(), skill.newInstance());
        }
        this.validateSkills();
        this.skills.clear();
        this.fairySpinOrbsReceived = 0;
        ZSSMain.dispatcher.sendTo(new SyncPlayerInfoPacket(this), (EntityPlayerMP)this.player);
    }

    public void verifyStartingGear() {
        if ((this.receivedGear & 1) == 0 && ZSSItems.grantBonusGear(this.player)) {
            this.receivedGear = (byte)(this.receivedGear | 1);
        }
    }

    public void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    public boolean getFlag(byte flag) {
        return (this.flags & flag) == flag;
    }

    public void activateNayru() {
        this.setFlag((byte)4, true);
    }

    public boolean isNayruActive() {
        return this.getFlag((byte)4);
    }

    public void setWearingBoots() {
        ItemStack boots = this.player.func_82169_q(0);
        this.setFlag((byte)1, boots != null && boots.func_77973_b() instanceof ItemArmorBoots);
        this.lastBootsWorn = boots != null ? boots.func_77973_b() : null;
        ItemArmorBoots.applyAttributeModifiers(boots, this.player);
        if (!this.getFlag((byte)1) && this.getFlag((byte)2)) {
            ItemMask.applyAttributeModifiers(this.player.func_82169_q(3), this.player);
        }
    }

    public void setWearingHelm() {
        ItemStack helm = this.player.func_82169_q(3);
        this.setFlag((byte)2, helm != null && helm.func_77973_b() instanceof ItemMask);
        this.lastHelmWorn = helm != null ? helm.func_77973_b() : null;
        ItemMask.applyAttributeModifiers(helm, this.player);
        if (!this.getFlag((byte)2) && this.getFlag((byte)1)) {
            ItemArmorBoots.applyAttributeModifiers(this.player.func_82169_q(0), this.player);
        }
    }

    public boolean canReceiveFairyOrb() {
        return this.getSkillLevel(SkillBase.spinAttack) > this.getSkillLevel(SkillBase.superSpinAttack) && this.getSkillLevel(SkillBase.superSpinAttack) >= this.fairySpinOrbsReceived && this.getSkillLevel(SkillBase.bonusHeart) >= this.fairySpinOrbsReceived * Config.getMaxBonusHearts() / 5;
    }

    public boolean hasReceivedAllOrbs() {
        return this.fairySpinOrbsReceived == 5;
    }

    public boolean receiveFairyOrb() {
        return ++this.fairySpinOrbsReceived == 5;
    }

    public Item getBorrowedMask() {
        return this.borrowedMask;
    }

    public void setBorrowedMask(Item item) {
        this.borrowedMask = item;
    }

    public int getCurrentMaskStage() {
        return this.maskStage;
    }

    public void completeCurrentMaskStage() {
        ++this.maskStage;
    }

    public boolean hasSkill(SkillBase skill) {
        return this.hasSkill(skill.getId());
    }

    private boolean hasSkill(byte id) {
        return this.getSkillLevel(id) > 0;
    }

    public byte getSkillLevel(SkillBase skill) {
        return this.getSkillLevel(skill.getId());
    }

    public byte getSkillLevel(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id).getLevel() : (byte)0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSkillActivate(SkillBase skill) {
        SkillActive active = this.getActiveSkill(skill);
        return active != null && active.canExecute(this.player);
    }

    public boolean canUseSkill(SkillBase skill) {
        SkillActive active = this.getActiveSkill(skill);
        return active != null && active.canUse(this.player);
    }

    public boolean isSkillActive(SkillBase skill) {
        if (skill instanceof SkillActive && this.skills.containsKey(skill.getId())) {
            return this.getSkillLevel(skill) > 0 && ((SkillActive)this.skills.get(skill.getId())).isActive();
        }
        return false;
    }

    public void setCurrentActiveSkill(SkillBase skill) {
        this.currentActiveSkillId = skill.getId();
    }

    public boolean canInteract() {
        if (this.currentActiveSkillId > -1 && !this.isSkillActive(SkillBase.getSkill(this.currentActiveSkillId))) {
            this.currentActiveSkillId = -1;
        }
        return this.currentActiveSkillId == -1;
    }

    public SkillActive getActiveSkill(SkillBase skill) {
        SkillBase active = this.getPlayerSkill(skill.getId());
        return active instanceof SkillActive ? (SkillActive)active : null;
    }

    public SkillBase getPlayerSkill(SkillBase skill) {
        return this.getPlayerSkill(skill.getId());
    }

    public SkillBase getPlayerSkill(byte id) {
        return this.skills.containsKey(id) ? this.skills.get(id) : null;
    }

    public ICombo getComboSkill() {
        SkillBase skill = this.getPlayerSkill(SkillBase.swordBasic);
        if (skill != null && (((ICombo)((Object)skill)).getCombo() != null || ((SkillActive)skill).isActive())) {
            return (ICombo)((Object)skill);
        }
        return null;
    }

    public ILockOnTarget getTargetingSkill() {
        return (ILockOnTarget)((Object)this.getPlayerSkill(SkillBase.swordBasic));
    }

    public boolean grantSkill(SkillBase skill) {
        return this.grantSkill(skill.getId(), (byte)(this.getSkillLevel(skill) + 1));
    }

    public boolean grantSkill(byte id, byte targetLevel) {
        SkillBase skill;
        SkillBase skillBase = skill = this.skills.containsKey(id) ? this.skills.get(id) : SkillBase.getNewSkillInstance(id);
        if (skill.grantSkill(this.player, targetLevel)) {
            this.skills.put(id, skill);
            return true;
        }
        return false;
    }

    public boolean activateSkill(World world, SkillBase skill) {
        return this.activateSkill(world, skill.getId());
    }

    public boolean activateSkill(World world, byte id) {
        if (this.skills.containsKey(id) && this.skills.get(id) instanceof SkillActive) {
            return ((SkillActive)this.skills.get(id)).activate(world, this.player);
        }
        return false;
    }

    public boolean triggerSkill(World world, SkillBase skill) {
        return this.triggerSkill(world, skill.getId());
    }

    public boolean triggerSkill(World world, byte id) {
        if (this.skills.containsKey(id) && this.skills.get(id) instanceof SkillActive) {
            return ((SkillActive)this.skills.get(id)).trigger(world, this.player);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void syncClientSideSkill(byte id, NBTTagCompound compound) {
        if (SkillBase.doesSkillExist(id)) {
            this.skills.put(id, SkillBase.getNewSkillInstance(id).loadFromNBT(compound));
        }
    }

    public void onUpdate() {
        if (this.blockTime > 0) {
            --this.blockTime;
        }
        if (this.getFlag((byte)4)) {
            this.updateNayru();
        }
        if (this.getFlag((byte)1) && (this.player.func_82169_q(0) == null || this.player.func_82169_q(0).func_77973_b() != this.lastBootsWorn)) {
            this.setWearingBoots();
        }
        if (this.getFlag((byte)2) && (this.player.func_82169_q(3) == null || this.player.func_82169_q(3).func_77973_b() != this.lastHelmWorn)) {
            this.setWearingHelm();
        }
        if (this.getFlag((byte)8) && !this.player.field_70122_E && Math.abs(this.player.field_70181_x) > 0.05 && !this.player.field_71075_bZ.field_75100_b && this.player.field_70170_p.func_72820_D() % 2L == 0L) {
            this.player.field_70159_w *= 1.15;
            this.player.field_70179_y *= 1.15;
        }
        for (SkillBase skill : this.skills.values()) {
            skill.onUpdate(this.player);
        }
        if (this.player.field_70170_p.field_72995_K && ZSSKeyHandler.keys[6].func_151470_d() && this.isSkillActive(SkillBase.swordBasic) && this.player.func_70694_bm() != null) {
            Minecraft.func_71410_x().field_71442_b.func_78769_a(this.player, this.player.field_70170_p, this.player.func_70694_bm());
        }
    }

    private void updateNayru() {
        this.player.field_70172_ad = this.player.field_70771_an;
        if (this.player.field_70173_aa % 16 == 0) {
            this.player.func_71020_j(3.0f);
        }
        if (this.player.func_71024_bL().func_75116_a() == 0) {
            this.setFlag((byte)4, false);
        } else {
            WorldUtils.sendPacketToAllAround(new SpawnNayruParticlesPacket(this.player), this.player.field_70170_p, this.player, 64.0);
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ZSSPlayerInfo(player));
    }

    public static final ZSSPlayerInfo get(EntityPlayer player) {
        return (ZSSPlayerInfo)player.getExtendedProperties(EXT_PROP_NAME);
    }

    private static final String getSaveKey(EntityPlayer player) {
        return player.func_70005_c_() + ":" + EXT_PROP_NAME;
    }

    public static final void saveProxyData(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        ZSSPlayerInfo.get(player).saveNBTData(tag);
        CommonProxy.storeEntityData(ZSSPlayerInfo.getSaveKey(player), tag);
    }

    public static final void loadProxyData(EntityPlayer player) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
        NBTTagCompound tag = CommonProxy.getEntityData(ZSSPlayerInfo.getSaveKey(player));
        if (tag != null) {
            info.loadNBTData(tag);
        }
        info.validateSkills();
        ZSSMain.dispatcher.sendTo(new SyncPlayerInfoPacket(info), (EntityPlayerMP)player);
    }

    public final void validateSkills() {
        for (SkillBase skill : this.skills.values()) {
            skill.validateSkill(this.player);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList taglist = new NBTTagList();
        for (SkillBase skill : this.skills.values()) {
            NBTTagCompound skillTag = new NBTTagCompound();
            skill.writeToNBT(skillTag);
            taglist.func_74742_a((NBTBase)skillTag);
        }
        compound.func_74782_a("ZeldaSwordSkills", (NBTBase)taglist);
        compound.func_74783_a("zssStats", ArrayUtils.toPrimitive((Integer[])this.playerStats.values().toArray(new Integer[this.playerStats.size()])));
        compound.func_74774_a("ZSSGearReceived", this.receivedGear);
        compound.func_74768_a("lastBoots", Item.func_150891_b((Item)this.lastBootsWorn));
        compound.func_74768_a("fairySpinOrbsReceived", this.fairySpinOrbsReceived);
        compound.func_74768_a("borrowedMask", this.borrowedMask != null ? Item.func_150891_b((Item)this.borrowedMask) : -1);
        compound.func_74768_a("maskStage", this.maskStage);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.skills.clear();
        NBTTagList taglist = compound.func_150295_c("ZeldaSwordSkills", 10);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound skill = taglist.func_150305_b(i);
            byte id = skill.func_74771_c("id");
            this.skills.put(id, SkillBase.getSkill(id).loadFromNBT(skill));
        }
        int[] stats = compound.func_74759_k("zssStats");
        for (int i = 0; i < stats.length; ++i) {
            this.playerStats.put(Stats.values()[i], stats[i]);
        }
        this.receivedGear = compound.func_74771_c("ZSSGearReceived");
        this.lastBootsWorn = Item.func_150899_d((int)compound.func_74762_e("lastBoots"));
        this.fairySpinOrbsReceived = compound.func_74762_e("fairySpinOrbsReceived");
        int maskID = compound.func_74762_e("borrowedMask");
        this.borrowedMask = maskID > -1 ? Item.func_150899_d((int)maskID) : null;
        this.maskStage = compound.func_74762_e("maskStage");
    }

    public void init(Entity entity, World world) {
    }

    public static enum Stats {
        STAT_SECRET_ROOMS,
        STAT_BOSS_ROOMS;

    }
}

