/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.buff.BuffBase;
import zeldaswordskills.lib.Config;

public class ZSSEntityInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "ZSSEntityInfo";
    private final EntityLivingBase entity;
    private Map<Buff, BuffBase> activeBuffs = new EnumMap<Buff, BuffBase>(Buff.class);
    private int stunResistTime;

    public ZSSEntityInfo(EntityLivingBase entity) {
        this.entity = entity;
    }

    public void init(Entity entity, World world) {
    }

    public boolean isBuffActive(Buff buff) {
        return this.activeBuffs.containsKey((Object)buff);
    }

    public BuffBase getActiveBuff(Buff buff) {
        return this.activeBuffs.get((Object)buff);
    }

    public int getBuffAmplifier(Buff buff) {
        return this.isBuffActive(buff) ? this.getActiveBuff(buff).getAmplifier() : 0;
    }

    public boolean isBuffPermanent(Buff buff) {
        return this.isBuffActive(buff) && this.getActiveBuff(buff).isPermanent();
    }

    public Map<Buff, BuffBase> getActiveBuffsMap() {
        return this.activeBuffs;
    }

    public void applyBuff(Buff buff, int duration, int amplifier) {
        this.applyBuff(new BuffBase(buff, duration, amplifier));
    }

    public void applyBuff(BuffBase newBuff) {
        if (this.isBuffActive(newBuff.getBuff())) {
            this.getActiveBuff(newBuff.getBuff()).combine(newBuff);
            this.getActiveBuff(newBuff.getBuff()).onChanged(this.entity);
        } else {
            this.activeBuffs.put(newBuff.getBuff(), newBuff);
            newBuff.onAdded(this.entity);
        }
    }

    public void removeAllBuffs() {
        if (!this.entity.field_70170_p.field_72995_K) {
            Iterator<Buff> iterator = this.activeBuffs.keySet().iterator();
            while (iterator.hasNext()) {
                Buff buff = iterator.next();
                this.activeBuffs.get((Object)buff).onRemoved(this.entity);
                iterator.remove();
            }
        }
    }

    public void removeBuff(Buff buff) {
        BuffBase buffBase = this.activeBuffs.remove((Object)buff);
        if (buffBase != null) {
            buffBase.onRemoved(this.entity);
        }
    }

    protected void updateBuffs() {
        for (BuffBase buff : this.activeBuffs.values()) {
            if (!buff.onUpdate(this.entity)) continue;
            this.removeBuff(buff.getBuff());
        }
    }

    public void stun(int time) {
        this.stun(time, false);
    }

    public void stun(int time, boolean alwaysStuns) {
        int stunTime;
        int n = stunTime = this.stunResistTime > 0 || !alwaysStuns && this.isImmuneToStun() ? 0 : time;
        if (stunTime > 0) {
            stunTime = (int)((float)stunTime * (1.0f + (float)this.getBuffAmplifier(Buff.RESIST_STUN) * 0.01f));
            if ((stunTime = (int)((float)stunTime * (1.0f - (float)this.getBuffAmplifier(Buff.RESIST_STUN) * 0.01f))) > 0) {
                this.stunResistTime = 40;
                this.applyBuff(new BuffBase(Buff.STUN, stunTime, 0));
            }
        }
    }

    public boolean isImmuneToStun() {
        return this.entity instanceof EntityPlayer && !Config.canPlayersBeStunned() || this.entity instanceof IBossDisplayData;
    }

    public void onUpdate() {
        this.updateBuffs();
        if (this.stunResistTime > 0 && !this.isBuffActive(Buff.STUN)) {
            --this.stunResistTime;
        }
    }

    public static final void register(EntityLivingBase entity) {
        entity.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ZSSEntityInfo(entity));
    }

    public static final ZSSEntityInfo get(EntityLivingBase entity) {
        return (ZSSEntityInfo)entity.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        if (!this.activeBuffs.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (BuffBase buff : this.activeBuffs.values()) {
                list.func_74742_a((NBTBase)buff.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("ActiveBuffs", (NBTBase)list);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b("ActiveBuffs")) {
            NBTTagList list = compound.func_150295_c("ActiveBuffs", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                BuffBase buff = BuffBase.readFromNBT(tag);
                this.activeBuffs.put(buff.getBuff(), buff);
            }
        }
    }
}

